/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public enum TimeUnit {
    ms("Millisecond", 1L),
    s("Second", 1000L),
    min("Minute", 60L * TimeUnit.s.msec),
    h("Hour", 60L * TimeUnit.min.msec),
    d("Day", 24L * TimeUnit.h.msec),
    a("Year", 365L * TimeUnit.d.msec),
    y("Year", 365L * TimeUnit.d.msec);

    private final String displayName;
    private final long msec;

    private TimeUnit(String displayName, long msec) {
        this.displayName = displayName;
        this.msec = msec;
    }

    public long toMillis(long value) {
        return value * this.msec;
    }

    public long toMillis() {
        return this.msec;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static String getAllUnitsWithDisplayName() {
        return TimeUnit.getAllUnitsWithDisplayName(", ");
    }

    public static String getAllUnitsWithDisplayName(String separator) {
        return TimeUnit.getAllUnitsWithDisplayName("%s (%s)", separator);
    }

    public static String getAllUnitsWithDisplayName(String unitFormat, String separator) {
        StringBuilder sb = new StringBuilder();
        for (TimeUnit u : TimeUnit.values()) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(String.format(unitFormat, u.name(), u.getDisplayName()));
        }
        return sb.toString();
    }

    public static List<TimeUnit> getUniqueTimeUnitsOrderedByLengthAsc() {
        ArrayList<TimeUnit> result = new ArrayList<TimeUnit>(Arrays.asList(TimeUnit.values()));
        result.remove((Object)y);
        return Collections.unmodifiableList(result);
    }

    public static List<TimeUnit> getUniqueTimeUnitsOrderedByLengthDesc() {
        List<TimeUnit> asc = TimeUnit.getUniqueTimeUnitsOrderedByLengthAsc();
        ArrayList<TimeUnit> desc = new ArrayList<TimeUnit>(asc.size());
        ListIterator<TimeUnit> it = asc.listIterator(asc.size());
        while (it.hasPrevious()) {
            TimeUnit timeUnit = it.previous();
            desc.add(timeUnit);
        }
        return desc;
    }
}

