/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.config;

import co.codewizards.cloudstore.core.appid.AppIdRegistry;
import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoHelper;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigImpl
implements Config {
    private static final Logger logger = LoggerFactory.getLogger(ConfigImpl.class);
    private static final long fileRefsCleanPeriod = 60000L;
    private static long fileRefsCleanLastTimestamp;
    @Deprecated
    private static final String PROPERTIES_FILE_NAME_FOR_DIRECTORY_VISIBLE;
    private static final String PROPERTIES_TEMPLATE_FILE_NAME = "cloudstore.properties";
    private static final String PROPERTIES_FILE_FORMAT_FOR_FILE_HIDDEN;
    @Deprecated
    private static final String PROPERTIES_FILE_FORMAT_FOR_FILE_VISIBLE;
    private static final String TRUE_STRING;
    private static final String FALSE_STRING;
    private static final LinkedHashSet<File> fileHardRefs;
    private static final int fileHardRefsMaxSize = 30;
    private static final LinkedList<SoftReference<File>> fileSoftRefs;
    private static final Map<File, ConfigImpl> file2Config;
    private final ConfigImpl parentConfig;
    private final WeakReference<File> fileRef;
    protected final File[] propertiesFiles;
    private final long[] propertiesFilesLastModified;
    protected final Properties properties;
    private static final Object classMutex;
    private final Object instanceMutex;
    private long version = 0L;

    protected ConfigImpl(ConfigImpl parentConfig, File file, File[] propertiesFiles) {
        this.parentConfig = parentConfig;
        this.fileRef = parentConfig == null ? null : new WeakReference<File>(AssertUtil.assertNotNull(file, "file"));
        this.propertiesFiles = AssertUtil.assertNotNullAndNoNullElement(propertiesFiles, "propertiesFiles");
        this.properties = new Properties(parentConfig == null ? null : parentConfig.properties);
        this.propertiesFilesLastModified = new long[propertiesFiles.length];
        this.instanceMutex = this.properties;
        if (parentConfig == null && !propertiesFiles[0].exists()) {
            try {
                AppIdRegistry.getInstance().copyResourceResolvingAppId(ConfigImpl.class, "/cloudstore.properties", propertiesFiles[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected File getFile() {
        return this.fileRef == null ? null : (File)this.fileRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanFileRefs() {
        Object object = classMutex;
        synchronized (object) {
            if (System.currentTimeMillis() - fileRefsCleanLastTimestamp < 60000L) {
                return;
            }
            Iterator it = fileSoftRefs.iterator();
            while (it.hasNext()) {
                SoftReference fileRef = (SoftReference)it.next();
                if (fileRef.get() != null) continue;
                it.remove();
            }
            fileRefsCleanLastTimestamp = System.currentTimeMillis();
        }
    }

    public static Config getInstance() {
        return ConfigHolder.instance;
    }

    public static Config getInstanceForDirectory(File directory) {
        return ConfigImpl.getInstance(directory, true);
    }

    public static Config getInstanceForFile(File file) {
        return ConfigImpl.getInstance(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Config getInstance(File file, boolean isDirectory) {
        ConfigImpl config;
        AssertUtil.assertNotNull(file, "file");
        ConfigImpl.cleanFileRefs();
        File config_file = null;
        Object object = classMutex;
        synchronized (object) {
            config = file2Config.get(file);
            if (config != null && (config_file = config.getFile()) == null) {
                config = null;
            }
            if (config == null) {
                File localRoot = LocalRepoHelper.getLocalRootContainingFile(file);
                if (localRoot == null) {
                    throw new IllegalArgumentException("file is not inside a repository: " + file.getAbsolutePath());
                }
                ConfigImpl parentConfig = (ConfigImpl)(localRoot == file ? ConfigImpl.getInstance() : ConfigImpl.getInstance(file.getParentFile(), true));
                config = new ConfigImpl(parentConfig, file, ConfigImpl.createPropertiesFiles(file, isDirectory));
                file2Config.put(file, config);
                fileSoftRefs.add(new SoftReference<File>(file));
                config_file = config.getFile();
            }
            AssertUtil.assertNotNull(config_file, "config_file");
        }
        ConfigImpl.refreshFileHardRefAndCleanOldHardRefs(config_file);
        return config;
    }

    private static File[] createPropertiesFiles(File file, boolean isDirectory) {
        if (isDirectory) {
            ArrayList<File> files = new ArrayList<File>();
            File metaDir = OioFileFactory.createFile(file, LocalRepoManager.META_DIR_NAME);
            if (metaDir.isDirectory()) {
                files.add(OioFileFactory.createFile(metaDir, "parent.properties"));
            }
            files.add(OioFileFactory.createFile(file, PROPERTIES_FILE_NAME_FOR_DIRECTORY));
            files.add(OioFileFactory.createFile(file, PROPERTIES_FILE_NAME_FOR_DIRECTORY_VISIBLE));
            files.add(OioFileFactory.createFile(file, PROPERTIES_FILE_NAME_FOR_DIRECTORY_LOCAL));
            return files.toArray(new File[files.size()]);
        }
        return new File[]{OioFileFactory.createFile(file.getParentFile(), String.format(PROPERTIES_FILE_FORMAT_FOR_FILE_HIDDEN, file.getName())), OioFileFactory.createFile(file.getParentFile(), String.format(PROPERTIES_FILE_FORMAT_FOR_FILE_VISIBLE, file.getName()))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIfNeeded() {
        Object object = this.instanceMutex;
        synchronized (object) {
            for (int i = 0; i < this.propertiesFiles.length; ++i) {
                File propertiesFile = this.propertiesFiles[i];
                long lastModified = this.propertiesFilesLastModified[i];
                if (propertiesFile.lastModified() == lastModified) continue;
                this.read();
                break;
            }
        }
        if (this.parentConfig != null) {
            this.parentConfig.readIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        Object object = this.instanceMutex;
        synchronized (object) {
            logger.trace("read: Entered instanceMutex.");
            try {
                this.properties.clear();
                this.version = 0L;
                for (int i = 0; i < this.propertiesFiles.length; ++i) {
                    File propertiesFile = this.propertiesFiles[i];
                    logger.debug("read: Reading propertiesFile '{}'.", (Object)propertiesFile.getAbsolutePath());
                    long lastModified = this.getLastModifiedAndWaitIfNeeded(propertiesFile);
                    if (propertiesFile.exists()) {
                        try (LockFile lockFile = LockFileFactory.getInstance().acquire(propertiesFile, 10000L);
                             InputStream in = StreamUtil.castStream(lockFile.createInputStream());){
                            this.properties.load(in);
                        }
                    }
                    this.propertiesFilesLastModified[i] = lastModified;
                    this.version += lastModified;
                }
            }
            catch (IOException e) {
                this.properties.clear();
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() {
        Object object = this.instanceMutex;
        synchronized (object) {
            logger.trace("read: Entered instanceMutex.");
            try {
                File propertiesFile = this.getSinglePropertiesFile();
                if (propertiesFile == null) {
                    propertiesFile = this.propertiesFiles[this.propertiesFiles.length - 1];
                }
                logger.debug("write: Writing propertiesFile '{}'.", (Object)propertiesFile.getAbsolutePath());
                try (LockFile lockFile = LockFileFactory.getInstance().acquire(propertiesFile, 10000L);
                     OutputStream out = StreamUtil.castStream(lockFile.createOutputStream());){
                    this.properties.store(out, null);
                }
            }
            catch (IOException e) {
                this.properties.clear();
                throw new RuntimeException(e);
            }
        }
    }

    private File getSinglePropertiesFile() {
        File result = null;
        for (File propertiesFile : this.propertiesFiles) {
            if (!propertiesFile.exists()) continue;
            if (result == null) {
                result = propertiesFile;
                continue;
            }
            return null;
        }
        return result;
    }

    private long getLastModifiedAndWaitIfNeeded(File file) {
        AssertUtil.assertNotNull(file, "file");
        long lastModified = file.lastModified();
        long now = System.currentTimeMillis();
        if (lastModified > now) {
            file.setLastModified(now);
            logger.warn("getLastModifiedAndWaitIfNeeded: lastModified of '{}' was in the future! Changed it to now!", (Object)file.getAbsolutePath());
            lastModified = file.lastModified();
            if (lastModified > now) {
                logger.error("getLastModifiedAndWaitIfNeeded: lastModified of '{}' is in the future! Changing it FAILED! Permissions?!", (Object)file.getAbsolutePath());
                return lastModified;
            }
        }
        long fileSystemTemporalGranularity = 2000L;
        long modificationAge = now - lastModified;
        long waitPeriod = 2000L - modificationAge;
        if (waitPeriod > 0L) {
            logger.info("getLastModifiedAndWaitIfNeeded: Waiting {} ms.", (Object)waitPeriod);
            try {
                Thread.sleep(waitPeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getVersion() {
        long result;
        Object object = this.instanceMutex;
        synchronized (object) {
            this.readIfNeeded();
            result = this.version;
        }
        if (this.parentConfig != null) {
            result += this.parentConfig.getVersion();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String key, String defaultValue) {
        AssertUtil.assertNotNull(key, "key");
        this.refreshFileHardRefAndCleanOldHardRefs();
        String sysPropKey = SYSTEM_PROPERTY_PREFIX + key;
        String sysPropVal = System.getProperty(sysPropKey);
        if (sysPropVal != null) {
            logger.debug("getProperty: System property with key='{}' and value='{}' overrides config (config is not queried).", (Object)sysPropKey, (Object)sysPropVal);
            return sysPropVal;
        }
        String envVarKey = PropertiesUtil.systemPropertyToEnvironmentVariable(sysPropKey);
        String envVarVal = System.getenv(envVarKey);
        if (envVarVal != null) {
            logger.debug("getProperty: Environment variable with key='{}' and value='{}' overrides config (config is not queried).", (Object)envVarKey, (Object)envVarVal);
            return envVarVal;
        }
        logger.debug("getProperty: System property with key='{}' is not set (config is queried next).", (Object)sysPropKey);
        Object object = this.instanceMutex;
        synchronized (object) {
            this.readIfNeeded();
            return this.properties.getProperty(key, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDirectProperty(String key) {
        AssertUtil.assertNotNull(key, "key");
        String sysPropKey = SYSTEM_PROPERTY_PREFIX + key;
        String sysPropVal = System.getProperty(sysPropKey);
        if (sysPropVal != null) {
            logger.debug("getProperty: System property with key='{}' and value='{}' overrides config (config is not queried).", (Object)sysPropKey, (Object)sysPropVal);
            return sysPropVal;
        }
        String envVarKey = PropertiesUtil.systemPropertyToEnvironmentVariable(sysPropKey);
        String envVarVal = System.getenv(envVarKey);
        if (envVarVal != null) {
            logger.debug("getProperty: Environment variable with key='{}' and value='{}' overrides config (config is not queried).", (Object)envVarKey, (Object)envVarVal);
            return envVarVal;
        }
        this.refreshFileHardRefAndCleanOldHardRefs();
        Object object = this.instanceMutex;
        synchronized (object) {
            this.readIfNeeded();
            return (String)this.properties.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDirectProperty(String key, String value) {
        AssertUtil.assertNotNull(key, "key");
        String sysPropKey = SYSTEM_PROPERTY_PREFIX + key;
        if (System.getProperty(sysPropKey) != null) {
            throw new IllegalStateException(String.format("System property with key='%s' overrides config. The property '%s' can therefore not be modified.", sysPropKey, key));
        }
        String envVarKey = PropertiesUtil.systemPropertyToEnvironmentVariable(sysPropKey);
        if (System.getenv(envVarKey) != null) {
            throw new IllegalStateException(String.format("Environment variable with key='%s' overrides config. The property '%s' can therefore not be modified.", envVarKey, key));
        }
        this.refreshFileHardRefAndCleanOldHardRefs();
        Object object = this.instanceMutex;
        synchronized (object) {
            this.readIfNeeded();
            if (value == null) {
                this.properties.remove(key);
            } else {
                this.properties.put(key, value);
            }
            this.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPropertyAsNonEmptyTrimmedString(String key, String defaultValue) {
        AssertUtil.assertNotNull(key, "key");
        this.refreshFileHardRefAndCleanOldHardRefs();
        String sysPropKey = SYSTEM_PROPERTY_PREFIX + key;
        String sysPropVal = StringUtil.trim(System.getProperty(sysPropKey));
        if (!StringUtil.isEmpty(sysPropVal)) {
            logger.debug("getPropertyAsNonEmptyTrimmedString: System property with key='{}' and value='{}' overrides config (config is not queried).", (Object)sysPropKey, (Object)sysPropVal);
            return sysPropVal;
        }
        String envVarKey = PropertiesUtil.systemPropertyToEnvironmentVariable(sysPropKey);
        String envVarVal = StringUtil.trim(System.getenv(envVarKey));
        if (!StringUtil.isEmpty(envVarVal)) {
            logger.debug("getPropertyAsNonEmptyTrimmedString: Environment variable with key='{}' and value='{}' overrides config (config is not queried).", (Object)envVarKey, (Object)envVarVal);
            return envVarVal;
        }
        logger.debug("getPropertyAsNonEmptyTrimmedString: System property with key='{}' is not set (config is queried next).", (Object)sysPropKey);
        Object object = this.instanceMutex;
        synchronized (object) {
            this.readIfNeeded();
            String sval = StringUtil.trim(this.properties.getProperty(key));
            if (StringUtil.isEmpty(sval)) {
                return defaultValue;
            }
            return sval;
        }
    }

    @Override
    public long getPropertyAsLong(String key, long defaultValue) {
        String sval = this.getPropertyAsNonEmptyTrimmedString(key, null);
        if (sval == null) {
            return defaultValue;
        }
        try {
            long lval = Long.parseLong(sval);
            return lval;
        }
        catch (NumberFormatException x) {
            logger.warn("getPropertyAsLong: One of the properties files %s contains the key '%s' (or the system properties override it) with the illegal value '%s'. Falling back to default value '%s'!", new Object[]{this.propertiesFiles, key, sval, defaultValue});
            return defaultValue;
        }
    }

    @Override
    public long getPropertyAsPositiveOrZeroLong(String key, long defaultValue) {
        long value = this.getPropertyAsLong(key, defaultValue);
        if (value < 0L) {
            logger.warn("getPropertyAsPositiveOrZeroLong: One of the properties files %s contains the key '%s' (or the system properties override it) with the negative value '%s' (only values >= 0 are allowed). Falling back to default value '%s'!", new Object[]{this.propertiesFiles, key, value, defaultValue});
            return defaultValue;
        }
        return value;
    }

    @Override
    public int getPropertyAsInt(String key, int defaultValue) {
        String sval = this.getPropertyAsNonEmptyTrimmedString(key, null);
        if (sval == null) {
            return defaultValue;
        }
        try {
            int ival = Integer.parseInt(sval);
            return ival;
        }
        catch (NumberFormatException x) {
            logger.warn("getPropertyAsInt: One of the properties files %s contains the key '%s' (or the system properties override it) with the illegal value '%s'. Falling back to default value '%s'!", new Object[]{this.propertiesFiles, key, sval, defaultValue});
            return defaultValue;
        }
    }

    @Override
    public int getPropertyAsPositiveOrZeroInt(String key, int defaultValue) {
        int value = this.getPropertyAsInt(key, defaultValue);
        if (value < 0) {
            logger.warn("getPropertyAsPositiveOrZeroInt: One of the properties files %s contains the key '%s' (or the system properties override it) with the negative value '%s' (only values >= 0 are allowed). Falling back to default value '%s'!", new Object[]{this.propertiesFiles, key, value, defaultValue});
            return defaultValue;
        }
        return value;
    }

    @Override
    public <E extends Enum<E>> E getPropertyAsEnum(String key, E defaultValue) {
        AssertUtil.assertNotNull(defaultValue, "defaultValue");
        Class<?> enumClass = defaultValue.getClass();
        return (E)this.getPropertyAsEnum(key, enumClass, defaultValue);
    }

    @Override
    public <E extends Enum<E>> E getPropertyAsEnum(String key, Class<E> enumClass, E defaultValue) {
        AssertUtil.assertNotNull(enumClass, "enumClass");
        String sval = this.getPropertyAsNonEmptyTrimmedString(key, null);
        if (sval == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumClass, sval);
        }
        catch (IllegalArgumentException x) {
            logger.warn("getPropertyAsEnum: One of the properties files %s contains the key '%s' with the illegal value '%s'. Falling back to default value '%s'!", new Object[]{this.propertiesFiles, key, sval, defaultValue});
            return defaultValue;
        }
    }

    @Override
    public boolean getPropertyAsBoolean(String key, boolean defaultValue) {
        String sval = this.getPropertyAsNonEmptyTrimmedString(key, null);
        if (sval == null) {
            return defaultValue;
        }
        if (TRUE_STRING.equalsIgnoreCase(sval)) {
            return true;
        }
        if (FALSE_STRING.equalsIgnoreCase(sval)) {
            return false;
        }
        logger.warn("getPropertyAsBoolean: One of the properties files %s contains the key '%s' with the illegal value '%s'. Falling back to default value '%s'!", new Object[]{this.propertiesFiles, key, sval, defaultValue});
        return defaultValue;
    }

    private static final void refreshFileHardRefAndCleanOldHardRefs(ConfigImpl config) {
        File config_file = AssertUtil.assertNotNull(config, "config").getFile();
        if (config_file != null) {
            ConfigImpl.refreshFileHardRefAndCleanOldHardRefs(config_file);
        }
    }

    private final void refreshFileHardRefAndCleanOldHardRefs() {
        if (this.parentConfig != null) {
            this.parentConfig.refreshFileHardRefAndCleanOldHardRefs();
        }
        ConfigImpl.refreshFileHardRefAndCleanOldHardRefs(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refreshFileHardRefAndCleanOldHardRefs(File config_file) {
        AssertUtil.assertNotNull(config_file, "config_file");
        LinkedHashSet<File> linkedHashSet = fileHardRefs;
        synchronized (linkedHashSet) {
            fileHardRefs.remove(config_file);
            fileHardRefs.add(config_file);
            while (fileHardRefs.size() > 30) {
                fileHardRefs.remove(fileHardRefs.iterator().next());
            }
        }
    }

    @Override
    public Map<String, List<String>> getKey2GroupsMatching(Pattern regex) {
        AssertUtil.assertNotNull(regex, "regex");
        this.refreshFileHardRefAndCleanOldHardRefs();
        HashMap<String, List<String>> key2Groups = new HashMap<String, List<String>>();
        this.populateKeysMatching(key2Groups, regex);
        return Collections.unmodifiableMap(key2Groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateKeysMatching(Map<String, List<String>> key2Groups, Pattern regex) {
        AssertUtil.assertNotNull(key2Groups, "key2Groups");
        AssertUtil.assertNotNull(regex, "regex");
        if (this.parentConfig != null) {
            this.parentConfig.populateKeysMatching(key2Groups, regex);
        }
        Object object = this.instanceMutex;
        synchronized (object) {
            this.readIfNeeded();
            for (Object k : this.properties.keySet()) {
                Matcher matcher;
                String key = (String)k;
                if (key2Groups.containsKey(key) || !(matcher = regex.matcher(key)).matches()) continue;
                int groupCount = matcher.groupCount();
                ArrayList<String> groups = new ArrayList<String>(groupCount);
                for (int i = 1; i <= groupCount; ++i) {
                    groups.add(matcher.group(i));
                }
                key2Groups.put(key, Collections.unmodifiableList(groups));
            }
        }
    }

    static /* synthetic */ String access$000() {
        return PROPERTIES_FILE_NAME_FOR_DIRECTORY_VISIBLE;
    }

    static {
        PROPERTIES_FILE_NAME_FOR_DIRECTORY_VISIBLE = APP_ID_SIMPLE_ID + ".properties";
        PROPERTIES_FILE_FORMAT_FOR_FILE_HIDDEN = ".%s." + APP_ID_SIMPLE_ID + ".properties";
        PROPERTIES_FILE_FORMAT_FOR_FILE_VISIBLE = "%s." + APP_ID_SIMPLE_ID + ".properties";
        TRUE_STRING = Boolean.TRUE.toString();
        FALSE_STRING = Boolean.FALSE.toString();
        fileHardRefs = new LinkedHashSet();
        fileSoftRefs = new LinkedList();
        file2Config = new WeakHashMap<File, ConfigImpl>();
        classMutex = ConfigImpl.class;
    }

    private static final class ConfigHolder {
        public static final ConfigImpl instance = new ConfigImpl(null, null, new File[]{OioFileFactory.createFile(ConfigDir.getInstance().getFile(), ConfigImpl.access$000())});

        private ConfigHolder() {
        }
    }
}

