/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import co.codewizards.cloudstore.local.persistence.LocalRepository;
import co.codewizards.cloudstore.local.persistence.LocalRepositoryDao;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOHelper;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Indices;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PersistenceCapable
@Discriminator(strategy=DiscriminatorStrategy.VALUE_MAP)
@Unique(name="RepoFile_parent_name", members={"parent", "name"})
@Indices(value={@Index(name="RepoFile_parent", members={"parent"}), @Index(name="RepoFile_localRevision", members={"localRevision"})})
@Queries(value={@Query(name="getChildRepoFile_parent_name", value="SELECT UNIQUE WHERE this.parent == :parent && this.name == :name"), @Query(name="getChildRepoFiles_parent", value="SELECT WHERE this.parent == :parent"), @Query(name="getRepoFilesChangedAfter_localRevision_exclLastSyncFromRepositoryId", value="SELECT WHERE this.localRevision > :localRevision && (this.lastSyncFromRepositoryId == null || this.lastSyncFromRepositoryId != :lastSyncFromRepositoryId)")})
public abstract class RepoFile
extends Entity
implements AutoTrackLocalRevision,
Persistable {
    private static final Logger logger = LoggerFactory.getLogger(RepoFile.class);
    private RepoFile parent;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private String name;
    private long localRevision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private Date lastModified;
    private String lastSyncFromRepositoryId;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public RepoFile getParent() {
        return RepoFile.dnGetparent(this);
    }

    public void setParent(RepoFile parent) {
        if (!Util.equal((Object)RepoFile.dnGetparent(this), (Object)parent)) {
            RepoFile.dnSetparent(this, parent);
        }
    }

    public String getName() {
        return RepoFile.dnGetname(this);
    }

    public void setName(String name) {
        if (!Util.equal((Object)RepoFile.dnGetname(this), (Object)name)) {
            RepoFile.dnSetname(this, name);
        }
    }

    @Override
    public long getLocalRevision() {
        return RepoFile.dnGetlocalRevision(this);
    }

    @Override
    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)RepoFile.dnGetlocalRevision(this), (long)localRevision)) {
            if (logger.isDebugEnabled()) {
                LocalRepository localRepository = ((LocalRepositoryDao)new LocalRepositoryDao().persistenceManager(JDOHelper.getPersistenceManager((Object)this))).getLocalRepositoryOrFail();
                logger.debug("setLocalRevision: localRepositoryId={} path='{}' old={} new={}", new Object[]{localRepository.getRepositoryId(), this.getPath(), RepoFile.dnGetlocalRevision(this), localRevision});
            }
            RepoFile.dnSetlocalRevision(this, localRevision);
        }
    }

    public List<RepoFile> getPathList() {
        LinkedList<RepoFile> path = new LinkedList<RepoFile>();
        for (RepoFile rf = this; rf != null; rf = rf.getParent()) {
            path.addFirst(rf);
        }
        return Collections.unmodifiableList(path);
    }

    public String getPath() {
        StringBuilder sb = new StringBuilder();
        for (RepoFile repoFile : this.getPathList()) {
            if (sb.length() == 0 || sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            sb.append(repoFile.getName());
        }
        return sb.toString();
    }

    public File getFile(File localRoot) {
        AssertUtil.assertNotNull((Object)localRoot, (String)"localRoot");
        File result = localRoot;
        for (RepoFile repoFile : this.getPathList()) {
            if (repoFile.getParent() == null) continue;
            result = OioFileFactory.createFile((File)result, (String[])new String[]{repoFile.getName()});
        }
        return result;
    }

    public Date getLastModified() {
        return RepoFile.dnGetlastModified(this);
    }

    public void setLastModified(Date lastModified) {
        if (!Util.equal((Object)RepoFile.dnGetlastModified(this), (Object)lastModified)) {
            RepoFile.dnSetlastModified(this, lastModified);
        }
    }

    public UUID getLastSyncFromRepositoryId() {
        return RepoFile.dnGetlastSyncFromRepositoryId(this) == null ? null : UUID.fromString(RepoFile.dnGetlastSyncFromRepositoryId(this));
    }

    public void setLastSyncFromRepositoryId(UUID repositoryId) {
        if (!Util.equal((Object)this.getLastSyncFromRepositoryId(), (Object)repositoryId)) {
            RepoFile.dnSetlastSyncFromRepositoryId(this, repositoryId == null ? null : repositoryId.toString());
        }
    }

    static {
        dnFieldNames = RepoFile.__dnFieldNamesInit();
        dnFieldTypes = RepoFile.__dnFieldTypesInit();
        dnFieldFlags = RepoFile.__dnFieldFlagsInit();
        dnInheritedFieldCount = RepoFile.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = RepoFile.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)RepoFile.___dn$loadClass("co.codewizards.cloudstore.local.persistence.RepoFile"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, null);
    }

    @Override
    public boolean dnIsDetached() {
        return false;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm) {
        throw new JDOFatalInternalException("Cannot instantiate abstract class.");
    }

    @Override
    public Persistable dnNewInstance(StateManager sm, Object obj) {
        throw new JDOFatalInternalException("Cannot instantiate abstract class.");
    }

    @Override
    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.lastModified = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.lastSyncFromRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 3: {
                this.name = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 4: {
                this.parent = (RepoFile)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    @Override
    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.lastModified);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.lastSyncFromRepositoryId);
                break;
            }
            case 2: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.name);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.parent);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(RepoFile obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.lastModified = obj.lastModified;
                break;
            }
            case 1: {
                this.lastSyncFromRepositoryId = obj.lastSyncFromRepositoryId;
                break;
            }
            case 2: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 3: {
                this.name = obj.name;
                break;
            }
            case 4: {
                this.parent = obj.parent;
                break;
            }
            default: {
                super.dnCopyField(obj, index);
            }
        }
    }

    @Override
    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof RepoFile)) {
            throw new IllegalArgumentException("object is not an object of type co.codewizards.cloudstore.local.persistence.RepoFile");
        }
        RepoFile other = (RepoFile)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"lastModified", "lastSyncFromRepositoryId", "localRevision", "name", "parent"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{RepoFile.___dn$loadClass("java.util.Date"), RepoFile.___dn$loadClass("java.lang.String"), Long.TYPE, RepoFile.___dn$loadClass("java.lang.String"), RepoFile.___dn$loadClass("co.codewizards.cloudstore.local.persistence.RepoFile")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 5 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return RepoFile.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        RepoFile o = (RepoFile)super.clone();
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static Date dnGetlastModified(RepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.lastModified);
        }
        return objPC.lastModified;
    }

    private static void dnSetlastModified(RepoFile objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.lastModified, (Object)val);
        } else {
            objPC.lastModified = val;
        }
    }

    private static String dnGetlastSyncFromRepositoryId(RepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId);
        }
        return objPC.lastSyncFromRepositoryId;
    }

    private static void dnSetlastSyncFromRepositoryId(RepoFile objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId, val);
        } else {
            objPC.lastSyncFromRepositoryId = val;
        }
    }

    private static long dnGetlocalRevision(RepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(RepoFile objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static String dnGetname(RepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.name);
        }
        return objPC.name;
    }

    private static void dnSetname(RepoFile objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.name, val);
        } else {
            objPC.name = val;
        }
    }

    private static RepoFile dnGetparent(RepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return (RepoFile)objPC.dnStateManager.getObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.parent);
        }
        return objPC.parent;
    }

    private static void dnSetparent(RepoFile objPC, RepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.parent = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.parent, (Object)val);
        }
    }
}

