/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.key;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.wot.internal.Util;
import org.bouncycastle.openpgp.wot.key.PgpKeyFingerprint;
import org.bouncycastle.openpgp.wot.key.PgpKeyId;
import org.bouncycastle.openpgp.wot.key.PgpUserId;

public class PgpKey {
    private final PgpKeyId pgpKeyId;
    private final PgpKeyFingerprint pgpKeyFingerprint;
    private PGPPublicKeyRing publicKeyRing;
    private PGPSecretKeyRing secretKeyRing;
    private PGPPublicKey publicKey;
    private PGPSecretKey secretKey;
    private PgpKey masterKey;
    private Set<PgpKeyId> subKeyIds;
    private List<PgpKey> subKeys;
    private volatile List<PgpUserId> pgpUserIds;

    public PgpKey(PgpKeyId pgpKeyId, PgpKeyFingerprint pgpKeyFingerprint) {
        this.pgpKeyId = Util.assertNotNull(pgpKeyId, "pgpKeyId");
        this.pgpKeyFingerprint = Util.assertNotNull(pgpKeyFingerprint, "pgpKeyFingerprint");
    }

    public PgpKeyId getPgpKeyId() {
        return this.pgpKeyId;
    }

    public PgpKeyFingerprint getPgpKeyFingerprint() {
        return this.pgpKeyFingerprint;
    }

    public PGPPublicKeyRing getPublicKeyRing() {
        return this.publicKeyRing;
    }

    protected void setPublicKeyRing(PGPPublicKeyRing publicKeyRing) {
        this.publicKeyRing = publicKeyRing;
    }

    public PGPSecretKeyRing getSecretKeyRing() {
        return this.secretKeyRing;
    }

    protected void setSecretKeyRing(PGPSecretKeyRing secretKeyRing) {
        this.secretKeyRing = secretKeyRing;
    }

    public PGPPublicKey getPublicKey() {
        return this.publicKey;
    }

    protected void setPublicKey(PGPPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PGPSecretKey getSecretKey() {
        return this.secretKey;
    }

    protected void setSecretKey(PGPSecretKey secretKey) {
        this.secretKey = secretKey;
    }

    public List<PgpUserId> getPgpUserIds() {
        if (this.pgpUserIds == null) {
            ArrayList<PgpUserId> l = new ArrayList<PgpUserId>();
            Iterator it = this.publicKey.getUserIDs();
            while (it.hasNext()) {
                String userId = (String)it.next();
                l.add(new PgpUserId(this, userId));
            }
            it = this.publicKey.getUserAttributes();
            while (it.hasNext()) {
                PGPUserAttributeSubpacketVector userAttribute = (PGPUserAttributeSubpacketVector)it.next();
                l.add(new PgpUserId(this, userAttribute));
            }
            this.pgpUserIds = Collections.unmodifiableList(l);
        }
        return this.pgpUserIds;
    }

    public PgpKey getMasterKey() {
        return this.masterKey;
    }

    protected void setMasterKey(PgpKey masterKey) {
        this.masterKey = masterKey;
    }

    public Set<PgpKeyId> getSubKeyIds() {
        if (this.masterKey != null) {
            return null;
        }
        if (this.subKeyIds == null) {
            this.subKeyIds = new LinkedHashSet<PgpKeyId>();
        }
        return this.subKeyIds;
    }

    protected void setSubKeyIds(Set<PgpKeyId> subKeyIds) {
        if (this.masterKey != null) {
            throw new IllegalStateException("This is not a master-key! Cannot assign sub-keys!");
        }
        this.subKeyIds = subKeyIds;
    }

    public List<PgpKey> getSubKeys() {
        return this.subKeys;
    }

    protected void setSubKeys(List<PgpKey> subKeys) {
        this.subKeys = subKeys;
    }

    public String toString() {
        Iterator userIdIt = this.publicKey.getUserIDs();
        String primaryUserId = userIdIt == null || !userIdIt.hasNext() ? null : (String)userIdIt.next();
        return String.format("%s[pgpKeyId=%s masterKey=%s primaryUserId=%s]", this.getClass().getSimpleName(), this.pgpKeyId, this.masterKey, primaryUserId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pgpKeyId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PgpKey other = (PgpKey)obj;
        return this.pgpKeyId.equals(other.pgpKeyId);
    }
}

