/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.maintree;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.subshare.core.repo.LocalRepo;
import org.subshare.gui.localrepo.LocalRepoPane;
import org.subshare.gui.maintree.LocalRepoDirectoryMainTreeItem;
import org.subshare.gui.maintree.MainTreeItem;
import org.subshare.gui.maintree.ServerListMainTreeItem;

public class LocalRepoMainTreeItem
extends MainTreeItem<LocalRepo> {
    private static final Image icon = new Image(ServerListMainTreeItem.class.getResource("local-repo_16x16.png").toExternalForm());

    public LocalRepoMainTreeItem(LocalRepo localRepo) {
        super(AssertUtil.assertNotNull((Object)localRepo, (String)"localRepo"));
        this.setGraphic((Node)new ImageView(icon));
        this.getChildren().add((Object)new LocalRepoDirectoryMainTreeItem(localRepo.getLocalRoot()));
    }

    public LocalRepo getLocalRepo() {
        return (LocalRepo)this.getValueObject();
    }

    @Override
    protected String getValueString() {
        LocalRepo localRepo = this.getLocalRepo();
        String name = localRepo.getName();
        if (!StringUtil.isEmpty((String)name)) {
            return name;
        }
        return localRepo.getLocalRoot().getName();
    }

    @Override
    protected Parent createMainDetailContent() {
        return new LocalRepoPane(this.getLocalRepo());
    }
}

