/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.ls.core.invoke.filter;

import co.codewizards.cloudstore.core.util.ReflectionUtil;
import co.codewizards.cloudstore.ls.core.invoke.filter.AbstractInvocationFilter;
import co.codewizards.cloudstore.ls.core.invoke.filter.ExtMethodInvocationRequest;
import java.lang.reflect.Proxy;
import org.subshare.core.pgp.PgpAuthenticationCallback;
import org.subshare.core.pgp.man.PgpPrivateKeyPassphraseStore;

public class AllowSubShareInvocationFilter
extends AbstractInvocationFilter {
    public Boolean canInvoke(ExtMethodInvocationRequest extMethodInvocationRequest) {
        Class targetClass = extMethodInvocationRequest.getTargetClass();
        if (PgpPrivateKeyPassphraseStore.class.isAssignableFrom(targetClass)) {
            return this.canInvoke_PgpPrivateKeyPassphraseStore(extMethodInvocationRequest);
        }
        if (PgpAuthenticationCallback.class.isAssignableFrom(targetClass)) {
            return false;
        }
        if (this.isWhiteListed(targetClass)) {
            return true;
        }
        if (Proxy.isProxyClass(targetClass)) {
            for (Class iface : ReflectionUtil.getAllInterfaces((Class)targetClass)) {
                if (!this.isWhiteListed(iface)) continue;
                return true;
            }
        }
        return null;
    }

    private boolean isWhiteListed(Class<?> classOrInterface) {
        return classOrInterface.getName().startsWith("org.subshare.");
    }

    private boolean canInvoke_PgpPrivateKeyPassphraseStore(ExtMethodInvocationRequest extMethodInvocationRequest) {
        String methodName = extMethodInvocationRequest.getMethodInvocationRequest().getMethodName();
        return "getInstance".equals(methodName) || "hasPassphrase".equals(methodName) || "putPassphrase".equals(methodName) || "getPgpKeyIdsHavingPassphrase".equals(methodName);
    }
}

