/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.backup;

import co.codewizards.cloudstore.core.io.IByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.ISO8601;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.client.util.ByteArrayOutputStreamLs;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeSet;
import org.subshare.core.locker.LockerContent;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.server.Server;
import org.subshare.core.server.ServerRegistryLockerContent;
import org.subshare.gui.backup.AbstractBackupImExporter;
import org.subshare.gui.backup.BackupDataFile;

public class BackupExporter
extends AbstractBackupImExporter {
    public void exportBackup(File backupFile) throws IOException {
        AssertUtil.assertNotNull((Object)backupFile, (String)"backupFile");
        Date now = new Date();
        backupFile.getParentFile().mkdirs();
        BackupDataFile backupDataFile = new BackupDataFile();
        backupDataFile.getManifestProperties().put("timestamp", ISO8601.formatDate((Date)new Date()));
        this.registerPgpKeyRelatedBackupProperties(now);
        IByteArrayOutputStream bout = ByteArrayOutputStreamLs.create();
        this.pgp.exportPublicKeysWithSecretKeys(new HashSet(this.pgp.getMasterKeysWithSecretKey()), (IOutputStream)bout);
        backupDataFile.putData("public+secret_keys.gpg", bout.toByteArray());
        this.registerServerRegistryRelatedBackupProperties(now);
        LockerContent serverRegistryLockerContent = (LockerContent)this.localServerClient.invokeConstructor(ServerRegistryLockerContent.class, new Object[0]);
        backupDataFile.putData("serverRegistry.subshare", serverRegistryLockerContent.getLocalData());
        try (OutputStream out = StreamUtil.castStream((IOutputStream)backupFile.createOutputStream());){
            backupDataFile.write(out);
        }
        this.writeBackupProperties();
    }

    public boolean isBackupNeeded() {
        return this.wasPrivateKeyAddedOrChangedAfterLastBackup() || this.wasServerAddedAfterLastBackup();
    }

    private boolean wasPrivateKeyAddedOrChangedAfterLastBackup() {
        HashSet masterKeysWithPrivateKey = new HashSet(this.pgp.getMasterKeysWithSecretKey());
        for (PgpKey masterKey : masterKeysWithPrivateKey) {
            String lastBackupUserIdsSha1;
            TreeSet userIds = new TreeSet();
            for (PgpKey pgpKey : masterKey.getMasterKeyAndSubKeys()) {
                PgpKeyId pgpKeyId = pgpKey.getPgpKeyId();
                Date lastBackupTimestamp = this.getPgpKeyLastBackupTimestamp(pgpKeyId);
                if (lastBackupTimestamp == null) {
                    return true;
                }
                userIds.addAll(pgpKey.getUserIds());
            }
            String userIdsString = ((Object)userIds).toString();
            String userIdsSha1 = HashUtil.sha1((String)userIdsString);
            if (Util.equal((Object)userIdsSha1, (Object)(lastBackupUserIdsSha1 = this.getPgpKeyLastBackupUserIdsSha1(masterKey.getPgpKeyId())))) continue;
            return true;
        }
        return false;
    }

    private boolean wasServerAddedAfterLastBackup() {
        String lastBackupSha1;
        if (this.serverRegistry.getServers().isEmpty()) {
            return false;
        }
        if (this.getServerRegistryLastBackupTimestamp() == null) {
            return true;
        }
        TreeSet<String> serverIdAndUrlPairs = new TreeSet<String>();
        for (Server server : this.serverRegistry.getServers()) {
            serverIdAndUrlPairs.add(BackupExporter.getServerIdAndUrlPair(server));
        }
        String serverIdAndUrlPairsString = ((Object)serverIdAndUrlPairs).toString();
        String serverIdAndUrlPairsSha1 = HashUtil.sha1((String)serverIdAndUrlPairsString);
        return !Util.equal((Object)serverIdAndUrlPairsSha1, (Object)(lastBackupSha1 = this.getServerRegistryLastBackupSha1()));
    }
}

