/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.filetree;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.subshare.gui.IconSize;
import org.subshare.gui.filetree.FileIconRegistry;
import org.subshare.gui.filetree.FileTreeItem;

public class FileFileTreeItem
extends FileTreeItem<File> {
    public FileFileTreeItem(File file) {
        super(AssertUtil.assertNotNull((Object)file, (String)"file"));
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("file not absolute!");
        }
        Image icon = FileIconRegistry.getInstance().getIcon(file, IconSize._16x16);
        this.setGraphic((Node)new ImageView(icon));
    }

    @Override
    protected void refresh() {
        super.refresh();
        this.refreshLastModified();
    }

    private void refreshLastModified() {
        this.lastModifiedProperty().set((Object)this._getLastModified());
    }

    public File getFile() {
        return (File)this.getValueObject();
    }

    @Override
    public String getName() {
        return this.getFile().getName();
    }

    private String _getLastModified() {
        if (!this.getFile().exists()) {
            return null;
        }
        Date date = new Date(this.getFile().getLastModifiedNoFollow());
        return DateFormat.getDateTimeInstance(3, 3).format(date);
    }

    @Override
    public FileTreeItem<?> findFirst(File file) {
        AssertUtil.assertNotNull((Object)file, (String)"file");
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("file not absolute!");
        }
        if (this.getFile().equals(file)) {
            return this;
        }
        String thisPath = this.getFile().getPath();
        String otherPath = file.getPath();
        if (!otherPath.startsWith(thisPath)) {
            return null;
        }
        if (!FileFileTreeItem.isParent(this.getFile(), file)) {
            return null;
        }
        for (TreeItem child : this.getChildren()) {
            FileTreeItem<?> treeItem = ((FileTreeItem)((Object)child.getValue())).findFirst(file);
            if (treeItem == null) continue;
            return treeItem;
        }
        return null;
    }

    private static boolean isParent(File parentCandidate, File childCandidate) {
        for (File f = childCandidate; f != null; f = f.getParentFile()) {
            if (!parentCandidate.equals(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FileTreeItem<?>> findAll(File file) {
        AssertUtil.assertNotNull((Object)file, (String)"file");
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("file not absolute!");
        }
        throw new UnsupportedOperationException("NYI");
    }
}

