/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.localrepo;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.TimePeriod;
import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncActivity;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncDaemon;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncState;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.adapter.JavaBeanObjectProperty;
import javafx.beans.property.adapter.JavaBeanObjectPropertyBuilder;
import javafx.beans.property.adapter.JavaBeanStringProperty;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.sync.RepoSyncTimer;
import org.subshare.gui.IconSize;
import org.subshare.gui.control.TimePeriodTextField;
import org.subshare.gui.error.ErrorHandler;
import org.subshare.gui.histo.HistoryPaneContainer;
import org.subshare.gui.histo.HistoryPaneSupport;
import org.subshare.gui.invitation.issue.IssueInvitationData;
import org.subshare.gui.invitation.issue.IssueInvitationWizard;
import org.subshare.gui.localrepo.userrepokeylist.UserRepoKeyListPane;
import org.subshare.gui.ls.ConfigLs;
import org.subshare.gui.ls.RepoSyncDaemonLs;
import org.subshare.gui.ls.RepoSyncTimerLs;
import org.subshare.gui.severity.SeverityImageRegistry;
import org.subshare.gui.util.FileStringConverter;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;
import org.subshare.gui.wizard.WizardDialog;

public class LocalRepoPane
extends VBox
implements HistoryPaneContainer {
    private static final AtomicInteger nextLocalRepoPaneIndex = new AtomicInteger();
    private final int localRepoPaneIndex = nextLocalRepoPaneIndex.getAndIncrement();
    private final LocalRepo localRepo;
    private final RepoSyncDaemon repoSyncDaemon;
    private final RepoSyncTimer repoSyncTimer;
    @FXML
    private Button syncButton;
    @FXML
    private Button inviteButton;
    @FXML
    private Button resolveCollisionInHistoryButton;
    @FXML
    private Button exportFromHistoryButton;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab generalTab;
    @FXML
    private Tab historyTab;
    @FXML
    private Tab userRepoKeyListTab;
    @FXML
    private TextField nameTextField;
    @FXML
    private TextField localRootTextField;
    @FXML
    private TextField activityTextField;
    @FXML
    private TextField syncStateStartedFinishedTextField;
    @FXML
    private Label syncStateSeverityLabel;
    @FXML
    private ImageView syncStateSeverityImageView;
    @FXML
    private TextField nextSyncTextField;
    @FXML
    private CheckBox syncPeriodCheckBox;
    @FXML
    private TimePeriodTextField syncPeriodTimePeriodTextField;
    private Set<RepoSyncActivity> activities;
    private List<RepoSyncState> states;
    private JavaBeanStringProperty nameProperty;
    private JavaBeanObjectProperty<File> localRootProperty;
    private final PropertyChangeListener activityPropertyChangeListener = event -> this.updateActivities();
    private final PropertyChangeListener statePropertyChangeListener = event -> this.updateState();
    private final PropertyChangeListener nextSyncPropertyChangeListener = event -> this.updateNextSync();
    private final Timer setSyncPeriodInConfigTimer = new Timer("LocalRepoPane[" + this.localRepoPaneIndex + "].setSyncPeriodInConfigTimer");
    private TimerTask setSyncPeriodInConfigTimerTask;
    private final HistoryPaneSupport historyPaneSupport;
    private WeakReference<UserRepoKeyListPane> userRepoKeyListPaneRef;

    public LocalRepoPane(LocalRepo localRepo) {
        this.localRepo = (LocalRepo)AssertUtil.assertNotNull((Object)localRepo, (String)"localRepo");
        this.repoSyncDaemon = RepoSyncDaemonLs.getRepoSyncDaemon();
        this.repoSyncTimer = RepoSyncTimerLs.getRepoSyncTimer();
        FxmlUtil.loadDynamicComponentFxml(LocalRepoPane.class, this);
        this.nameTextField.setTextFormatter(new TextFormatter((UnaryOperator)new UnaryOperator<TextFormatter.Change>(){

            @Override
            public TextFormatter.Change apply(TextFormatter.Change change) {
                String text = change.getText();
                if (text.startsWith("_") && change.getRangeStart() == 0) {
                    return null;
                }
                if (text.indexOf(47) >= 0) {
                    return null;
                }
                return change;
            }
        }));
        this.bind();
        this.updateActivities();
        this.updateState();
        this.updateNextSync();
        this.updateSyncPeriodUi();
        EventHandler syncStateMouseEventFilter = event -> this.showSyncStateDialog();
        this.syncStateStartedFinishedTextField.addEventFilter(MouseEvent.MOUSE_CLICKED, syncStateMouseEventFilter);
        this.syncStateSeverityLabel.addEventFilter(MouseEvent.MOUSE_CLICKED, syncStateMouseEventFilter);
        this.historyPaneSupport = new HistoryPaneSupport(this);
        this.tabPane.getSelectionModel().selectedItemProperty().addListener(observable -> this.createOrForgetUserRepoKeyListPane());
        this.createOrForgetUserRepoKeyListPane();
    }

    private void createOrForgetUserRepoKeyListPane() {
        UserRepoKeyListPane userRepoKeyListPane;
        PlatformUtil.assertFxApplicationThread();
        if (this.userRepoKeyListTab != this.tabPane.getSelectionModel().getSelectedItem()) {
            this.userRepoKeyListTab.setContent(null);
            return;
        }
        UserRepoKeyListPane userRepoKeyListPane2 = userRepoKeyListPane = this.userRepoKeyListPaneRef == null ? null : (UserRepoKeyListPane)((Object)this.userRepoKeyListPaneRef.get());
        if (userRepoKeyListPane == null) {
            userRepoKeyListPane = new UserRepoKeyListPane();
            userRepoKeyListPane.setLocalRepo(this.localRepo);
            this.userRepoKeyListPaneRef = new WeakReference<UserRepoKeyListPane>(userRepoKeyListPane);
        }
        if (this.userRepoKeyListTab.getContent() == null) {
            this.userRepoKeyListTab.setContent((Node)userRepoKeyListPane);
        }
    }

    private void bind() {
        try {
            this.nameProperty = JavaBeanStringPropertyBuilder.create().bean((Object)this.localRepo).name(LocalRepo.PropertyEnum.name.name()).build();
            this.nameTextField.textProperty().bindBidirectional((Property)this.nameProperty);
            this.localRootProperty = JavaBeanObjectPropertyBuilder.create().bean((Object)this.localRepo).name(LocalRepo.PropertyEnum.localRoot.name()).build();
            Bindings.bindBidirectional((Property)this.localRootTextField.textProperty(), this.localRootProperty, (StringConverter)new FileStringConverter());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.syncPeriodCheckBox.selectedProperty().addListener(observable -> this.updateSyncPeriodInConfig());
        this.syncPeriodTimePeriodTextField.timePeriodProperty().addListener(observable -> this.updateSyncPeriodInConfig());
        PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.repoSyncDaemon, (PropertyBase)RepoSyncDaemon.PropertyEnum.activities, (PropertyChangeListener)this.activityPropertyChangeListener);
        PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.repoSyncDaemon, (PropertyBase)RepoSyncDaemon.PropertyEnum.states, (PropertyChangeListener)this.statePropertyChangeListener);
        PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.repoSyncTimer, (PropertyBase)RepoSyncTimer.PropertyEnum.nextSyncTimestamps, (PropertyChangeListener)this.nextSyncPropertyChangeListener);
    }

    private void updateNextSync() {
        Platform.runLater(() -> {
            long nextSyncTimestamp = this.repoSyncTimer.getNextSyncTimestamp(this.localRepo.getRepositoryId());
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            this.nextSyncTextField.setText(dateFormat.format(new Date(nextSyncTimestamp)));
        });
    }

    private void updateSyncPeriodUi() {
        Long syncPeriod = this.getSyncPeriodInConfig();
        if (syncPeriod == null) {
            Config config = ConfigLs.getInstanceForDirectory(this.localRepo.getLocalRoot());
            this.syncPeriodCheckBox.setSelected(false);
            syncPeriod = config.getPropertyAsPositiveOrZeroLong("repo.syncPeriod", 3600000L);
        } else {
            this.syncPeriodCheckBox.setSelected(true);
        }
        this.syncPeriodTimePeriodTextField.setTimePeriod(new TimePeriod(syncPeriod.longValue()));
    }

    private void updateSyncPeriodInConfig() {
        if (this.syncPeriodCheckBox.isSelected()) {
            TimePeriod syncPeriodFromUi = this.syncPeriodTimePeriodTextField.getTimePeriod();
            if (syncPeriodFromUi != null) {
                this.setSyncPeriodInConfigLater(syncPeriodFromUi.toMillis());
            }
        } else {
            this.setSyncPeriodInConfigLater(null);
        }
    }

    private Long getSyncPeriodInConfig() {
        Config config = ConfigLs.getInstanceForDirectory(this.localRepo.getLocalRoot());
        String syncPeriodStr = config.getDirectProperty("repo.syncPeriod");
        try {
            return StringUtil.isEmpty((String)syncPeriodStr) ? null : Long.valueOf(Long.parseLong(syncPeriodStr));
        }
        catch (NumberFormatException x) {
            return null;
        }
    }

    private synchronized void setSyncPeriodInConfigLater(final Long syncPeriod) {
        if (this.setSyncPeriodInConfigTimerTask != null) {
            this.setSyncPeriodInConfigTimerTask.cancel();
            this.setSyncPeriodInConfigTimerTask = null;
        }
        this.setSyncPeriodInConfigTimerTask = new TimerTask(){

            @Override
            public void run() {
                LocalRepoPane.this.setSyncPeriodInConfig(syncPeriod);
            }
        };
        this.setSyncPeriodInConfigTimer.schedule(this.setSyncPeriodInConfigTimerTask, 1000L);
    }

    private void setSyncPeriodInConfig(Long syncPeriod) {
        if (Util.equal((Object)this.getSyncPeriodInConfig(), (Object)syncPeriod)) {
            return;
        }
        Config config = ConfigLs.getInstanceForDirectory(this.localRepo.getLocalRoot());
        config.setDirectProperty("repo.syncPeriod", syncPeriod == null ? null : Long.toString(syncPeriod));
        this.repoSyncTimer.scheduleTimerTask();
    }

    private void updateActivities() {
        Set newActivities = this.repoSyncDaemon.getActivities(this.localRepo.getRepositoryId());
        Platform.runLater(() -> {
            if (this.activities == null || !this.activities.equals(newActivities)) {
                this.activities = newActivities;
                this.activityTextField.setText(this.getActivityTypesDisplayString(newActivities));
            }
        });
    }

    private void showSyncStateDialog() {
        Error error;
        RepoSyncState state = this.states.isEmpty() ? null : this.states.get(this.states.size() - 1);
        Error error2 = error = state == null ? null : state.getError();
        if (error == null) {
            if (state == null) {
                this.showSyncStateInfoDialog("There was no synchonisation, yet (since the application was started).");
            } else {
                this.showSyncStateInfoDialog("The last synchonisation was successful.");
            }
        } else {
            this.showSyncStateErrorDialog(error);
        }
    }

    private void showSyncStateInfoDialog(String message) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setHeaderText("All fine, dude!");
        Text contentText = new Text(message);
        HBox contentTextContainer = new HBox();
        contentTextContainer.getChildren().add((Object)contentText);
        GridPane.setMargin((Node)contentText, (Insets)new Insets(8.0));
        alert.getDialogPane().setContent((Node)contentTextContainer);
        alert.show();
    }

    private void showSyncStateErrorDialog(Error error) {
        AssertUtil.assertNotNull((Object)error, (String)"error");
        ErrorHandler.handleError("Last synchronisation failed!", null, error);
    }

    private void updateState() {
        List newStates = this.repoSyncDaemon.getStates(this.localRepo.getRepositoryId());
        Platform.runLater(() -> {
            if (this.states == null || !this.states.equals(newStates)) {
                this.states = newStates;
                RepoSyncState state = this.states.isEmpty() ? null : this.states.get(this.states.size() - 1);
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
                this.syncStateStartedFinishedTextField.setText(state == null ? null : dateFormat.format(state.getSyncStarted()) + " ... " + dateFormat.format(state.getSyncFinished()));
                Error error = state == null ? null : state.getError();
                Severity severity = state == null ? Severity.INFO : state.getSeverity();
                this.syncStateSeverityImageView.setDisable(state == null);
                this.syncStateSeverityImageView.setImage(SeverityImageRegistry.getInstance().getImage(severity, IconSize._24x24));
                Tooltip tooltip = null;
                tooltip = error != null ? new Tooltip(error.getClassName() + "\n\n" + error.getMessage()) : (state == null ? new Tooltip("There was no synchonisation, yet (since the application was started).") : new Tooltip("The last synchonisation was successful."));
                this.syncStateStartedFinishedTextField.setTooltip(tooltip);
                this.syncStateSeverityLabel.setTooltip(tooltip);
            }
        });
    }

    private String getActivityTypesDisplayString(Set<RepoSyncActivity> activities) {
        if (activities.isEmpty()) {
            return "{none}";
        }
        StringBuilder sb = new StringBuilder();
        for (RepoSyncActivity repoSyncActivity : activities) {
            if (sb.length() > 0) {
                sb.append(" + ");
            }
            sb.append(repoSyncActivity.getActivityType());
        }
        return sb.toString();
    }

    @FXML
    private void syncButtonClicked(ActionEvent event) {
        RepoSyncDaemon repoSyncDaemon = RepoSyncDaemonLs.getRepoSyncDaemon();
        repoSyncDaemon.startSync(this.localRepo.getLocalRoot());
    }

    @FXML
    private void inviteButtonClicked(ActionEvent event) {
        IssueInvitationWizard wizard = new IssueInvitationWizard(new IssueInvitationData(this.localRepo, this.localRepo.getLocalRoot()));
        WizardDialog dialog = new WizardDialog(this.getScene().getWindow(), wizard);
        dialog.show();
    }

    @Override
    public LocalRepo getLocalRepo() {
        return this.localRepo;
    }

    @Override
    public String getLocalPath() {
        return null;
    }

    @Override
    public Tab getHistoryTab() {
        return this.historyTab;
    }

    @Override
    public TabPane getTabPane() {
        return this.tabPane;
    }

    @Override
    public Button getResolveCollisionInHistoryButton() {
        return this.resolveCollisionInHistoryButton;
    }

    @Override
    public Button getExportFromHistoryButton() {
        return this.exportFromHistoryButton;
    }
}

