/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.server.cproc;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.io.TimeoutException;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.core.LocalServerPropertiesManager;
import co.codewizards.cloudstore.ls.core.LsConfig;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServerProcessLauncher {
    private static final Logger logger = LoggerFactory.getLogger(LocalServerProcessLauncher.class);
    private static final String JAR_URL_PROTOCOL = "jar";
    private static final String JAR_URL_PREFIX = "jar:";
    private static final String JAR_URL_CONTENT_PATH_SEPARATOR = "!/";
    private static final String FILE_PROTOCOL = "file";

    public boolean start() throws IOException {
        if (!LsConfig.isLocalServerProcessEnabled()) {
            return false;
        }
        if (!LsConfig.isLocalServerEnabled()) {
            return false;
        }
        co.codewizards.cloudstore.core.oio.File javaExecutableFile = this.getJavaExecutableFile();
        if (javaExecutableFile == null) {
            return false;
        }
        co.codewizards.cloudstore.core.oio.File thisJarFile = this.getThisJarFile();
        if (thisJarFile == null) {
            return false;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaExecutableFile.getPath());
        this.populateJvmArguments(command);
        this.populateConfigSystemProperties(command);
        command.add("-jar");
        command.add(thisJarFile.getPath());
        logger.info("start: command={}", command);
        ProcessBuilder pb = new ProcessBuilder(command);
        co.codewizards.cloudstore.core.oio.File processRedirectInputFile = this.getProcessRedirectInputFile();
        co.codewizards.cloudstore.core.oio.File processRedirectOutputFile = this.getProcessRedirectOutputFile();
        processRedirectInputFile.createNewFile();
        pb.redirectInput(processRedirectInputFile.getIoFile());
        pb.redirectOutput(processRedirectOutputFile.getIoFile());
        pb.redirectError(processRedirectOutputFile.getIoFile());
        Process process = pb.start();
        if (process == null) {
            logger.warn("start: process=null");
            return false;
        }
        this.waitUntilServerOnline();
        return true;
    }

    private void populateJvmArguments(List<String> command) {
        String maxHeapSize = LsConfig.getLocalServerProcessMaxHeapSize();
        if (maxHeapSize != null) {
            command.add("-Xmx" + maxHeapSize);
        }
    }

    private void populateConfigSystemProperties(List<String> command) {
        for (Map.Entry<Object, Object> me : System.getProperties().entrySet()) {
            String k = me.getKey().toString();
            String v = me.getValue().toString();
            if (!k.startsWith(Config.SYSTEM_PROPERTY_PREFIX)) continue;
            String arg = "-D" + k + "=" + v;
            command.add(arg);
        }
    }

    private void waitUntilServerOnline() {
        long startTimestamp = System.currentTimeMillis();
        while (true) {
            long timeoutMs = LsConfig.getLocalServerProcessStartTimeout();
            boolean timeout = System.currentTimeMillis() - startTimestamp > timeoutMs;
            LocalServerPropertiesManager.getInstance().clear();
            String baseUrlString = LocalServerPropertiesManager.getInstance().getBaseUrl();
            if (baseUrlString != null) {
                URL baseUrl;
                try {
                    baseUrl = new URL(baseUrlString);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                int port = baseUrl.getPort();
                if (port < 0) {
                    port = baseUrl.getDefaultPort();
                }
                if (port < 0) {
                    port = 443;
                }
                try {
                    Socket socket = new Socket(baseUrl.getHost(), port);
                    socket.close();
                    logger.info("waitUntilServerOnline: Connecting to " + baseUrl + " succeeded!");
                    return;
                }
                catch (IOException e) {
                    if (timeout) {
                        logger.error("waitUntilServerOnline: Connecting to " + baseUrl + " failed (fatal): " + e, (Throwable)e);
                    }
                    logger.warn("waitUntilServerOnline: Connecting to " + baseUrl + " failed (retrying): " + e);
                }
            }
            if (timeout) {
                throw new TimeoutException("LocalServer did not come online within timeout!");
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Util.doNothing();
                continue;
            }
            break;
        }
    }

    private co.codewizards.cloudstore.core.oio.File getProcessRedirectInputFile() {
        co.codewizards.cloudstore.core.oio.File tempDir = IOUtil.getTempDir();
        SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-dd-HH-mm-ss");
        String now = df.format(new Date());
        co.codewizards.cloudstore.core.oio.File file = tempDir.createFile(new String[]{String.format("LocalServer.%s.in", now)}).getAbsoluteFile();
        logger.debug("getProcessRedirectInputFile: file='{}'", (Object)file);
        return file;
    }

    private co.codewizards.cloudstore.core.oio.File getProcessRedirectOutputFile() {
        co.codewizards.cloudstore.core.oio.File tempDir = IOUtil.getTempDir();
        SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-dd-HH-mm-ss");
        String now = df.format(new Date());
        co.codewizards.cloudstore.core.oio.File file = tempDir.createFile(new String[]{String.format("LocalServer.%s.out", now)}).getAbsoluteFile();
        logger.debug("getProcessRedirectOutputFile: file='{}'", (Object)file);
        return file;
    }

    private co.codewizards.cloudstore.core.oio.File getJavaExecutableFile() {
        String javaHome = System.getProperty("java.home");
        AssertUtil.assertNotNull((Object)javaHome, (String)"javaHome");
        co.codewizards.cloudstore.core.oio.File file = OioFileFactory.createFile((String)javaHome, (String[])new String[]{"bin", "java"}).getAbsoluteFile();
        if (file.isFile()) {
            logger.debug("getJavaExecutableFile: file='{}'", (Object)file);
            return file;
        }
        file = OioFileFactory.createFile((String)javaHome, (String[])new String[]{"bin", "java.exe"}).getAbsoluteFile();
        if (file.isFile()) {
            logger.debug("getJavaExecutableFile: file='{}'", (Object)file);
            return file;
        }
        logger.warn("getJavaExecutableFile: Could not locate 'java' executable!");
        return null;
    }

    private co.codewizards.cloudstore.core.oio.File getThisJarFile() {
        File f;
        URL jarUrl;
        URL url = this.getClass().getResource("");
        AssertUtil.assertNotNull((Object)url, (String)"url");
        String urlString = url.toString();
        logger.debug("getThisJarFile: url='{}'", (Object)urlString);
        if (!urlString.startsWith(JAR_URL_PREFIX)) {
            logger.warn("getThisJarFile: This class ({}) is not located in a JAR file! url='{}'", (Object)this.getClass().getName(), (Object)urlString);
            return null;
        }
        int indexOfContentPathSeparator = urlString.indexOf(JAR_URL_CONTENT_PATH_SEPARATOR);
        if (indexOfContentPathSeparator < 0) {
            throw new IllegalStateException(String.format("JAR-URL '%s' does not contain separator '%s'!", urlString, JAR_URL_CONTENT_PATH_SEPARATOR));
        }
        String jarUrlString = urlString.substring(JAR_URL_PREFIX.length(), indexOfContentPathSeparator);
        logger.debug("getThisJarFile: url='{}'", (Object)urlString);
        try {
            jarUrl = new URL(jarUrlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (!FILE_PROTOCOL.equals(jarUrl.getProtocol())) {
            throw new IllegalStateException(String.format("Illegal protocol ('%s' expected): %s", FILE_PROTOCOL, jarUrlString));
        }
        try {
            f = new File(jarUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        logger.debug("getThisJarFile: file='{}'", (Object)f);
        return OioFileFactory.createFile((File)f);
    }
}

