/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke;

import co.codewizards.cloudstore.ls.core.invoke.ForceNonTransientAdvisor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class ForceNonTransientClassSet {
    private final Set<Class<?>> forceNonTransientClasses;
    private final Map<Class<?>, Boolean> class2ForceNonTransient = new HashMap();

    private ForceNonTransientClassSet() {
        HashSet s = new HashSet();
        for (ForceNonTransientAdvisor advisor : ServiceLoader.load(ForceNonTransientAdvisor.class)) {
            Class<?>[] classes = advisor.getForceNonTransientClasses();
            if (classes == null) {
                throw new IllegalStateException("Implementation error: advisor.getForceNonTransientClasses() returned null! " + advisor.getClass().getName());
            }
            for (Class<?> clazz : classes) {
                s.add(clazz);
            }
        }
        this.forceNonTransientClasses = Collections.unmodifiableSet(s);
    }

    public synchronized boolean isForceNonTransientClass(Class<?> clazz) {
        Boolean result = this.class2ForceNonTransient.get(clazz);
        if (result == null) {
            for (Class<?> forceNonTransientClass : this.forceNonTransientClasses) {
                if (!forceNonTransientClass.isAssignableFrom(clazz)) continue;
                result = true;
                break;
            }
            if (result == null) {
                result = false;
            }
            this.class2ForceNonTransient.put(clazz, result);
        }
        return result;
    }

    public static ForceNonTransientClassSet getInstance() {
        return Holder.instance;
    }

    private static class Holder {
        public static ForceNonTransientClassSet instance = new ForceNonTransientClassSet();

        private Holder() {
        }
    }
}

