/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.key;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.bouncycastle.openpgp.wot.internal.Util;

public class PgpKeyId
implements Comparable<PgpKeyId>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long pgpKeyId;
    private volatile transient WeakReference<String> toString;
    private volatile transient WeakReference<String> toHumanString;

    public PgpKeyId(long pgpKeyId) {
        this.pgpKeyId = pgpKeyId;
    }

    public PgpKeyId(String pgpKeyIdString) {
        this(Util.bytesToLong(Util.decodeHexStr(Util.assertNotNull(pgpKeyIdString, "pgpKeyIdString"))));
    }

    public String toString() {
        String s;
        String string = s = this.toString == null ? null : (String)this.toString.get();
        if (s == null) {
            s = Util.encodeHexStr(Util.longToBytes(this.pgpKeyId));
            this.toString = new WeakReference<String>(s);
        }
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.pgpKeyId ^ this.pgpKeyId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PgpKeyId other = (PgpKeyId)obj;
        return this.pgpKeyId == other.pgpKeyId;
    }

    @Override
    public int compareTo(PgpKeyId other) {
        Util.assertNotNull(other, "other");
        return this.pgpKeyId < other.pgpKeyId ? -1 : (this.pgpKeyId > other.pgpKeyId ? 1 : 0);
    }

    public long longValue() {
        return this.pgpKeyId;
    }

    public String toHumanString() {
        String s;
        String string = s = this.toHumanString == null ? null : (String)this.toHumanString.get();
        if (s == null) {
            s = this._toHumanString();
            this.toHumanString = new WeakReference<String>(s);
        }
        return s;
    }

    private String _toHumanString() {
        StringBuilder sb = new StringBuilder();
        String string = this.toString();
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0 && i % 4 == 0) {
                sb.append(' ');
            }
            sb.append(string.charAt(i));
        }
        return sb.toString();
    }
}

