/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.server;

import co.codewizards.cloudstore.core.auth.BouncyCastleRegistrationUtil;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.TimeoutException;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.DebugUtil;
import co.codewizards.cloudstore.ls.core.LocalServerPropertiesManager;
import co.codewizards.cloudstore.ls.core.LsConfig;
import co.codewizards.cloudstore.ls.rest.server.LocalServerRest;
import co.codewizards.cloudstore.ls.rest.server.auth.AuthManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServer {
    public static final String CONFIG_KEY_PORT = "localServer.port";
    private static final int RANDOM_PORT = 0;
    private static final int DEFAULT_PORT = 0;
    private static final Logger logger = LoggerFactory.getLogger(LocalServer.class);
    private Server server;
    private int port = -1;
    private File localServerRunningFile;
    private LockFile localServerRunningLockFile;
    private boolean localServerStopFileEnabled;
    private File localServerStopFile;
    private final Timer localServerStopFileTimer = new Timer("localServerStopFileTimer", true);
    private TimerTask localServerStopFileTimerTask;
    private static final Map<String, LocalServer> localServerRunningFile2LocalServer_running = new HashMap<String, LocalServer>();

    public LocalServer() {
        BouncyCastleRegistrationUtil.registerBouncyCastleIfNeeded();
    }

    public File getLocalServerRunningFile() {
        if (this.localServerRunningFile == null) {
            try {
                this.localServerRunningFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"localServerRunning.lock"}).getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.localServerRunningFile;
    }

    public File getLocalServerStopFile() {
        if (this.localServerStopFile == null) {
            this.localServerStopFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"localServerRunning.deleteToStop"});
        }
        return this.localServerStopFile;
    }

    public boolean isLocalServerStopFileEnabled() {
        return this.localServerStopFileEnabled;
    }

    public void setLocalServerStopFileEnabled(boolean localServerStopFileEnabled) {
        this.localServerStopFileEnabled = localServerStopFileEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean start() {
        String localServerRunningFilePath;
        LockFile _localServerRunningLockFile;
        block15: {
            DebugUtil.logMemoryStats((Logger)logger);
            if (!LsConfig.isLocalServerEnabled()) {
                return false;
            }
            _localServerRunningLockFile = null;
            Map<String, LocalServer> map = localServerRunningFile2LocalServer_running;
            // MONITORENTER : map
            File localServerRunningFile = this.getLocalServerRunningFile();
            localServerRunningFilePath = localServerRunningFile.getPath();
            try {
                _localServerRunningLockFile = LockFileFactory.getInstance().acquire(localServerRunningFile, 5000L);
            }
            catch (TimeoutException x) {
                boolean bl = false;
                // MONITOREXIT : map
                if (_localServerRunningLockFile == null) return bl;
                _localServerRunningLockFile.release();
                return bl;
            }
            if (!localServerRunningFile2LocalServer_running.containsKey(localServerRunningFilePath)) break block15;
            boolean bl = false;
            // MONITOREXIT : map
            if (_localServerRunningLockFile == null) return bl;
            _localServerRunningLockFile.release();
            return bl;
        }
        try {
            Server s;
            this.localServerRunningLockFile = _localServerRunningLockFile;
            this.server = s = this.createServer();
            this.createLocalServerStopFileTimerTask();
            localServerRunningFile2LocalServer_running.put(localServerRunningFilePath, this);
            s.addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

                public void lifeCycleFailure(LifeCycle event, Throwable cause) {
                    LocalServer.this.onStopOrFailure();
                }

                public void lifeCycleStopped(LifeCycle event) {
                    LocalServer.this.onStopOrFailure();
                }
            });
            _localServerRunningLockFile = null;
            // MONITOREXIT : map
            s.start();
            this.writeLocalServerProperties();
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (_localServerRunningLockFile != null) {
                _localServerRunningLockFile.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLocalServerStopFileTimerTask() {
        if (!this.isLocalServerStopFileEnabled()) {
            return;
        }
        final File localServerStopFile = this.getLocalServerStopFile();
        try {
            localServerStopFile.createNewFile();
            if (!localServerStopFile.exists()) {
                throw new IOException("File not created!");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create file: " + localServerStopFile);
        }
        Timer timer = this.localServerStopFileTimer;
        synchronized (timer) {
            this.cancelLocalServerStopFileTimerTask();
            this.localServerStopFileTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (localServerStopFile.exists()) {
                        logger.debug("localServerStopFileTimerTask.run: file '{}' exists => nothing to do.", (Object)localServerStopFile);
                        return;
                    }
                    logger.info("localServerStopFileTimerTask.run: file '{}' does not exist => stopping server!", (Object)localServerStopFile);
                    LocalServer.this.stop();
                    System.exit(0);
                }
            };
            long period = 5000L;
            this.localServerStopFileTimer.schedule(this.localServerStopFileTimerTask, 5000L, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelLocalServerStopFileTimerTask() {
        Timer timer = this.localServerStopFileTimer;
        synchronized (timer) {
            if (this.localServerStopFileTimerTask != null) {
                this.localServerStopFileTimerTask.cancel();
                this.localServerStopFileTimerTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStopOrFailure() {
        this.cancelLocalServerStopFileTimerTask();
        Map<String, LocalServer> map = localServerRunningFile2LocalServer_running;
        synchronized (map) {
            File localServerStopFile;
            File localServerRunningFile = this.getLocalServerRunningFile();
            String localServerRunningFilePath = localServerRunningFile.getPath();
            if (localServerRunningFile2LocalServer_running.get(localServerRunningFilePath) == this) {
                localServerRunningFile2LocalServer_running.remove(localServerRunningFilePath);
                this.server = null;
            }
            if ((localServerStopFile = this.getLocalServerStopFile()).exists()) {
                localServerStopFile.delete();
                if (localServerStopFile.exists()) {
                    logger.warn("onStopOrFailure: Failed to delete file: {}", (Object)localServerStopFile);
                } else {
                    logger.info("onStopOrFailure: Successfully deleted file: {}", (Object)localServerStopFile);
                }
            } else {
                logger.info("onStopOrFailure: File did not exist (could not delete): {}", (Object)localServerStopFile);
            }
            if (this.localServerRunningLockFile != null) {
                this.localServerRunningLockFile.release();
                this.localServerRunningLockFile = null;
            }
        }
    }

    private void writeLocalServerProperties() throws IOException {
        int localPort = this.getLocalPort();
        if (localPort < 0) {
            return;
        }
        LocalServerPropertiesManager localServerPropertiesManager = LocalServerPropertiesManager.getInstance();
        localServerPropertiesManager.setPort(localPort);
        localServerPropertiesManager.setPassword(AuthManager.getInstance().getCurrentPassword());
        localServerPropertiesManager.writeLocalServerProperties();
    }

    public void stop() {
        Server s = this.getServer();
        if (s != null) {
            try {
                s.stop();
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server getServer() {
        Map<String, LocalServer> map = localServerRunningFile2LocalServer_running;
        synchronized (map) {
            return this.server;
        }
    }

    public int getLocalPort() {
        Server server = this.getServer();
        if (server == null) {
            return -1;
        }
        Connector[] connectors = server.getConnectors();
        if (connectors.length != 1) {
            throw new IllegalStateException("connectors.length != 1");
        }
        return ((ServerConnector)connectors[0]).getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Map<String, LocalServer> map = localServerRunningFile2LocalServer_running;
        synchronized (map) {
            if (this.port < 0) {
                this.port = ConfigImpl.getInstance().getPropertyAsInt(CONFIG_KEY_PORT, 0);
                if (this.port < 0 || this.port > 65535) {
                    logger.warn("Config key '{}' is set to the value '{}' which is out of range for a port number. Falling back to default port {} ({} meaning a random port).", new Object[]{CONFIG_KEY_PORT, this.port, 0, 0});
                    this.port = 0;
                }
            }
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int port) {
        Map<String, LocalServer> map = localServerRunningFile2LocalServer_running;
        synchronized (map) {
            this.assertNotRunning();
            this.port = port;
        }
    }

    private boolean isRunning() {
        return this.getServer() != null;
    }

    private void assertNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("Server is already running.");
        }
    }

    private Server createServer() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(500);
        Server server = new Server((ThreadPool)threadPool);
        server.addBean((Object)new ScheduledExecutorScheduler());
        ServerConnector http = this.createHttpServerConnector(server);
        server.addConnector((Connector)http);
        server.setHandler((Handler)this.createServletContextHandler());
        server.setDumpAfterStart(false);
        server.setDumpBeforeStop(false);
        server.setStopAtShutdown(true);
        return server;
    }

    private ServerConnector createHttpServerConnector(Server server) {
        HttpConfiguration http_config = this.createHttpConfigurationForHTTP();
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        http.setHost("127.0.0.1");
        http.setPort(this.getPort());
        http.setIdleTimeout(30000L);
        return http;
    }

    private HttpConfiguration createHttpConfigurationForHTTP() {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setOutputBufferSize(32768);
        http_config.setRequestHeaderSize(8192);
        http_config.setResponseHeaderSize(8192);
        http_config.setSendServerVersion(true);
        http_config.setSendDateHeader(false);
        return http_config;
    }

    private ServletContextHandler createServletContextHandler() {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        ServletContainer servletContainer = new ServletContainer((ResourceConfig)AssertUtil.assertNotNull((Object)this.createResourceConfig(), (String)"createResourceConfig()"));
        context.addServlet(new ServletHolder((Servlet)servletContainer), "/*");
        return context;
    }

    protected ResourceConfig createResourceConfig() {
        return new LocalServerRest();
    }
}

