/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo;

import co.codewizards.cloudstore.core.repo.local.LocalRepoHelper;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactory;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactoryRegistry;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import javafx.util.Pair;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.ServerRepoManager;
import org.subshare.core.repo.ServerRepoRegistry;
import org.subshare.core.repo.ServerRepoRegistryImpl;
import org.subshare.core.repo.metaonly.MetaOnlyRepoManagerImpl;
import org.subshare.core.repo.transport.CryptreeRestRepoTransport;
import org.subshare.core.server.Server;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistry;
import org.subshare.core.user.UserRegistryImpl;
import org.subshare.core.user.UserRepoInvitationManager;
import org.subshare.core.user.UserRepoInvitationToken;

public class ServerRepoManagerImpl
implements ServerRepoManager {
    private ServerRepoManagerImpl() {
    }

    public static ServerRepoManager getInstance() {
        return Holder.instance;
    }

    @Override
    public ServerRepo createRepository(co.codewizards.cloudstore.core.oio.File localDirectory, Server server, User owner) {
        AssertUtil.assertNotNull((Object)localDirectory, (String)"localDirectory");
        AssertUtil.assertNotNull((Object)server, (String)"server");
        AssertUtil.assertNotNull((Object)owner, (String)"owner");
        Pair<co.codewizards.cloudstore.core.oio.File, UUID> localRootAndRepositoryId = this.createLocalRepository(localDirectory);
        co.codewizards.cloudstore.core.oio.File localRoot = (co.codewizards.cloudstore.core.oio.File)localRootAndRepositoryId.getKey();
        UUID clientRepositoryId = (UUID)localRootAndRepositoryId.getValue();
        UUID serverRepositoryId = this.createServerRepository(clientRepositoryId, server, owner);
        ServerRepo serverRepo = this.registerInServerRepoRegistry(server, serverRepositoryId, owner);
        owner.createUserRepoKey(serverRepositoryId);
        UserRegistryImpl.getInstance().writeIfNeeded();
        ServerRepoManagerImpl.connectLocalRepositoryWithServerRepository(localRoot, server, serverRepositoryId, "");
        return serverRepo;
    }

    @Override
    public void checkOutRepository(Server server, ServerRepo serverRepo, String serverPath, co.codewizards.cloudstore.core.oio.File localDirectory) {
        AssertUtil.assertNotNull((Object)server, (String)"server");
        AssertUtil.assertNotNull((Object)serverRepo, (String)"serverRepo");
        AssertUtil.assertNotNull((Object)localDirectory, (String)"localDirectory");
        if (!server.getServerId().equals((Object)serverRepo.getServerId())) {
            throw new IllegalArgumentException(String.format("server.serverId != serverRepo.serverId :: %s != %s", server.getServerId(), serverRepo.getServerId()));
        }
        Pair<co.codewizards.cloudstore.core.oio.File, UUID> localRootAndRepositoryId = this.createLocalRepository(localDirectory);
        co.codewizards.cloudstore.core.oio.File localRoot = (co.codewizards.cloudstore.core.oio.File)localRootAndRepositoryId.getKey();
        ServerRepoManagerImpl.connectLocalRepositoryWithServerRepository(localRoot, server, serverRepo.getRepositoryId(), serverPath);
    }

    @Override
    public ServerRepo checkOutRepository(co.codewizards.cloudstore.core.oio.File localDirectory, UserRepoInvitationToken userRepoInvitationToken) {
        UserRegistry userRegistry = UserRegistryImpl.getInstance();
        Pair<co.codewizards.cloudstore.core.oio.File, UUID> localRootAndRepositoryId = this.createLocalRepository(localDirectory);
        co.codewizards.cloudstore.core.oio.File localRoot = (co.codewizards.cloudstore.core.oio.File)localRootAndRepositoryId.getKey();
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);){
            ServerRepo serverRepo;
            UserRepoInvitationManager userRepoInvitationManager = UserRepoInvitationManager.Helper.getInstance(userRegistry, localRepoManager);
            ServerRepo serverRepo2 = serverRepo = userRepoInvitationManager.importUserRepoInvitationToken(userRepoInvitationToken);
            return serverRepo2;
        }
    }

    @Override
    public boolean canUseLocalDirectory(co.codewizards.cloudstore.core.oio.File localDirectory) {
        AssertUtil.assertNotNull((Object)localDirectory, (String)"localDirectory");
        co.codewizards.cloudstore.core.oio.File localRoot = LocalRepoHelper.getLocalRootContainingFile((co.codewizards.cloudstore.core.oio.File)localDirectory);
        if (localRoot == null) {
            boolean containsOtherRepo;
            boolean bl = containsOtherRepo = !LocalRepoHelper.getLocalRootsContainedInDirectory((co.codewizards.cloudstore.core.oio.File)localDirectory).isEmpty();
            if (containsOtherRepo) {
                return false;
            }
            return !this.interferesWithMetaOnlyRepoBaseDir(localDirectory);
        }
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);){
            Map remoteRepositoryId2RemoteRootMap = localRepoManager.getRemoteRepositoryId2RemoteRootMap();
            boolean bl = remoteRepositoryId2RemoteRootMap.isEmpty();
            return bl;
        }
    }

    private boolean interferesWithMetaOnlyRepoBaseDir(co.codewizards.cloudstore.core.oio.File localDirectory) {
        String localDirectoryPath;
        localDirectory = localDirectory.getAbsoluteFile();
        co.codewizards.cloudstore.core.oio.File baseDir = MetaOnlyRepoManagerImpl.getInstance().getBaseDir().getAbsoluteFile();
        if (baseDir.equals(localDirectory)) {
            return true;
        }
        String baseDirPath = baseDir.getPath() + File.separator;
        if (baseDirPath.startsWith(localDirectoryPath = localDirectory.getPath() + File.separator)) {
            return true;
        }
        return localDirectoryPath.startsWith(baseDirPath);
    }

    private Pair<co.codewizards.cloudstore.core.oio.File, UUID> createLocalRepository(co.codewizards.cloudstore.core.oio.File localDirectory) {
        AssertUtil.assertNotNull((Object)localDirectory, (String)"localDirectory");
        co.codewizards.cloudstore.core.oio.File localRoot = LocalRepoHelper.getLocalRootContainingFile((co.codewizards.cloudstore.core.oio.File)localDirectory);
        if (localRoot == null) {
            try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForNewRepository(localDirectory);){
                Pair pair = new Pair((Object)localRepoManager.getLocalRoot(), (Object)localRepoManager.getRepositoryId());
                return pair;
            }
        }
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);){
            Map remoteRepositoryId2RemoteRootMap = localRepoManager.getRemoteRepositoryId2RemoteRootMap();
            if (!remoteRepositoryId2RemoteRootMap.isEmpty()) {
                throw new IllegalStateException(String.format("The directory '%s' is already a repository (or it is inside one) and it already is connected to the remote repository '%s'! A local repository may currently only be connected to exactly one server!", localDirectory, remoteRepositoryId2RemoteRootMap.values().iterator().next()));
            }
            Pair pair = new Pair((Object)localRepoManager.getLocalRoot(), (Object)localRepoManager.getRepositoryId());
            return pair;
        }
    }

    private UUID createServerRepository(UUID clientRepositoryId, Server server, User owner) {
        AssertUtil.assertNotNull((Object)clientRepositoryId, (String)"clientRepositoryId");
        AssertUtil.assertNotNull((Object)server, (String)"server");
        AssertUtil.assertNotNull((Object)owner, (String)"owner");
        UUID serverRepositoryId = UUID.randomUUID();
        URL remoteRoot = UrlUtil.appendNonEncodedPath((URL)server.getUrl(), (String)serverRepositoryId.toString());
        RepoTransportFactory repoTransportFactory = RepoTransportFactoryRegistry.getInstance().getRepoTransportFactory(remoteRoot);
        try (CryptreeRestRepoTransport repoTransport = (CryptreeRestRepoTransport)repoTransportFactory.createRepoTransport(remoteRoot, clientRepositoryId);){
            repoTransport.createRepository(serverRepositoryId, this.getPgpKey(owner));
        }
        return serverRepositoryId;
    }

    private PgpKey getPgpKey(User user) {
        PgpKey result = null;
        for (PgpKey pgpKey : user.getValidPgpKeys()) {
            if (!pgpKey.isSecretKeyAvailable() || result != null && result.getValidTo().compareTo(pgpKey.getValidTo()) >= 0) continue;
            result = pgpKey;
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("There is no PGP key with a private key available for this user: " + user);
    }

    private ServerRepo registerInServerRepoRegistry(Server server, UUID serverRepositoryId, User owner) {
        AssertUtil.assertNotNull((Object)server, (String)"server");
        AssertUtil.assertNotNull((Object)serverRepositoryId, (String)"serverRepositoryId");
        AssertUtil.assertNotNull((Object)owner, (String)"owner");
        ServerRepoRegistry serverRepoRegistry = this.getServerRepoRegistry();
        ServerRepo serverRepo = serverRepoRegistry.createServerRepo(serverRepositoryId);
        serverRepo.setServerId(server.getServerId());
        serverRepo.setName(serverRepositoryId.toString());
        serverRepo.setUserId(owner.getUserId());
        serverRepoRegistry.getServerRepos().add(serverRepo);
        serverRepoRegistry.writeIfNeeded();
        return serverRepo;
    }

    private ServerRepoRegistry getServerRepoRegistry() {
        return ServerRepoRegistryImpl.getInstance();
    }

    public static void connectLocalRepositoryWithServerRepository(co.codewizards.cloudstore.core.oio.File localRoot, Server server, UUID serverRepositoryId, String serverPath) {
        AssertUtil.assertNotNull((Object)localRoot, (String)"localRoot");
        AssertUtil.assertNotNull((Object)server, (String)"server");
        AssertUtil.assertNotNull((Object)serverRepositoryId, (String)"serverRepositoryId");
        URL remoteRoot = UrlUtil.appendNonEncodedPath((URL)server.getUrl(), (String)serverRepositoryId.toString());
        if (!StringUtil.isEmpty((String)serverPath)) {
            remoteRoot = UrlUtil.appendEncodedPath((URL)remoteRoot, (String)serverPath);
        }
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);){
            ServerRepoManagerImpl.connectLocalRepositoryWithServerRepository(localRepoManager, serverRepositoryId, remoteRoot);
        }
    }

    public static void connectLocalRepositoryWithServerRepository(LocalRepoManager localRepoManager, UUID serverRepositoryId, URL remoteRoot) {
        AssertUtil.assertNotNull((Object)localRepoManager, (String)"localRepoManager");
        AssertUtil.assertNotNull((Object)serverRepositoryId, (String)"serverRepositoryId");
        AssertUtil.assertNotNull((Object)remoteRoot, (String)"remoteRoot");
        UUID clientRepositoryId = localRepoManager.getRepositoryId();
        byte[] clientRepositoryPublicKey = localRepoManager.getPublicKey();
        try (RepoTransport repoTransport = RepoTransportFactoryRegistry.getInstance().getRepoTransportFactory(remoteRoot).createRepoTransport(remoteRoot, clientRepositoryId);){
            byte[] remoteRepositoryPublicKey = repoTransport.getPublicKey();
            String localPathPrefix = "";
            localRepoManager.putRemoteRepository(serverRepositoryId, remoteRoot, remoteRepositoryPublicKey, "");
            try {
                repoTransport.requestRepoConnection(clientRepositoryPublicKey);
            }
            catch (Exception x) {
                localRepoManager.deleteRemoteRepository(serverRepositoryId);
                throw x;
            }
        }
    }

    private static final class Holder {
        public static final ServerRepoManagerImpl instance = new ServerRepoManagerImpl();

        private Holder() {
        }
    }
}

