/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.server.service.AbstractServiceWithRepoToRepoAuth;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="_copy/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class CopyService
extends AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(CopyService.class);

    public CopyService() {
        logger.debug("<init>: created new instance");
    }

    @POST
    public void copy(@QueryParam(value="to") String toPath) {
        this.copy("", toPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{path:.*}")
    public void copy(@PathParam(value="path") String path, @QueryParam(value="to") String toPath) {
        AssertUtil.assertNotNull((Object)path, (String)"path");
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            path = repoTransport.unprefixPath(path);
            repoTransport.copy(path, toPath);
        }
    }
}

