/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.dto;

import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.dto.ErrorStackTraceElement;

public class RemoteException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Error error;
    private String errorClassName;
    private boolean stackTraceInitialised = false;

    public RemoteException(Error error) {
        super(error == null ? null : error.getMessage());
        this.error = error;
        if (error != null) {
            this.errorClassName = error.getClassName();
            this.initStackTrace();
            if (error.getCause() != null) {
                this.initCause(new RemoteException(error.getCause()));
            }
        }
    }

    private synchronized void initStackTrace() {
        if (this.stackTraceInitialised) {
            return;
        }
        this.stackTraceInitialised = true;
        if (this.error != null) {
            int idx = -1;
            StackTraceElement[] origStackTrace = this.getStackTrace();
            StackTraceElement[] stackTrace = new StackTraceElement[origStackTrace.length + this.error.getStackTraceElements().size()];
            for (ErrorStackTraceElement errorStackTraceElement : this.error.getStackTraceElements()) {
                stackTrace[++idx] = new StackTraceElement(errorStackTraceElement.getClassName(), errorStackTraceElement.getMethodName(), errorStackTraceElement.getFileName(), errorStackTraceElement.getLineNumber());
            }
            if (origStackTrace != null) {
                for (StackTraceElement stackTraceElement : origStackTrace) {
                    stackTrace[++idx] = stackTraceElement;
                }
            }
            this.setStackTrace(stackTrace);
        }
    }

    public Error getError() {
        return this.error;
    }

    public String getErrorClassName() {
        return this.errorClassName;
    }

    @Override
    public String toString() {
        String s = this.getClass().getName() + (this.errorClassName == null ? "" : '<' + this.errorClassName + '>');
        String message = this.getLocalizedMessage();
        return message != null ? s + ": " + message : s;
    }
}

