/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.createrepo;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncDaemon;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.List;
import org.subshare.core.server.Server;
import org.subshare.core.user.User;
import org.subshare.gui.createrepo.CreateRepoData;
import org.subshare.gui.createrepo.selectlocaldir.CreateRepoSelectLocalDirWizardPage;
import org.subshare.gui.createrepo.selectserver.CreateRepoSelectServerWizardPage;
import org.subshare.gui.ls.RepoSyncDaemonLs;
import org.subshare.gui.ls.ServerRegistryLs;
import org.subshare.gui.ls.ServerRepoManagerLs;
import org.subshare.gui.wizard.Wizard;

public class CreateRepoWizard
extends Wizard {
    private final CreateRepoData createRepoData;

    public CreateRepoWizard(CreateRepoData createRepoData) {
        this.createRepoData = (CreateRepoData)AssertUtil.assertNotNull((Object)createRepoData, (String)"createRepoData");
        if (createRepoData.getServer() == null) {
            List servers = ServerRegistryLs.getServerRegistry().getServers();
            if (servers.size() == 1) {
                createRepoData.setServer((Server)servers.get(0));
            } else {
                this.setFirstPage(new CreateRepoSelectServerWizardPage(createRepoData));
            }
        }
        if (createRepoData.getServer() != null) {
            this.setFirstPage(new CreateRepoSelectLocalDirWizardPage(createRepoData));
        }
    }

    @Override
    public void init() {
        super.init();
        this.setPrefSize(500.0, 500.0);
    }

    @Override
    protected void finish(ProgressMonitor monitor) throws Exception {
        File directory = this.createRepoData.getLocalDirectory();
        Server server = this.createRepoData.getServer();
        User owner = (User)this.createRepoData.getOwners().iterator().next();
        ServerRepoManagerLs.getServerRepoManager().createRepository(directory, server, owner);
        RepoSyncDaemon repoSyncDaemon = RepoSyncDaemonLs.getRepoSyncDaemon();
        repoSyncDaemon.startSync(directory);
    }

    @Override
    public String getTitle() {
        return "Create repository / upload and share directory";
    }
}

