/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.filetree;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.image.Image;
import org.subshare.gui.IconSize;

public class FileIconRegistry {
    public static final String ICON_ID_DIRECTORY = "directory";
    public static final String ICON_ID_HOME = "home";
    public static final String ICON_ID_FILE = "file-empty";
    public static final String ICON_ID_SYMLINK_TO_FILE = "symlink";
    public static final String ICON_ID_SYMLINK_TO_DIRECTORY = "symlink";
    public static final String ICON_ID_SYMLINK_BROKEN = "symlink";
    public static final String ICON_ID_SYMLINK = "symlink";
    private static final FileIconRegistry instance = new FileIconRegistry();
    private final Map<String, Map<IconSize, Image>> iconId2IconSize2Image = new HashMap<String, Map<IconSize, Image>>();

    private FileIconRegistry() {
    }

    public static FileIconRegistry getInstance() {
        return instance;
    }

    public Image getIcon(File file, IconSize iconSize) {
        AssertUtil.assertNotNull((Object)file, (String)"file");
        AssertUtil.assertNotNull((Object)((Object)iconSize), (String)"iconSize");
        String iconId = this.getIconId(file);
        return this.getIcon(iconId, iconSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getIcon(String iconId, IconSize iconSize) {
        AssertUtil.assertNotNull((Object)iconId, (String)"iconId");
        AssertUtil.assertNotNull((Object)((Object)iconSize), (String)"iconSize");
        FileIconRegistry fileIconRegistry = this;
        synchronized (fileIconRegistry) {
            Image image;
            Map<IconSize, Image> iconSize2Image = this.iconId2IconSize2Image.get(iconId);
            if (iconSize2Image == null) {
                iconSize2Image = new HashMap<IconSize, Image>();
                this.iconId2IconSize2Image.put(iconId, iconSize2Image);
            }
            if ((image = iconSize2Image.get((Object)iconSize)) == null) {
                String fileName = this.getFileName(iconId, iconSize);
                URL url = FileIconRegistry.class.getResource(fileName);
                if (url == null) {
                    throw new IllegalArgumentException(String.format("Unknown iconId '%s' (resource '%s' not found)!", iconId, fileName));
                }
                image = new Image(url.toExternalForm());
                iconSize2Image.put(iconSize, image);
            }
            return image;
        }
    }

    private String getFileName(String iconId, IconSize iconSize) {
        AssertUtil.assertNotNull((Object)iconId, (String)"iconId");
        AssertUtil.assertNotNull((Object)((Object)iconSize), (String)"iconSize");
        return iconId + iconSize.name() + ".png";
    }

    private String getIconId(File file) {
        AssertUtil.assertNotNull((Object)file, (String)"file");
        if (file.isDirectory()) {
            if (IOUtil.getUserHome().equals(file)) {
                return ICON_ID_HOME;
            }
            if (file.isSymbolicLink()) {
                return "symlink";
            }
            return ICON_ID_DIRECTORY;
        }
        if (file.isFile() && file.isSymbolicLink()) {
            return "symlink";
        }
        if (file.isSymbolicLink()) {
            return "symlink";
        }
        return ICON_ID_FILE;
    }
}

