/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.createkey.passphrase;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.adapter.JavaBeanObjectProperty;
import javafx.beans.property.adapter.JavaBeanObjectPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import org.subshare.core.pgp.CreatePgpKeyParam;
import org.subshare.gui.IconSize;
import org.subshare.gui.pgp.createkey.passphrase.Messages;
import org.subshare.gui.severity.SeverityImageRegistry;
import org.subshare.gui.util.CharArrayStringConverter;
import org.subshare.gui.util.FxmlUtil;

public abstract class PassphrasePane
extends GridPane {
    private final CreatePgpKeyParam createPgpKeyParam;
    @FXML
    private Label passphrase1Label;
    @FXML
    private PasswordField passphrase1PasswordField;
    private final JavaBeanObjectProperty<char[]> passphrase1;
    @FXML
    private CheckBox noPassphraseCheckBox;
    @FXML
    private Label passphrase2Label;
    @FXML
    private PasswordField passphrase2PasswordField;
    private Severity passphrase1StatusSeverity;
    @FXML
    private HBox passphrase1StatusMessageBox;
    @FXML
    private ImageView passphrase1StatusImageView;
    @FXML
    private Label passphrase1StatusMessageLabel;
    private Severity passphrase2StatusSeverity;
    @FXML
    private HBox passphrase2StatusMessageBox;
    private final BooleanProperty passphrase2StatusMessageBoxVisible = new SimpleBooleanProperty((Object)this, "passphrase2StatusMessageBoxVisible", true);
    @FXML
    private ImageView passphrase2StatusImageView;
    @FXML
    private Label passphrase2StatusMessageLabel;
    private char[] backupPassphrase;

    public PassphrasePane(final CreatePgpKeyParam createPgpKeyParam) {
        this.createPgpKeyParam = (CreatePgpKeyParam)AssertUtil.assertNotNull((Object)createPgpKeyParam, (String)"createPgpKeyParam");
        FxmlUtil.loadDynamicComponentFxml(PassphrasePane.class, this);
        this.passphrase1 = this.createPassphraseProperty();
        Bindings.bindBidirectional((Property)this.passphrase1PasswordField.textProperty(), this.passphrase1, (StringConverter)new CharArrayStringConverter());
        this.passphrase1.addListener(observable -> this.updatePassphraseStatus());
        this.passphrase2PasswordField.textProperty().addListener(observable -> this.updatePassphraseStatus());
        this.noPassphraseCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    PassphrasePane.access$002(PassphrasePane.this, createPgpKeyParam.getPassphrase());
                    createPgpKeyParam.setPassphrase(new char[0]);
                } else {
                    createPgpKeyParam.setPassphrase(PassphrasePane.this.backupPassphrase);
                    PassphrasePane.access$002(PassphrasePane.this, null);
                }
            }
        });
        this.noPassphraseCheckBox.selectedProperty().addListener(observable -> this.updateComplete());
        this.passphrase1Label.disableProperty().bind((ObservableValue)this.noPassphraseCheckBox.selectedProperty());
        this.passphrase1PasswordField.disableProperty().bind((ObservableValue)this.noPassphraseCheckBox.selectedProperty());
        this.passphrase1StatusMessageBox.visibleProperty().bind((ObservableValue)this.noPassphraseCheckBox.selectedProperty().not());
        this.passphrase2PasswordField.disableProperty().bind((ObservableValue)this.noPassphraseCheckBox.selectedProperty());
        this.passphrase2Label.disableProperty().bind((ObservableValue)this.noPassphraseCheckBox.selectedProperty());
        this.passphrase2StatusMessageBox.visibleProperty().bind((ObservableValue)this.noPassphraseCheckBox.selectedProperty().not().and((ObservableBooleanValue)this.passphrase2StatusMessageBoxVisible));
        this.updatePassphraseStatus();
    }

    private void updatePassphraseStatus() {
        this.updatePassphrase1Status();
        this.updatePassphrase2Status();
        this.updateComplete();
    }

    private void updatePassphrase1Status() {
        Tooltip tooltip;
        String tooltipText;
        String message;
        Severity severity;
        char[] p1 = this.createPgpKeyParam.getPassphrase();
        if (p1.length == 0) {
            severity = Severity.ERROR;
            message = Messages.getString("PassphrasePane.passphrase1Status[empty].message");
            tooltipText = Messages.getString("PassphrasePane.passphrase1Status[empty].tooltipText");
        } else if (p1.length < 10) {
            severity = Severity.ERROR;
            message = Messages.getString("PassphrasePane.passphrase1Status[tooShort].message");
            tooltipText = Messages.getString("PassphrasePane.passphrase1Status[tooShort].tooltipText");
        } else if (this.getCharacterTypes(p1).size() < 2) {
            severity = Severity.ERROR;
            message = Messages.getString("PassphrasePane.passphrase1Status[tooFewCharTypes].message");
            tooltipText = Messages.getString("PassphrasePane.passphrase1Status[tooFewCharTypes].tooltipText");
        } else if (this.getCharacterTypes(p1).size() < 3) {
            severity = Severity.WARNING;
            message = Messages.getString("PassphrasePane.passphrase1Status[fewCharTypes].message");
            tooltipText = Messages.getString("PassphrasePane.passphrase1Status[fewCharTypes].tooltipText");
        } else if (p1.length < 15) {
            severity = Severity.WARNING;
            message = Messages.getString("PassphrasePane.passphrase1Status[short].message");
            tooltipText = Messages.getString("PassphrasePane.passphrase1Status[short].tooltipText");
        } else if (p1.length >= 20 && this.getCharacterTypes(p1).size() > 3) {
            severity = Severity.INFO;
            message = Messages.getString("PassphrasePane.passphrase1Status[secure].message");
            tooltipText = Messages.getString("PassphrasePane.passphrase1Status[secure].toolTipText");
        } else {
            severity = Severity.INFO;
            message = Messages.getString("PassphrasePane.passphrase1Status[ok].message");
            tooltipText = Messages.getString("PassphrasePane.passphrase1Status[ok].toolTipText");
        }
        this.passphrase1StatusSeverity = severity;
        this.passphrase1StatusImageView.setImage(severity == null ? null : SeverityImageRegistry.getInstance().getImage(severity, IconSize._16x16));
        this.passphrase1StatusMessageLabel.setText(message);
        Tooltip tooltip2 = tooltip = StringUtil.isEmpty((String)tooltipText) ? null : new Tooltip(tooltipText);
        if (tooltip != null) {
            tooltip.setWrapText(true);
        }
        this.passphrase1StatusMessageLabel.setTooltip(tooltip);
        this.passphrase1PasswordField.setTooltip(tooltip);
        this.passphrase1Label.setTooltip(tooltip);
    }

    private Set<Integer> getCharacterTypes(char[] chars) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (char c : chars) {
            int type = Character.getType(c);
            result.add(type);
        }
        return result;
    }

    private void updatePassphrase2Status() {
        Tooltip tooltip;
        String tooltipText;
        String message;
        Severity severity;
        char[] p1 = this.createPgpKeyParam.getPassphrase();
        char[] p2 = this.passphrase2PasswordField.getText().toCharArray();
        if (this.passphrase1StatusSeverity != null && this.passphrase1StatusSeverity.compareTo((Enum)Severity.WARNING) > 0) {
            severity = null;
            message = null;
            tooltipText = null;
        } else if (Arrays.equals(p1, p2)) {
            severity = null;
            message = null;
            tooltipText = null;
        } else {
            severity = Severity.ERROR;
            message = Messages.getString("PassphrasePane.passphrase2Status[mismatch].message");
            tooltipText = Messages.getString("PassphrasePane.passphrase2Status[mismatch].toolTipText");
        }
        this.passphrase2StatusSeverity = severity;
        this.passphrase2StatusMessageBoxVisible.set(severity != null);
        this.passphrase2StatusImageView.setImage(severity == null ? null : SeverityImageRegistry.getInstance().getImage(severity, IconSize._16x16));
        this.passphrase2StatusMessageLabel.setText(message);
        Tooltip tooltip2 = tooltip = StringUtil.isEmpty((String)tooltipText) ? null : new Tooltip(tooltipText);
        if (tooltip != null) {
            tooltip.setWrapText(true);
        }
        this.passphrase2StatusMessageLabel.setTooltip(tooltip);
        this.passphrase2PasswordField.setTooltip(tooltip);
        this.passphrase2Label.setTooltip(tooltip);
    }

    private JavaBeanObjectProperty<char[]> createPassphraseProperty() {
        try {
            return JavaBeanObjectPropertyBuilder.create().bean((Object)this.createPgpKeyParam).name(CreatePgpKeyParam.PropertyEnum.passphrase.name()).build();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isComplete() {
        boolean complete = true;
        if (!this.noPassphraseCheckBox.isSelected()) {
            if (this.passphrase1StatusSeverity != null && this.passphrase1StatusSeverity.compareTo((Enum)Severity.WARNING) > 0) {
                complete = false;
            }
            if (this.passphrase2StatusSeverity != null && this.passphrase2StatusSeverity.compareTo((Enum)Severity.WARNING) > 0) {
                complete = false;
            }
        }
        return complete;
    }

    protected abstract void updateComplete();

    public void requestFocus() {
        super.requestFocus();
        this.passphrase1PasswordField.requestFocus();
    }

    static /* synthetic */ char[] access$002(PassphrasePane x0, char[] x1) {
        x0.backupPassphrase = x1;
        return x1;
    }
}

