/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.serverlist;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.dto.DateTime;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.subshare.core.locker.sync.LockerSyncDaemon;
import org.subshare.core.pgp.sync.PgpSyncDaemon;
import org.subshare.core.server.Server;
import org.subshare.core.server.ServerRegistry;
import org.subshare.core.sync.SyncState;
import org.subshare.gui.IconSize;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.ls.LockerSyncDaemonLs;
import org.subshare.gui.ls.PgpSyncDaemonLs;
import org.subshare.gui.ls.ServerRegistryLs;
import org.subshare.gui.serverlist.ServerListItem;
import org.subshare.gui.severity.SeverityImageRegistry;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.UrlStringConverter;

public class ServerListPane
extends GridPane {
    private ServerRegistry serverRegistry;
    private PgpSyncDaemon pgpSyncDaemon;
    private LockerSyncDaemon lockerSyncDaemon;
    @FXML
    private Button addButton;
    @FXML
    private Button deleteButton;
    @FXML
    private TableView<ServerListItem> tableView;
    @FXML
    private TableColumn<ServerListItem, String> nameColumn;
    @FXML
    private TableColumn<ServerListItem, URL> urlColumn;
    @FXML
    private TableColumn<ServerListItem, Severity> severityIconColumn;
    private final ListChangeListener<ServerListItem> selectionListener = new ListChangeListener<ServerListItem>(){

        public void onChanged(ListChangeListener.Change<? extends ServerListItem> c) {
            ServerListPane.this.updateEnabled();
        }
    };
    private final PropertyChangeListener serversPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LinkedHashSet servers = new LinkedHashSet((List)evt.getNewValue());
            Platform.runLater(() -> ServerListPane.this.addOrRemoveTableItemsViewCallback(servers));
        }
    };
    private final PropertyChangeListener syncStatePropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Platform.runLater(() -> {
                for (ServerListItem serverListItem : ServerListPane.this.tableView.getItems()) {
                    ServerListPane.this.updateSyncStates(serverListItem);
                }
            });
        }
    };

    public ServerListPane() {
        FxmlUtil.loadDynamicComponentFxml(ServerListPane.class, this);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.getSelectionModel().getSelectedItems().addListener(this.selectionListener);
        this.nameColumn.setCellFactory((Callback)Util.cast((Object)TextFieldTableCell.forTableColumn()));
        this.urlColumn.setCellFactory((Callback)Util.cast((Object)TextFieldTableCell.forTableColumn((StringConverter)new UrlStringConverter())));
        this.severityIconColumn.setCellFactory(l -> new TableCell<ServerListItem, Severity>(){

            public void updateItem(Severity severity, boolean empty) {
                ImageView imageView = null;
                Tooltip tooltip = null;
                if (severity != null) {
                    ServerListItem listItem = (ServerListItem)this.getTableRow().getItem();
                    if (listItem == null) {
                        return;
                    }
                    String tooltipText = listItem.getTooltipText();
                    imageView = new ImageView(SeverityImageRegistry.getInstance().getImage(severity, IconSize._16x16));
                    if (!StringUtil.isEmpty((String)tooltipText)) {
                        tooltip = new Tooltip(tooltipText);
                    }
                }
                this.setGraphic((Node)imageView);
                this.setTooltip(tooltip);
            }
        });
        this.populateTableViewAsync();
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean selectionEmpty = this.tableView.getSelectionModel().getSelectedItems().isEmpty();
        this.deleteButton.setDisable(selectionEmpty);
    }

    private void populateTableViewAsync() {
        new Service<Collection<Server>>(){

            protected Task<Collection<Server>> createTask() {
                return new SsTask<Collection<Server>>(){

                    protected Collection<Server> call() throws Exception {
                        ServerListPane.this.getPgpSyncDaemon();
                        ServerListPane.this.getLockerSyncDaemon();
                        return ServerListPane.this.getServerRegistry().getServers();
                    }

                    protected void succeeded() {
                        Collection servers;
                        try {
                            servers = (Collection)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        ServerListPane.this.addOrRemoveTableItemsViewCallback(servers);
                    }
                };
            }
        }.start();
    }

    protected synchronized ServerRegistry getServerRegistry() {
        if (this.serverRegistry == null) {
            this.serverRegistry = ServerRegistryLs.getServerRegistry();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.serverRegistry, (PropertyBase)ServerRegistry.PropertyEnum.servers, (PropertyChangeListener)this.serversPropertyChangeListener);
        }
        return this.serverRegistry;
    }

    protected PgpSyncDaemon getPgpSyncDaemon() {
        if (this.pgpSyncDaemon == null) {
            this.pgpSyncDaemon = PgpSyncDaemonLs.getPgpSyncDaemon();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Object)this.pgpSyncDaemon, (PropertyChangeListener)this.syncStatePropertyChangeListener);
        }
        return this.pgpSyncDaemon;
    }

    protected LockerSyncDaemon getLockerSyncDaemon() {
        if (this.lockerSyncDaemon == null) {
            this.lockerSyncDaemon = LockerSyncDaemonLs.getLockerSyncDaemon();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Object)this.lockerSyncDaemon, (PropertyChangeListener)this.syncStatePropertyChangeListener);
        }
        return this.lockerSyncDaemon;
    }

    private void addOrRemoveTableItemsViewCallback(Collection<Server> servers) {
        AssertUtil.assertNotNull(servers, (String)"servers");
        HashMap<Server, ServerListItem> viewServer2ServerListItem = new HashMap<Server, ServerListItem>();
        for (ServerListItem sli : this.tableView.getItems()) {
            viewServer2ServerListItem.put(sli.getServer(), sli);
        }
        for (Server server : servers) {
            if (viewServer2ServerListItem.containsKey(server)) continue;
            ServerListItem sli = new ServerListItem(server);
            this.updateSyncStates(sli);
            viewServer2ServerListItem.put(server, sli);
            this.tableView.getItems().add((Object)sli);
        }
        if (servers.size() < viewServer2ServerListItem.size()) {
            for (Server server : servers) {
                viewServer2ServerListItem.remove(server);
            }
            for (ServerListItem sli : viewServer2ServerListItem.values()) {
                this.tableView.getItems().remove((Object)sli);
            }
        }
    }

    protected void updateSyncStates(ServerListItem serverListItem) {
        Server server = ((ServerListItem)AssertUtil.assertNotNull((Object)serverListItem, (String)"serverListItem")).getServer();
        AssertUtil.assertNotNull((Object)server, (String)"serverListItem.server");
        SyncState state = this.getPgpSyncDaemon().getState(serverListItem.getServer());
        serverListItem.setPgpSyncState(state);
        state = this.getLockerSyncDaemon().getState(serverListItem.getServer());
        serverListItem.setLockerSyncState(state);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @FXML
    private void addButtonClicked(ActionEvent event) {
        Server server = this.getServerRegistry().createServer();
        server.setName("Server " + new DateTime(new Date()));
        try {
            server.setUrl(new URL("https://host.domain.tld:1234"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException();
        }
        this.getServerRegistry().getServers().add(server);
    }

    @FXML
    private void deleteButtonClicked(ActionEvent event) {
        ObservableList selectedItems = this.tableView.getSelectionModel().getSelectedItems();
        ArrayList<Server> selectedServers = new ArrayList<Server>(selectedItems.size());
        for (ServerListItem serverListItem : selectedItems) {
            selectedServers.add(serverListItem.getServer());
        }
        this.getServerRegistry().getServers().removeAll(selectedServers);
    }

    @FXML
    private void syncButtonClicked(ActionEvent event) {
        this.getPgpSyncDaemon().sync();
        this.getLockerSyncDaemon().sync();
    }
}

