/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.transport;

import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.UrlDecoder;
import co.codewizards.cloudstore.core.util.UrlUtil;
import java.net.URL;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepoTransport
implements RepoTransport {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRepoTransport.class);
    private static final String SLASH = "/";
    private RepoTransportFactory repoTransportFactory;
    private URL remoteRoot;
    private URL remoteRootWithoutPathPrefix;
    private String pathPrefix;
    private UUID clientRepositoryId;
    private volatile Throwable repoTransportCreatedStackTraceException = new Exception("repoTransportCreatedStackTraceException").fillInStackTrace();

    @Override
    public RepoTransportFactory getRepoTransportFactory() {
        return this.repoTransportFactory;
    }

    @Override
    public void setRepoTransportFactory(RepoTransportFactory repoTransportFactory) {
        this.repoTransportFactory = AssertUtil.assertNotNull(repoTransportFactory, "repoTransportFactory");
    }

    @Override
    public URL getRemoteRoot() {
        return this.remoteRoot;
    }

    @Override
    public void setRemoteRoot(URL remoteRoot) {
        remoteRoot = UrlUtil.canonicalizeURL(remoteRoot);
        URL rr = this.remoteRoot;
        if (rr != null && !rr.equals(remoteRoot)) {
            throw new IllegalStateException("Cannot re-assign remoteRoot!");
        }
        this.remoteRoot = remoteRoot;
    }

    public UUID getClientRepositoryIdOrFail() {
        UUID clientRepositoryId = this.getClientRepositoryId();
        if (clientRepositoryId == null) {
            throw new IllegalStateException("clientRepositoryId == null :: You must invoke setClientRepositoryId(...) before!");
        }
        return clientRepositoryId;
    }

    @Override
    public UUID getClientRepositoryId() {
        return this.clientRepositoryId;
    }

    @Override
    public void setClientRepositoryId(UUID clientRepositoryId) {
        this.clientRepositoryId = clientRepositoryId;
    }

    @Override
    public URL getRemoteRootWithoutPathPrefix() {
        if (this.remoteRootWithoutPathPrefix == null) {
            this.remoteRootWithoutPathPrefix = UrlUtil.canonicalizeURL(this.determineRemoteRootWithoutPathPrefix());
        }
        return this.remoteRootWithoutPathPrefix;
    }

    protected abstract URL determineRemoteRootWithoutPathPrefix();

    @Override
    public String getPathPrefix() {
        String pathPrefix = this.pathPrefix;
        if (pathPrefix == null) {
            this.pathPrefix = pathPrefix = this.determinePathPrefix();
        }
        return pathPrefix;
    }

    protected String determinePathPrefix() {
        String urlEncodedPathPrefix;
        String remoteRootWithoutPathPrefix;
        URL rr = this.getRemoteRoot();
        if (rr == null) {
            throw new IllegalStateException("remoteRoot not yet assigned!");
        }
        String remoteRoot = rr.toExternalForm();
        if (!remoteRoot.startsWith(remoteRootWithoutPathPrefix = this.getRemoteRootWithoutPathPrefix().toExternalForm())) {
            throw new IllegalStateException(String.format("remoteRoot='%s' does not start with remoteRootWithoutPathPrefix='%s'", remoteRoot, remoteRootWithoutPathPrefix));
        }
        if (remoteRoot.equals(remoteRootWithoutPathPrefix)) {
            urlEncodedPathPrefix = "";
        } else {
            urlEncodedPathPrefix = remoteRoot.substring(remoteRootWithoutPathPrefix.length());
            if (!urlEncodedPathPrefix.startsWith(SLASH)) {
                urlEncodedPathPrefix = SLASH + urlEncodedPathPrefix;
            }
            if (urlEncodedPathPrefix.endsWith(SLASH)) {
                throw new IllegalStateException("pathPrefix should not end with '/', but it does!");
            }
        }
        String pathPrefix = UrlDecoder.decode(urlEncodedPathPrefix);
        return pathPrefix;
    }

    @Override
    public String prefixPath(String path) {
        AssertUtil.assertNotNull(path, "path");
        if ("".equals(path) || SLASH.equals(path)) {
            return this.getPathPrefix();
        }
        if (path.startsWith(SLASH)) {
            return this.getPathPrefix() + path;
        }
        return this.getPathPrefix() + SLASH + path;
    }

    @Override
    public String unprefixPath(String path) {
        AssertUtil.assertNotNull(path, "path");
        String pathPrefix = this.getPathPrefix();
        if (pathPrefix.isEmpty()) {
            return path;
        }
        if (!path.startsWith(SLASH)) {
            path = SLASH + path;
        }
        if (!path.startsWith(pathPrefix)) {
            throw new IllegalArgumentException(String.format("path='%s' does not start with pathPrefix='%s'!", path, pathPrefix));
        }
        String result = path.substring(pathPrefix.length());
        if (!result.isEmpty() && !result.startsWith(SLASH)) {
            throw new IllegalStateException(String.format("pathAfterPathPrefix='%s' is neither empty nor does it start with a '/'! path='%s' pathPrefix='%s'", result, path, pathPrefix));
        }
        return result;
    }

    protected boolean isPathUnderPathPrefix(String path) {
        AssertUtil.assertNotNull(path, "path");
        String pathPrefix = this.getPathPrefix();
        if (pathPrefix.isEmpty()) {
            return true;
        }
        return path.startsWith(pathPrefix);
    }

    protected void finalize() throws Throwable {
        if (this.repoTransportCreatedStackTraceException != null) {
            logger.warn("finalize: Detected forgotten close() invocation!", this.repoTransportCreatedStackTraceException);
        }
        super.finalize();
    }

    @Override
    public void close() {
        this.repoTransportCreatedStackTraceException = null;
    }
}

