/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.client;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.client.LocalServerClient;
import co.codewizards.cloudstore.ls.core.invoke.ObjectManager;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRef;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefConverter;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxy;

class ObjectRefConverterImpl
implements ObjectRefConverter {
    private final LocalServerClient localServerClient;
    private final ObjectManager objectManager;

    public ObjectRefConverterImpl(LocalServerClient localServerClient) {
        this.localServerClient = (LocalServerClient)AssertUtil.assertNotNull((Object)localServerClient, (String)"localServerClient");
        this.objectManager = (ObjectManager)AssertUtil.assertNotNull((Object)localServerClient.getObjectManager(), (String)"localServerClient.objectManager");
    }

    public Object convertToObjectRefIfNeeded(Object object) {
        if (object instanceof RemoteObjectProxy) {
            return AssertUtil.assertNotNull((Object)((RemoteObjectProxy)object).getObjectRef(), (String)"object.getObjectRef()");
        }
        return this.objectManager.getObjectRefOrObject(object);
    }

    public Object convertFromObjectRefIfNeeded(Object object) {
        if (object instanceof ObjectRef) {
            ObjectRef objectRef = (ObjectRef)object;
            if (this.objectManager.getClientId().equals((Object)objectRef.getClientId())) {
                return this.objectManager.getObjectOrFail(objectRef);
            }
            return this.localServerClient.getRemoteObjectProxyOrCreate(objectRef);
        }
        return object;
    }
}

