/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.dto;

import co.codewizards.cloudstore.core.Uid;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.subshare.core.dto.SignatureDto;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.Signature;

@XmlRootElement
public class RepositoryOwnerDto
implements Signable {
    public static final String SIGNED_DATA_TYPE = "RepositoryOwner";
    private UUID serverRepositoryId;
    private Uid userRepoKeyId;
    @XmlElement
    private SignatureDto signatureDto;

    public UUID getServerRepositoryId() {
        return this.serverRepositoryId;
    }

    public void setServerRepositoryId(UUID serverRepositoryId) {
        this.serverRepositoryId = serverRepositoryId;
    }

    public Uid getUserRepoKeyId() {
        return this.userRepoKeyId;
    }

    public void setUserRepoKeyId(Uid userRepoKeyId) {
        this.userRepoKeyId = userRepoKeyId;
    }

    @Override
    public String getSignedDataType() {
        return SIGNED_DATA_TYPE;
    }

    @Override
    public int getSignedDataVersion() {
        return 0;
    }

    @Override
    public InputStream getSignedData(int signedDataVersion) {
        byte separatorIndex = 0;
        try {
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[3];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource(this.serverRepositoryId);
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource(this.userRepoKeyId);
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    @XmlTransient
    public Signature getSignature() {
        return this.signatureDto;
    }

    @Override
    public void setSignature(Signature signature) {
        this.signatureDto = SignatureDto.copyIfNeeded(signature);
    }
}

