/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto.internal.symmetric;

import java.security.SecureRandom;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.subshare.crypto.SecretKeyGenerator;

public class SecretKeyGeneratorImpl
implements SecretKeyGenerator {
    private int strength;
    private int strengthInBytes;
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters params) {
        this.strength = 0;
        this.random = null;
        if (params != null) {
            this.strength = params.getStrength();
            this.random = params.getRandom();
        }
        if (this.strength < 1) {
            this.strength = 256;
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.strengthInBytes = (this.strength + 7) / 8;
    }

    @Override
    public KeyParameter generateKey() {
        if (this.random == null) {
            throw new IllegalStateException("init(...) was not yet called!");
        }
        byte[] key = new byte[this.strengthInBytes];
        this.random.nextBytes(key);
        return new KeyParameter(key);
    }
}

