/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.transport;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.dto.FileChunkDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionPostCloseAdapter;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionPostCloseEvent;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionPostCloseListener;
import co.codewizards.cloudstore.core.repo.transport.CollisionException;
import co.codewizards.cloudstore.core.repo.transport.DeleteModificationCollisionException;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.LocalRepoSync;
import co.codewizards.cloudstore.local.persistence.FileChunk;
import co.codewizards.cloudstore.local.persistence.LastSyncToRemoteRepo;
import co.codewizards.cloudstore.local.persistence.LastSyncToRemoteRepoDao;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import co.codewizards.cloudstore.local.transport.FileRepoTransport;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactory;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.LocalRepoStorage;
import org.subshare.core.LocalRepoStorageFactoryRegistry;
import org.subshare.core.dto.SsFileChunkDto;
import org.subshare.core.dto.SsNormalFileDto;
import org.subshare.core.repo.transport.CryptreeClientFileRepoTransport;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.core.user.UserRepoKeyRingLookup;
import org.subshare.core.user.UserRepoKeyRingLookupContext;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.PreliminaryCollision;
import org.subshare.local.persistence.PreliminaryCollisionDao;
import org.subshare.local.persistence.PreliminaryDeletion;
import org.subshare.local.persistence.PreliminaryDeletionDao;
import org.subshare.local.persistence.SsFileChunk;
import org.subshare.local.persistence.SsNormalFile;

public class CryptreeFileRepoTransportImpl
extends FileRepoTransport
implements CryptreeClientFileRepoTransport {
    private static final Logger logger = LoggerFactory.getLogger(CryptreeFileRepoTransportImpl.class);
    private Boolean metaOnly;
    private CryptreeFactory cryptreeFactory;
    private UserRepoKeyRing userRepoKeyRing;

    public void delete(String path) {
        if (this.isMetaOnly()) {
            path = this.prefixPath(path);
            File localRoot = this.getLocalRepoManager().getLocalRoot();
            try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
                RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
                File file = this.getFile(path);
                RepoFile repoFile = repoFileDao.getRepoFile(localRoot, file);
                if (repoFile != null) {
                    this.deleteRepoFileRecursively(transaction, repoFile);
                }
                transaction.commit();
            }
        }
        try {
            super.delete(path);
        }
        catch (CollisionException x) {
            this.clearCryptoRepoFileDeleted(path);
            throw x;
        }
    }

    public void clearCryptoRepoFileDeleted(String path) {
        path = this.prefixPath(path);
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            this.getCryptree(transaction).clearCryptoRepoFileDeleted(path);
            transaction.commit();
        }
    }

    protected CryptreeFactory getCryptreeFactory() {
        if (this.cryptreeFactory == null) {
            this.cryptreeFactory = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail();
        }
        return this.cryptreeFactory;
    }

    protected Cryptree getCryptree(LocalRepoTransaction transaction) {
        return this.getCryptreeFactory().getCryptreeOrCreate(transaction, this.getClientRepositoryIdOrFail(), this.getPathPrefix(), this.getUserRepoKeyRing());
    }

    protected UserRepoKeyRing getUserRepoKeyRing() {
        if (this.userRepoKeyRing == null) {
            UserRepoKeyRingLookup lookup = UserRepoKeyRingLookup.Helper.getUserRepoKeyRingLookup();
            UserRepoKeyRingLookupContext context = new UserRepoKeyRingLookupContext(this.getRepositoryId(), this.getClientRepositoryIdOrFail());
            this.userRepoKeyRing = lookup.getUserRepoKeyRing(context);
            if (this.userRepoKeyRing == null) {
                throw new IllegalStateException(String.format("UserRepoKeyRingLookup.getUserRepoKeyRing(context) returned null! lookup=%s context=%s", lookup, context));
            }
        }
        return this.userRepoKeyRing;
    }

    private void deleteRepoFileRecursively(LocalRepoTransaction transaction, RepoFile repoFile) {
        RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
        for (RepoFile childRepoFile : repoFileDao.getChildRepoFiles(repoFile)) {
            this.deleteRepoFileRecursively(transaction, childRepoFile);
        }
        repoFileDao.deletePersistent(repoFile);
    }

    protected RepoFile syncRepoFile(LocalRepoTransaction transaction, File file) {
        AssertUtil.assertNotNull((Object)transaction, (String)"transaction");
        AssertUtil.assertNotNull((Object)file, (String)"file");
        File localRoot = this.getLocalRepoManager().getLocalRoot();
        RepoFileDao rfDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
        RepoFile repoFile = rfDao.getRepoFile(localRoot, file);
        if (repoFile != null && !LocalRepoSync.create((LocalRepoTransaction)transaction).isRepoFileTypeCorrect(repoFile, file)) {
            rfDao.deletePersistent(repoFile);
            repoFile = null;
            transaction.flush();
        }
        repoFile = super.syncRepoFile(transaction, file);
        return repoFile;
    }

    private boolean isMetaOnly() {
        if (this.metaOnly == null) {
            try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginReadTransaction();){
                LocalRepoStorage lrs = LocalRepoStorageFactoryRegistry.getInstance().getLocalRepoStorageFactoryOrFail().getLocalRepoStorageOrCreate(transaction);
                this.metaOnly = lrs.isMetaOnly();
                transaction.commit();
            }
        }
        return this.metaOnly;
    }

    protected void mkDir(LocalRepoTransaction transaction, UUID clientRepositoryId, File file, Date lastModified) {
        super.mkDir(transaction, clientRepositoryId, file, lastModified);
    }

    protected void detectAndHandleFileCollision(LocalRepoTransaction transaction, UUID fromRepositoryId, File file, RepoFile normalFileOrSymlink) {
        super.detectAndHandleFileCollision(transaction, fromRepositoryId, file, normalFileOrSymlink);
    }

    protected File handleFileCollision(LocalRepoTransaction transaction, UUID fromRepositoryId, final File file) {
        transaction.addPostCloseListener((LocalRepoTransactionPostCloseListener)new LocalRepoTransactionPostCloseAdapter(){

            public void postRollback(LocalRepoTransactionPostCloseEvent event) {
                CryptreeFileRepoTransportImpl.this.createAndPersistPreliminaryCollision(event.getLocalRepoManager(), file, null, null);
            }

            public void postCommit(LocalRepoTransactionPostCloseEvent event) {
                throw new IllegalStateException("Commit is not allowed, anymore!");
            }
        });
        throw new CollisionException();
    }

    protected void handleFileTypeCollision(LocalRepoTransaction transaction, UUID fromRepositoryId, File file, Class<? extends RepoFileDto> fromFileType) {
        RemoteRepository remoteRepository = ((RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(fromRepositoryId);
        LastSyncToRemoteRepo lastSyncToRemoteRepo = ((LastSyncToRemoteRepoDao)transaction.getDao(LastSyncToRemoteRepoDao.class)).getLastSyncToRemoteRepo(remoteRepository);
        File localRoot = this.getLocalRepoManager().getLocalRoot();
        RepoFile repoFile = ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(localRoot, file);
        if (lastSyncToRemoteRepo != null && repoFile.getLocalRevision() <= lastSyncToRemoteRepo.getLocalRepositoryRevisionSynced()) {
            file.deleteRecursively();
            return;
        }
        super.handleFileTypeCollision(transaction, fromRepositoryId, file, fromFileType);
    }

    protected void createAndPersistPreliminaryCollision(LocalRepoManager localRepoManager, File file, String localPath, Uid cryptoRepoFileId) {
        AssertUtil.assertNotNull((Object)localRepoManager, (String)"localRepoManager");
        if (localPath == null) {
            AssertUtil.assertNotNull((Object)file, (String)"localPath/file");
        }
        logger.debug("createAndPersistPreliminaryCollision: localRoot='{}' localRepositoryId={} file='{}' localPath='{}' cryptoRepoFileId={}", new Object[]{localRepoManager.getLocalRoot(), this.getRepositoryId(), file == null ? "" : file.getAbsolutePath(), localPath == null ? "" : localPath, cryptoRepoFileId});
        try (LocalRepoTransaction tx = localRepoManager.beginWriteTransaction();){
            RepoFileDao rfDao;
            RepoFile repoFile;
            PreliminaryCollisionDao pcDao;
            PreliminaryCollision preliminaryCollision;
            if (localPath == null) {
                localPath = '/' + localRepoManager.getLocalRoot().relativize(file).replace(OioFileFactory.FILE_SEPARATOR_CHAR, '/');
            }
            if ((preliminaryCollision = (pcDao = (PreliminaryCollisionDao)((Object)tx.getDao(PreliminaryCollisionDao.class))).getPreliminaryCollision(localPath)) == null) {
                preliminaryCollision = new PreliminaryCollision();
                preliminaryCollision.setPath(localPath);
                preliminaryCollision = (PreliminaryCollision)pcDao.makePersistent(preliminaryCollision);
            }
            CryptoRepoFileDao crfDao = (CryptoRepoFileDao)((Object)tx.getDao(CryptoRepoFileDao.class));
            if (cryptoRepoFileId != null) {
                CryptoRepoFile cryptoRepoFile = crfDao.getCryptoRepoFileOrFail(cryptoRepoFileId);
                preliminaryCollision.setCryptoRepoFile(cryptoRepoFile);
            } else if (file != null && (repoFile = (rfDao = (RepoFileDao)tx.getDao(RepoFileDao.class)).getRepoFile(localRepoManager.getLocalRoot(), file)) != null) {
                CryptoRepoFile cryptoRepoFile = crfDao.getCryptoRepoFileOrFail(repoFile);
                preliminaryCollision.setCryptoRepoFile(cryptoRepoFile);
            }
            tx.commit();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public void beginPutFile(String path) {
        throw new UnsupportedOperationException("Should not be invoked on client-side!");
    }

    public void beginPutFile(String path, SsNormalFileDto normalFileDto) {
        super.beginPutFile(path);
    }

    public void endPutFile(String path, Date lastModified, long length, String sha1) {
        throw new UnsupportedOperationException("Should not be invoked on client-side!");
    }

    public void endPutFile(String path, SsNormalFileDto fromNormalFileDto) {
        this.putPaddingMetaData(path, fromNormalFileDto);
        super.endPutFile(path, fromNormalFileDto.getLastModified(), fromNormalFileDto.getLength(), fromNormalFileDto.getSha1());
    }

    private void putPaddingMetaData(String path, SsNormalFileDto fromNormalFileDto) {
        path = this.prefixPath(path);
        AssertUtil.assertNotNull((Object)fromNormalFileDto, (String)"fromNormalFileDto");
        File file = this.getFile(path);
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            RepoFile repoFile = ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(this.getLocalRepoManager().getLocalRoot(), file);
            if (!(repoFile instanceof NormalFile)) {
                throw new IllegalStateException(String.format("RepoFile is not an instance of NormalFile! repoFile=%s file=%s", repoFile, file));
            }
            SsNormalFile normalFile = (SsNormalFile)repoFile;
            normalFile.setLengthWithPadding(fromNormalFileDto.getLengthWithPadding());
            HashMap<Long, SsFileChunk> offset2FileChunk = new HashMap<Long, SsFileChunk>(normalFile.getFileChunks().size());
            for (FileChunk fc : normalFile.getFileChunks()) {
                offset2FileChunk.put(fc.getOffset(), (SsFileChunk)fc);
            }
            for (FileChunkDto fcDto : fromNormalFileDto.getFileChunkDtos()) {
                SsFileChunkDto fileChunkDto = (SsFileChunkDto)fcDto;
                if (fileChunkDto.getLength() > 0) continue;
                boolean isNew = false;
                SsFileChunk fileChunk = (SsFileChunk)((Object)offset2FileChunk.get(fileChunkDto.getOffset()));
                if (fileChunk == null) {
                    isNew = true;
                    fileChunk = (SsFileChunk)((Object)ObjectFactoryUtil.createObject(FileChunk.class));
                    fileChunk.setNormalFile(normalFile);
                    fileChunk.setOffset(fileChunkDto.getOffset());
                }
                fileChunk.makeWritable();
                fileChunk.setLength(fileChunkDto.getLength());
                fileChunk.setLengthWithPadding(fileChunkDto.getLengthWithPadding());
                fileChunk.setSha1(fileChunkDto.getSha1());
                fileChunk.makeReadOnly();
                if (!isNew) continue;
                normalFile.getFileChunks().add(fileChunk);
            }
            transaction.commit();
        }
    }

    protected void assertNoDeleteModificationCollision(LocalRepoTransaction transaction, UUID fromRepositoryId, final String path) throws CollisionException {
        CryptoRepoFile cryptoRepoFile;
        final Uid cryptoRepoFileId = this.getCryptree(transaction).getCryptoRepoFileId(path);
        if (cryptoRepoFileId == null) {
            return;
        }
        PreliminaryDeletionDao pdDao = (PreliminaryDeletionDao)((Object)transaction.getDao(PreliminaryDeletionDao.class));
        for (CryptoRepoFile crf = cryptoRepoFile = ((CryptoRepoFileDao)((Object)transaction.getDao(CryptoRepoFileDao.class))).getCryptoRepoFileOrFail(cryptoRepoFileId); crf != null; crf = crf.getParent()) {
            String candidateLocalPath = crf.getLocalPathOrFail();
            PreliminaryDeletion preliminaryDeletion = pdDao.getPreliminaryDeletion(crf);
            if (crf.getDeleted() == null && preliminaryDeletion == null) continue;
            transaction.addPostCloseListener((LocalRepoTransactionPostCloseListener)new LocalRepoTransactionPostCloseAdapter(){

                public void postRollback(LocalRepoTransactionPostCloseEvent event) {
                    CryptreeFileRepoTransportImpl.this.createAndPersistPreliminaryCollision(event.getLocalRepoManager(), null, path, cryptoRepoFileId);
                }

                public void postCommit(LocalRepoTransactionPostCloseEvent event) {
                    throw new IllegalStateException("Commit is not allowed, anymore!");
                }
            });
            throw new DeleteModificationCollisionException(String.format("The associated CryptoRepoFile or one of its parents is marked as deleted! repositoryId=%s path='%s' deletedPath='%s'", fromRepositoryId, path, candidateLocalPath));
        }
    }
}

