/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.updater.gui;

import co.codewizards.cloudstore.core.appid.AppIdRegistry;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.updater.SubShareUpdater;
import org.subshare.updater.gui.console.ConsolePane;
import org.subshare.updater.gui.console.ConsolePrintStream;

public class SubShareUpdaterGui
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(SubShareUpdaterGui.class);
    private ConsolePane consolePane;

    public void start(Stage primaryStage) {
        this.consolePane = new ConsolePane(){

            @Override
            protected void okButtonClicked(ActionEvent event) {
                Platform.exit();
            }
        };
        this.consolePane.setHeaderText(false, String.format("Updating %s...", AppIdRegistry.getInstance().getAppIdOrFail().getName()));
        this.consolePane.println(String.format("Updating %s. This can take a while. Please be patient and wait...", AppIdRegistry.getInstance().getAppIdOrFail().getName()));
        ConsolePrintStream cps = new ConsolePrintStream(this.consolePane);
        System.setOut(cps);
        System.setErr(cps);
        primaryStage.setScene(new Scene((Parent)this.consolePane));
        primaryStage.show();
        primaryStage.setTitle("Subshare Updater");
        String[] args = this.getParameters().getRaw().toArray(new String[0]);
        new UpdaterThread(args).start();
    }

    public static void main(String[] args) {
        SubShareUpdaterGui.launch((String[])args);
    }

    private void handleError(Throwable error) {
        if (Platform.isFxApplicationThread()) {
            this._handleError(error);
        } else {
            Platform.runLater(() -> this._handleError(error));
        }
    }

    private void _handleError(Throwable error) {
        if (error == null) {
            logger.error("_handleError: error == null", (Throwable)new RuntimeException("StackTrace"));
            return;
        }
        logger.error("_handleError: " + error, error);
        this.consolePane.setHeaderText(true, "Update failed!");
        this.consolePane.appendError(error);
    }

    private class UpdaterThread
    extends Thread {
        private final String[] args;

        public UpdaterThread(String[] args) {
            this.args = args;
            this.setName("UpdaterThread");
        }

        @Override
        public void run() {
            try {
                int resultCode = new SubShareUpdater(this.args).execute();
                if (resultCode != 0) {
                    throw new IllegalStateException("error-code: " + resultCode);
                }
                Platform.runLater(() -> SubShareUpdaterGui.this.consolePane.setHeaderText(false, "Update successful!"));
            }
            catch (Exception e) {
                SubShareUpdaterGui.this.handleError(e);
            }
            finally {
                Platform.runLater(() -> SubShareUpdaterGui.this.consolePane.setDone(true));
            }
        }
    }
}

