/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.user;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.client.util.FileLs;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.adapter.JavaBeanStringProperty;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Callback;
import org.subshare.core.pgp.CreatePgpKeyParam;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpOwnerTrust;
import org.subshare.core.pgp.man.PgpPrivateKeyPassphraseStore;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistry;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.ls.PgpPrivateKeyPassphraseManagerLs;
import org.subshare.gui.ls.UserRegistryLs;
import org.subshare.gui.pgp.assignownertrust.AssignOwnerTrustData;
import org.subshare.gui.pgp.assignownertrust.AssignOwnerTrustWizard;
import org.subshare.gui.pgp.certify.CertifyPgpKeyData;
import org.subshare.gui.pgp.certify.CertifyPgpKeyWizard;
import org.subshare.gui.pgp.createkey.CreatePgpKeyWizard;
import org.subshare.gui.pgp.createkey.FxPgpUserId;
import org.subshare.gui.pgp.createkey.TimeUnit;
import org.subshare.gui.pgp.creatingkey.CreatingPgpKeyDialog;
import org.subshare.gui.pgp.keytree.PgpKeyPgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreePane;
import org.subshare.gui.pgp.keytree.UserRootPgpKeyTreeItem;
import org.subshare.gui.pgp.selectkey.SelectPgpKeyDialog;
import org.subshare.gui.selectuser.SelectUserDialog;
import org.subshare.gui.user.EditUserManager;
import org.subshare.gui.user.EmailWrapper;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardDialog;
import org.subshare.gui.wizard.WizardState;

public class UserPane
extends GridPane {
    private final EditUserManager editUserManager;
    private final User user;
    private final JavaBeanStringProperty firstNameProperty;
    private final JavaBeanStringProperty lastNameProperty;
    private final ObservableList<EmailWrapper> emailWrappers;
    @FXML
    private TextField firstNameTextField;
    @FXML
    private TextField lastNameTextField;
    @FXML
    private TableView<EmailWrapper> emailsTableView;
    @FXML
    private TableColumn<EmailWrapper, String> emailTableColumn;
    @FXML
    private PgpKeyTreePane pgpKeyTreePane;
    @FXML
    private Button createPgpKeyButton;
    @FXML
    private Button ownerTrustButton;
    @FXML
    private Button exportPgpKeyButton;
    @FXML
    private Button assignPgpKeyToOtherUserButton;
    @FXML
    private Button signPgpKeyButton;
    @FXML
    private Button deletePgpKeyButton;
    private boolean ignoreUpdateEmailsOrWrappers;
    private final PropertyChangeListener userEmailsPropertyChangeListener = event -> Platform.runLater(() -> this.updateEmailWrappers());
    private final InvalidationListener emailWrapperInvalidationListener = observable -> this.updateEmails();

    public UserPane(EditUserManager editUserManager, User user) {
        this.editUserManager = (EditUserManager)AssertUtil.assertNotNull((Object)editUserManager, (String)"editUserManager");
        this.user = (User)AssertUtil.assertNotNull((Object)user, (String)"user");
        FxmlUtil.loadDynamicComponentFxml(UserPane.class, this);
        try {
            this.firstNameProperty = JavaBeanStringPropertyBuilder.create().bean((Object)user).name(User.PropertyEnum.firstName.name()).build();
            this.firstNameTextField.textProperty().bindBidirectional((Property)this.firstNameProperty);
            this.lastNameProperty = JavaBeanStringPropertyBuilder.create().bean((Object)user).name(User.PropertyEnum.lastName.name()).build();
            this.lastNameTextField.textProperty().bindBidirectional((Property)this.lastNameProperty);
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.user, (PropertyBase)User.PropertyEnum.emails, (PropertyChangeListener)this.userEmailsPropertyChangeListener);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.emailWrappers = FXCollections.observableList(this.createEmailWrapperList());
        this.emailWrappers.addListener(c -> this.updateEmails());
        this.emailsTableView.setItems(this.emailWrappers);
        this.emailTableColumn.setCellFactory((Callback)Util.cast((Object)TextFieldTableCell.forTableColumn()));
        this.emailTableColumn.prefWidthProperty().bind((ObservableValue)this.emailsTableView.widthProperty().subtract(10));
        UserRootPgpKeyTreeItem root = new UserRootPgpKeyTreeItem(this.pgpKeyTreePane, user);
        this.pgpKeyTreePane.getTreeTableView().setRoot((TreeItem)root);
        this.pgpKeyTreePane.getTreeTableView().getSelectionModel().getSelectedItems().addListener(observable -> this.updateDisable());
        this.updateDisable();
    }

    private void updateDisable() {
        int selectedPgpKeysSize = this.getSelectedPgpKeys().size();
        this.ownerTrustButton.setDisable(this.pgpKeyTreePane.getTreeTableView().getRoot().getChildren().size() < 1);
        this.deletePgpKeyButton.setDisable(selectedPgpKeysSize == 0);
        this.assignPgpKeyToOtherUserButton.setDisable(selectedPgpKeysSize == 0);
        this.signPgpKeyButton.setDisable(selectedPgpKeysSize != 1);
    }

    private Set<PgpKey> getSelectedPgpKeys() {
        LinkedHashSet<PgpKey> result = new LinkedHashSet<PgpKey>();
        for (TreeItem treeItem : this.pgpKeyTreePane.getTreeTableView().getSelectionModel().getSelectedItems()) {
            if (treeItem == null) continue;
            PgpKeyTreeItem pgpKeyTreeItem = (PgpKeyTreeItem)((Object)treeItem.getValue());
            PgpKeyPgpKeyTreeItem pgpKeyPgpKeyTreeItem = pgpKeyTreeItem.getThisOrParentPgpKeyTreeItemOfType(PgpKeyPgpKeyTreeItem.class);
            AssertUtil.assertNotNull((Object)((Object)pgpKeyPgpKeyTreeItem), (String)"pgpKeyPgpKeyTreeItem");
            PgpKey pgpKey = pgpKeyPgpKeyTreeItem.getPgpKey();
            result.add(pgpKey);
        }
        return result;
    }

    private List<EmailWrapper> createEmailWrapperList() {
        ArrayList<EmailWrapper> result = new ArrayList<EmailWrapper>(this.user.getEmails().size());
        for (String email : this.user.getEmails()) {
            EmailWrapper emailWrapper = this.createEmailWrapper(email);
            result.add(emailWrapper);
        }
        result.add(this.createEmailWrapper(null));
        return result;
    }

    private EmailWrapper createEmailWrapper(String email) {
        EmailWrapper emailWrapper = new EmailWrapper(email);
        emailWrapper.valueProperty().addListener(this.emailWrapperInvalidationListener);
        return emailWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmailWrappers() {
        if (this.ignoreUpdateEmailsOrWrappers) {
            return;
        }
        this.ignoreUpdateEmailsOrWrappers = true;
        try {
            Iterator eIterator = this.user.getEmails().iterator();
            ListIterator wIterator = this.emailWrappers.listIterator();
            while (eIterator.hasNext()) {
                EmailWrapper wrapper;
                String email = (String)eIterator.next();
                EmailWrapper emailWrapper = wrapper = wIterator.hasNext() ? (EmailWrapper)wIterator.next() : null;
                if (wrapper == null) {
                    wrapper = this.createEmailWrapper(email);
                    wIterator.add(wrapper);
                    continue;
                }
                if (Util.equal((Object)email, (Object)wrapper.getValue())) continue;
                wrapper.setValue(email);
            }
            if (wIterator.hasNext()) {
                while (wIterator.hasNext()) {
                    wIterator.next();
                    if (!wIterator.hasNext()) continue;
                    wIterator.remove();
                }
            } else {
                this.emailWrappers.add((Object)this.createEmailWrapper(null));
            }
        }
        finally {
            this.ignoreUpdateEmailsOrWrappers = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmails() {
        if (this.ignoreUpdateEmailsOrWrappers) {
            return;
        }
        this.ignoreUpdateEmailsOrWrappers = true;
        try {
            List emails = this.user.getEmails();
            ListIterator wIterator = this.emailWrappers.listIterator();
            int emailsIndex = -1;
            while (wIterator.hasNext()) {
                EmailWrapper wrapper = (EmailWrapper)wIterator.next();
                if (StringUtil.isEmpty((String)wrapper.getValue())) continue;
                if (++emailsIndex >= emails.size()) {
                    emails.add(wrapper.getValue());
                    continue;
                }
                String email = (String)emails.get(emailsIndex);
                if (Util.equal((Object)email, (Object)wrapper.getValue())) continue;
                emails.set(emailsIndex, wrapper.getValue());
            }
            int removeCount = emails.size() - emailsIndex - 1;
            for (int i = 0; i < removeCount; ++i) {
                emails.remove(emails.size() - 1);
            }
            if (this.emailWrappers.isEmpty() || !StringUtil.isEmpty((String)((EmailWrapper)this.emailWrappers.get(this.emailWrappers.size() - 1)).getValue())) {
                this.emailWrappers.add((Object)this.createEmailWrapper(null));
            }
            while (this.emailWrappers.size() >= 2 && StringUtil.isEmpty((String)((EmailWrapper)this.emailWrappers.get(this.emailWrappers.size() - 1)).getValue()) && StringUtil.isEmpty((String)((EmailWrapper)this.emailWrappers.get(this.emailWrappers.size() - 2)).getValue())) {
                this.emailWrappers.remove(this.emailWrappers.size() - 1);
            }
        }
        finally {
            this.ignoreUpdateEmailsOrWrappers = false;
        }
    }

    protected Pgp getPgp() {
        return PgpLs.getPgpOrFail();
    }

    @FXML
    private void createPgpKeyButtonClicked(ActionEvent event) {
        Window owner = this.getScene().getWindow();
        CreatePgpKeyParam createPgpKeyParam = this.createCreatePgpKeyParam();
        CreatePgpKeyWizard wizard = new CreatePgpKeyWizard(createPgpKeyParam){

            @Override
            protected void finish(ProgressMonitor monitor) throws Exception {
            }
        };
        WizardDialog dialog = new WizardDialog(owner, wizard);
        dialog.showAndWait();
        if (wizard.getState() != WizardState.FINISHED) {
            return;
        }
        final PgpPrivateKeyPassphraseStore pgpPrivateKeyPassphraseStore = PgpPrivateKeyPassphraseManagerLs.getPgpPrivateKeyPassphraseStore();
        final CreatePgpKeyParam portableCreatePgpKeyParam = createPgpKeyParam.toPortable();
        final CreatingPgpKeyDialog dialog2 = new CreatingPgpKeyDialog(owner, portableCreatePgpKeyParam);
        Thread createPgpKeyThread = new Thread("createPgpKeyThread"){

            @Override
            public void run() {
                Pgp pgp = UserPane.this.getPgp();
                PgpKey pgpKey = pgp.createPgpKey(portableCreatePgpKeyParam);
                UserPane.this.user.getPgpKeyIds().add(pgpKey.getPgpKeyId());
                pgpPrivateKeyPassphraseStore.putPassphrase(pgpKey.getPgpKeyId(), portableCreatePgpKeyParam.getPassphrase());
                pgp.setOwnerTrust(pgpKey, PgpOwnerTrust.ULTIMATE);
                pgp.updateTrustDb();
                Platform.runLater(() -> dialog2.close());
            }
        };
        dialog2.show();
        createPgpKeyThread.start();
    }

    private CreatePgpKeyParam createCreatePgpKeyParam() {
        CreatePgpKeyParam createPgpKeyParam = new CreatePgpKeyParam();
        createPgpKeyParam.setValiditySeconds(TimeUnit.YEAR.getSeconds() * 10L);
        String name = this.getName();
        HashSet<String> emails = new HashSet<String>();
        for (EmailWrapper emailWrapper : this.emailWrappers) {
            String email = StringUtil.trim((String)emailWrapper.getValue());
            if (StringUtil.isEmpty((String)email) || !emails.add(email)) continue;
            createPgpKeyParam.getUserIds().add((Object)new FxPgpUserId(name, email));
        }
        if (createPgpKeyParam.getUserIds().isEmpty()) {
            createPgpKeyParam.getUserIds().add((Object)new FxPgpUserId(name, null));
        }
        return createPgpKeyParam;
    }

    private String getName() {
        String firstName = StringUtil.trim((String)this.firstNameTextField.getText());
        String lastName = StringUtil.trim((String)this.lastNameTextField.getText());
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty((String)firstName)) {
            sb.append(firstName);
        }
        if (!StringUtil.isEmpty((String)lastName)) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(lastName);
        }
        return sb.toString();
    }

    @FXML
    private void exportPgpKeyButtonClicked(ActionEvent event) {
        String initialFileName;
        Set selectedPgpKeys = this.getSelectedPgpKeys();
        if (selectedPgpKeys.isEmpty()) {
            selectedPgpKeys = this.user.getValidPgpKeys();
        }
        if (selectedPgpKeys.size() == 1) {
            PgpKey pgpKey = (PgpKey)selectedPgpKeys.iterator().next();
            initialFileName = pgpKey.getPgpKeyId().toString() + "_" + this.user.getFirstName() + "_" + this.user.getLastName() + ".gpg";
        } else {
            initialFileName = this.user.getFirstName() + "_" + this.user.getLastName() + ".gpg";
        }
        co.codewizards.cloudstore.core.oio.File file = this.showSaveFileDialog("Choose file to export PGP key(s) into", initialFileName);
        if (file == null) {
            return;
        }
        boolean[] selectionContainsKeyWithPrivateKey = new boolean[]{false};
        for (PgpKey pgpKey : selectedPgpKeys) {
            selectionContainsKeyWithPrivateKey[0] = selectionContainsKeyWithPrivateKey[0] | pgpKey.isSecretKeyAvailable();
        }
        boolean exportPublicKeysWithPrivateKeys = false;
        if (selectionContainsKeyWithPrivateKey[0]) {
            // empty if block
        }
        try (IOutputStream out = FileLs.createOutputStream((co.codewizards.cloudstore.core.oio.File)file);){
            if (exportPublicKeysWithPrivateKeys) {
                this.getPgp().exportPublicKeysWithSecretKeys(selectedPgpKeys, out);
            } else {
                this.getPgp().exportPublicKeys(selectedPgpKeys, out);
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    private co.codewizards.cloudstore.core.oio.File showSaveFileDialog(String title, String initialFileName) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(title);
        fileChooser.setInitialFileName(initialFileName);
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        return file == null ? null : OioFileFactory.createFile((File)file).getAbsoluteFile();
    }

    private UserRegistry getUserRegistry() {
        return UserRegistryLs.getUserRegistry();
    }

    @FXML
    private void signPgpKeyButtonClicked(ActionEvent event) {
        PgpKey pgpKey = this.getSelectedPgpKeys().iterator().next();
        CertifyPgpKeyData certifyPgpKeyData = new CertifyPgpKeyData();
        certifyPgpKeyData.setPgpKey(pgpKey);
        CertifyPgpKeyWizard wizard = new CertifyPgpKeyWizard(certifyPgpKeyData);
        new WizardDialog(this.getScene().getWindow(), wizard).show();
    }

    @FXML
    private void ownerTrustButtonClicked(ActionEvent event) {
        Set<PgpKey> pgpKeys = this.getSelectedPgpKeys();
        AssignOwnerTrustData assignOwnerTrustData = new AssignOwnerTrustData();
        assignOwnerTrustData.setUser(this.user);
        assignOwnerTrustData.getPgpKeys().addAll(pgpKeys);
        AssignOwnerTrustWizard wizard = new AssignOwnerTrustWizard(assignOwnerTrustData);
        new WizardDialog(this.getScene().getWindow(), wizard).show();
    }

    @FXML
    private void deletePgpKeyButtonClicked(ActionEvent event) {
    }

    @FXML
    private void assignPgpKeyToThisUserButtonClicked(ActionEvent event) {
        SelectPgpKeyDialog dialog = new SelectPgpKeyDialog(this.getScene().getWindow(), new ArrayList<PgpKey>(this.getPgp().getMasterKeys()), null, SelectionMode.MULTIPLE, "Please select one or more PGP keys you want to 'pull' here.");
        dialog.showAndWait();
        List<PgpKey> selectedPgpKeys = dialog.getSelectedPgpKeys();
        if (selectedPgpKeys == null || selectedPgpKeys.isEmpty()) {
            return;
        }
        HashSet<PgpKeyId> selectedPgpKeyIds = new HashSet<PgpKeyId>(selectedPgpKeys.size());
        for (PgpKey pgpKey : selectedPgpKeys) {
            selectedPgpKeyIds.add(pgpKey.getPgpKeyId());
        }
        for (User user : this.getUserRegistry().getUsersByPgpKeyIds(selectedPgpKeyIds)) {
            user.getPgpKeyIds().removeAll(selectedPgpKeyIds);
        }
        this.user.getPgpKeyIds().addAll(selectedPgpKeyIds);
    }

    @FXML
    private void assignPgpKeyToOtherUserButtonClicked(ActionEvent event) {
        SelectUserDialog dialog = new SelectUserDialog(this.getScene().getWindow(), new ArrayList<User>(this.getUserRegistry().getUsers()), null, SelectionMode.SINGLE, "Please select the user to whom you want to 'push' the selected PGP key(s).");
        dialog.showAndWait();
        List<User> selectedUsers = dialog.getSelectedUsers();
        if (selectedUsers == null || selectedUsers.isEmpty()) {
            return;
        }
        User targetUser = selectedUsers.get(0);
        Set<PgpKey> selectedPgpKeys = this.getSelectedPgpKeys();
        for (PgpKey pgpKey : selectedPgpKeys) {
            this.user.getPgpKeyIds().remove(pgpKey.getPgpKeyId());
            targetUser.getPgpKeyIds().add(pgpKey.getPgpKeyId());
        }
    }

    @FXML
    private void closeButtonClicked(ActionEvent event) {
        this.editUserManager.endEditing(Collections.singleton(this.user));
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

