/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.welcome.identity;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.scene.Parent;
import org.subshare.gui.backup.imp.source.ImportBackupSourceWizardPage;
import org.subshare.gui.pgp.createkey.passphrase.PassphraseWizardPage;
import org.subshare.gui.welcome.IdentityData;
import org.subshare.gui.welcome.identity.IdentityPane;
import org.subshare.gui.wizard.WizardPage;

public class IdentityWizardPage
extends WizardPage {
    private final IdentityData identityData;
    private IdentityPane identityPane;
    private final InvalidationListener _updateCompleteInvalidationListener = observable -> this.updateComplete();
    private WeakInvalidationListener updateCompleteInvalidationListener = new WeakInvalidationListener(this._updateCompleteInvalidationListener);
    private final ImportBackupSourceWizardPage importBackupSourceWizardPage;
    private final PassphraseWizardPage passphraseWizardPage;

    public IdentityWizardPage(IdentityData identityData) {
        super("Identity");
        this.identityData = (IdentityData)AssertUtil.assertNotNull((Object)identityData, (String)"identityData");
        this.importBackupSourceWizardPage = new ImportBackupSourceWizardPage(identityData.getImportBackupData());
        this.passphraseWizardPage = new PassphraseWizardPage(identityData.getCreatePgpKeyParam());
        identityData.importBackupProperty().addListener(observable -> this.updateNextPage());
        this.updateNextPage();
    }

    protected void updateNextPage() {
        if (this.identityData.importBackupProperty().get()) {
            this.setNextPage(this.importBackupSourceWizardPage);
        } else {
            this.setNextPage(this.passphraseWizardPage);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.identityData.getPgpUserId().nameProperty().addListener((InvalidationListener)this.updateCompleteInvalidationListener);
        this.identityData.importBackupProperty().addListener((InvalidationListener)this.updateCompleteInvalidationListener);
        this.updateComplete();
        this.importBackupSourceWizardPage.setWizard(this.getWizard());
        this.passphraseWizardPage.setWizard(this.getWizard());
    }

    @Override
    protected Parent createContent() {
        this.identityPane = new IdentityPane(this.identityData);
        return this.identityPane;
    }

    private void updateComplete() {
        String name = (String)this.identityData.getPgpUserId().nameProperty().get();
        boolean importBackup = this.identityData.importBackupProperty().get();
        this.setComplete(importBackup || !StringUtil.isEmpty((String)name));
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.identityPane != null) {
            this.identityPane.firstNameTextField.requestFocus();
        }
    }
}

