/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.subshare.core.LocalRepoStorageFactory;

public class LocalRepoStorageFactoryRegistry {
    private List<LocalRepoStorageFactory> localRepoStorageFactories;

    protected LocalRepoStorageFactoryRegistry() {
    }

    public static LocalRepoStorageFactoryRegistry getInstance() {
        return Holder.instance;
    }

    public synchronized List<LocalRepoStorageFactory> getLocalRepoStorageFactories() {
        List<LocalRepoStorageFactory> localRepoStorageFactories = this.localRepoStorageFactories;
        if (localRepoStorageFactories == null) {
            localRepoStorageFactories = LocalRepoStorageFactoryRegistry.loadLocalRepoStorageFactoriesViaServiceLoader();
            LocalRepoStorageFactoryRegistry.sortLocalRepoStorageFactories(localRepoStorageFactories);
            this.localRepoStorageFactories = localRepoStorageFactories = Collections.unmodifiableList(localRepoStorageFactories);
        }
        return localRepoStorageFactories;
    }

    private static List<LocalRepoStorageFactory> loadLocalRepoStorageFactoriesViaServiceLoader() {
        ArrayList<LocalRepoStorageFactory> localRepoStorageFactories = new ArrayList<LocalRepoStorageFactory>();
        ServiceLoader<LocalRepoStorageFactory> sl = ServiceLoader.load(LocalRepoStorageFactory.class);
        Iterator<LocalRepoStorageFactory> it = sl.iterator();
        while (it.hasNext()) {
            localRepoStorageFactories.add(it.next());
        }
        localRepoStorageFactories.trimToSize();
        return localRepoStorageFactories;
    }

    protected static int _compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static void sortLocalRepoStorageFactories(List<LocalRepoStorageFactory> localRepoStorageFactories) {
        Collections.sort(localRepoStorageFactories, new Comparator<LocalRepoStorageFactory>(){

            @Override
            public int compare(LocalRepoStorageFactory o1, LocalRepoStorageFactory o2) {
                int result = -1 * LocalRepoStorageFactoryRegistry._compare(o1.getPriority(), o2.getPriority());
                if (result != 0) {
                    return result;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
    }

    public LocalRepoStorageFactory getLocalRepoStorageFactoryOrFail() {
        List<LocalRepoStorageFactory> localRepoStorageFactories = this.getLocalRepoStorageFactories();
        if (localRepoStorageFactories.isEmpty()) {
            throw new IllegalStateException("There is no LocalRepoStorageFactory registered!");
        }
        return localRepoStorageFactories.get(0);
    }

    private static class Holder {
        static LocalRepoStorageFactoryRegistry instance = new LocalRepoStorageFactoryRegistry();

        private Holder() {
        }
    }
}

