/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.dto;

import co.codewizards.cloudstore.core.Uid;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.subshare.core.dto.SignatureDto;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.Signature;

@XmlRootElement
public class CryptoKeyDeactivationDto
implements Signable {
    public static final String SIGNED_DATA_TYPE = "CryptoKeyDeactivation";
    private Uid cryptoKeyId;
    @XmlElement
    private SignatureDto signatureDto;

    public Uid getCryptoKeyId() {
        return this.cryptoKeyId;
    }

    public void setCryptoKeyId(Uid cryptoKeyId) {
        this.cryptoKeyId = cryptoKeyId;
    }

    @Override
    public String getSignedDataType() {
        return SIGNED_DATA_TYPE;
    }

    @Override
    public int getSignedDataVersion() {
        return 0;
    }

    @Override
    public InputStream getSignedData(int signedDataVersion) {
        try {
            return InputStreamSource.Helper.createInputStreamSource(this.cryptoKeyId).createInputStream();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    @XmlTransient
    public Signature getSignature() {
        return this.signatureDto;
    }

    @Override
    public void setSignature(Signature signature) {
        this.signatureDto = SignatureDto.copyIfNeeded(signature);
    }

    public String toString() {
        return "CryptoKeyDeactivationDto[cryptoKeyId=" + this.cryptoKeyId + "]";
    }
}

