/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.sync;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.CollectionUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.sync.Messages;
import org.subshare.core.pgp.transport.PgpTransport;
import org.subshare.core.pgp.transport.PgpTransportFactory;
import org.subshare.core.pgp.transport.PgpTransportFactoryRegistry;
import org.subshare.core.pgp.transport.PgpTransportFactoryRegistryImpl;
import org.subshare.core.pgp.transport.local.LocalPgpTransportFactory;
import org.subshare.core.server.Server;
import org.subshare.core.sync.Sync;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistryImpl;

public class PgpSync
implements Sync {
    private final Uid serverId;
    private final Server server;
    private final URL serverUrl;
    private PgpTransport localPgpTransport;
    private PgpTransport serverPgpTransport;
    private File pgpSyncPropertiesFile;
    private Properties pgpSyncProperties;
    private final String lastSyncLocalLocalRevisionPropertyKey;
    private final String lastSyncServerLocalRevisionPropertyKey;
    private static volatile Set<PgpKeyId> downSyncPgpKeyIds = Collections.emptySet();

    public static Set<PgpKeyId> getDownSyncPgpKeyIds() {
        return downSyncPgpKeyIds;
    }

    public static void setDownSyncPgpKeyIds(Set<PgpKeyId> downSyncPgpKeyIds) {
        PgpSync.downSyncPgpKeyIds = downSyncPgpKeyIds == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<PgpKeyId>(downSyncPgpKeyIds));
    }

    public PgpSync(Server server) {
        this.server = (Server)AssertUtil.assertNotNull((Object)server, (String)"server");
        this.serverId = (Uid)AssertUtil.assertNotNull((Object)this.server.getServerId(), (String)"server.serverId");
        this.serverUrl = (URL)AssertUtil.assertNotNull((Object)this.server.getUrl(), (String)"server.url");
        this.lastSyncLocalLocalRevisionPropertyKey = String.format("lastSync[serverId=%s].local.localRevision", this.serverId);
        this.lastSyncServerLocalRevisionPropertyKey = String.format("lastSync[serverId=%s].server.localRevision", this.serverId);
    }

    @Override
    public String getName() {
        return Messages.getString("PgpSync.name");
    }

    @Override
    public void sync() {
        long localLocalRevision = this.getLocalPgpTransport().getLocalRevision();
        long lastSyncLocalLocalRevision = PropertiesUtil.getPropertyValueAsLong((Properties)this.getPgpSyncProperties(), (String)this.lastSyncLocalLocalRevisionPropertyKey, (long)-1L);
        boolean needWrite = false;
        if (lastSyncLocalLocalRevision != localLocalRevision) {
            this.sync(this.getLocalPgpTransport(), lastSyncLocalLocalRevision, this.getServerPgpTransport());
            this.getPgpSyncProperties().setProperty(this.lastSyncLocalLocalRevisionPropertyKey, Long.toString(localLocalRevision));
            needWrite = true;
        }
        long serverLocalRevision = this.getServerPgpTransport().getLocalRevision();
        long lastSyncServerLocalRevision = PropertiesUtil.getPropertyValueAsLong((Properties)this.getPgpSyncProperties(), (String)this.lastSyncServerLocalRevisionPropertyKey, (long)-1L);
        if (lastSyncServerLocalRevision != serverLocalRevision || this.isKeysMissing()) {
            this.sync(this.getServerPgpTransport(), lastSyncServerLocalRevision, this.getLocalPgpTransport());
            this.getPgpSyncProperties().setProperty(this.lastSyncServerLocalRevisionPropertyKey, Long.toString(localLocalRevision));
            needWrite = true;
        }
        if (needWrite) {
            this.writePgpSyncProperties();
        }
    }

    private boolean isKeysMissing() {
        if (!PgpSync.getDownSyncPgpKeyIds().isEmpty()) {
            return true;
        }
        Set<PgpKeyId> knownMasterKeyIds = this.getLocalPgpTransport().getMasterKeyIds();
        HashSet<PgpKeyId> missingMasterKeyIds = new HashSet<PgpKeyId>();
        for (User user : UserRegistryImpl.getInstance().getUsers()) {
            for (PgpKeyId pgpKeyId : user.getPgpKeyIds()) {
                if (knownMasterKeyIds.contains(pgpKeyId)) continue;
                missingMasterKeyIds.add(pgpKeyId);
            }
        }
        return !missingMasterKeyIds.isEmpty();
    }

    public URL getServerUrl() {
        return this.serverUrl;
    }

    private void sync(PgpTransport from, long fromLastSyncLocalRevision, PgpTransport to) {
        Set<PgpKeyId> downSyncPgpKeyIds = PgpSync.getDownSyncPgpKeyIds();
        Set<PgpKeyId> knownMasterKeyIds = this.getLocalPgpTransport().getMasterKeyIds();
        for (Set masterKeyIds : CollectionUtil.splitSet(knownMasterKeyIds, (int)1000)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            from.exportPublicKeys(masterKeyIds, fromLastSyncLocalRevision, (IOutputStream)out);
            to.importKeys((IInputStream)new ByteArrayInputStream(out.toByteArray()));
        }
        if (to == this.getLocalPgpTransport()) {
            HashSet<PgpKeyId> missingMasterKeyIds = new HashSet<PgpKeyId>();
            for (User user : UserRegistryImpl.getInstance().getUsers()) {
                for (PgpKeyId pgpKeyId : user.getPgpKeyIds()) {
                    if (knownMasterKeyIds.contains(pgpKeyId)) continue;
                    missingMasterKeyIds.add(pgpKeyId);
                }
            }
            missingMasterKeyIds.addAll(downSyncPgpKeyIds);
            if (!missingMasterKeyIds.isEmpty()) {
                for (Set masterKeyIds : CollectionUtil.splitSet(missingMasterKeyIds, (int)1000)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    from.exportPublicKeys(masterKeyIds, -1L, (IOutputStream)out);
                    to.importKeys((IInputStream)new ByteArrayInputStream(out.toByteArray()));
                }
            }
        }
    }

    private PgpTransport getLocalPgpTransport() {
        if (this.localPgpTransport == null) {
            PgpTransportFactoryRegistry pgpTransportFactoryRegistry = PgpTransportFactoryRegistryImpl.getInstance();
            PgpTransportFactory pgpTransportFactory = pgpTransportFactoryRegistry.getPgpTransportFactoryOrFail(LocalPgpTransportFactory.LOCAL_URL);
            this.localPgpTransport = pgpTransportFactory.createPgpTransport(LocalPgpTransportFactory.LOCAL_URL);
        }
        return this.localPgpTransport;
    }

    public PgpTransport getServerPgpTransport() {
        if (this.serverPgpTransport == null) {
            PgpTransportFactoryRegistry pgpTransportFactoryRegistry = PgpTransportFactoryRegistryImpl.getInstance();
            PgpTransportFactory pgpTransportFactory = pgpTransportFactoryRegistry.getPgpTransportFactoryOrFail(this.serverUrl);
            this.serverPgpTransport = pgpTransportFactory.createPgpTransport(this.serverUrl);
        }
        return this.serverPgpTransport;
    }

    private File getPgpSyncPropertiesFile() {
        if (this.pgpSyncPropertiesFile == null) {
            this.pgpSyncPropertiesFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"pgpSync.properties"});
        }
        return this.pgpSyncPropertiesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getPgpSyncProperties() {
        block30: {
            if (this.pgpSyncProperties == null) {
                try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getPgpSyncPropertiesFile(), 30000L);){
                    Lock lock = lockFile.getLock();
                    lock.lock();
                    try {
                        if (this.pgpSyncProperties != null) break block30;
                        Properties p = new Properties();
                        try (InputStream in = StreamUtil.castStream((IInputStream)lockFile.createInputStream());){
                            p.load(in);
                        }
                        this.pgpSyncProperties = p;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (IOException x) {
                    throw new RuntimeException(x);
                }
            }
        }
        return this.pgpSyncProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePgpSyncProperties() {
        Properties pgpSyncProperties;
        Properties properties = pgpSyncProperties = this.getPgpSyncProperties();
        synchronized (properties) {
            try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getPgpSyncPropertiesFile(), 30000L);
                 OutputStream out = StreamUtil.castStream((IOutputStream)lockFile.createOutputStream());){
                pgpSyncProperties.store(out, null);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    @Override
    public void close() {
        PgpTransport lpt = this.localPgpTransport;
        this.localPgpTransport = null;
        if (lpt != null) {
            lpt.close();
        }
        PgpTransport spt = this.serverPgpTransport;
        this.serverPgpTransport = null;
        if (spt != null) {
            spt.close();
        }
    }
}

