/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.core.invoke.InvocationType;
import java.io.Serializable;
import java.util.Arrays;

public class MethodInvocationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final Object object;
    private final String methodName;
    private final String[] argumentTypeNames;
    private final Object[] arguments;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    protected MethodInvocationRequest(String className, Object object, String methodName, String[] argumentTypeNames, Object[] arguments) {
        this.className = className;
        this.object = object;
        this.methodName = methodName;
        this.argumentTypeNames = argumentTypeNames;
        this.arguments = arguments;
    }

    public static MethodInvocationRequest forConstructorInvocation(String className, String[] argumentTypeNames, Object ... arguments) {
        return new MethodInvocationRequest((String)AssertUtil.assertNotNull((Object)className, (String)"className"), null, null, argumentTypeNames, arguments);
    }

    public static MethodInvocationRequest forStaticInvocation(String className, String methodName, String[] argumentTypeNames, Object ... arguments) {
        return new MethodInvocationRequest((String)AssertUtil.assertNotNull((Object)className, (String)"className"), null, (String)AssertUtil.assertNotNull((Object)methodName, (String)"methodName"), argumentTypeNames, arguments);
    }

    public static MethodInvocationRequest forObjectInvocation(Object object, String methodName, String[] argumentTypeNames, Object ... arguments) {
        if (argumentTypeNames != null) {
            int argumentsLength;
            if (argumentTypeNames.length > 0 && arguments == null) {
                throw new IllegalArgumentException("argumentTypeNames != null && argumentTypeNames.length > 0 && arguments == null");
            }
            int n = argumentsLength = arguments == null ? 0 : arguments.length;
            if (argumentTypeNames.length != argumentsLength) {
                throw new IllegalArgumentException(String.format("argumentTypeNames.length != arguments.length :: %d != %d", argumentTypeNames.length, argumentsLength));
            }
        }
        return new MethodInvocationRequest(null, AssertUtil.assertNotNull((Object)object, (String)"object"), (String)AssertUtil.assertNotNull((Object)methodName, (String)"methodName"), argumentTypeNames, arguments);
    }

    public String getClassName() {
        return this.className;
    }

    public Object getObject() {
        return this.object;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getArgumentTypeNames() {
        return this.argumentTypeNames;
    }

    public Object[] getArguments() {
        return this.arguments == null ? EMPTY_OBJECT_ARRAY : this.arguments;
    }

    public InvocationType getInvocationType() {
        if (this.className != null) {
            if (this.methodName == null) {
                return InvocationType.CONSTRUCTOR;
            }
            return InvocationType.STATIC;
        }
        if (this.object != null) {
            return InvocationType.OBJECT;
        }
        throw new IllegalStateException("Cannot determine InvocationType!");
    }

    public String toString() {
        InvocationType invocationType = this.getInvocationType();
        String argumentsString = this.arguments == null ? "[]" : Arrays.toString(this.arguments);
        switch (invocationType) {
            case CONSTRUCTOR: {
                return String.format("%s[%s, %s, %s]", new Object[]{this.getClass().getSimpleName(), invocationType, this.className, argumentsString});
            }
            case STATIC: {
                return String.format("%s[%s, %s, %s, %s]", new Object[]{this.getClass().getSimpleName(), invocationType, this.className, this.methodName, argumentsString});
            }
            case OBJECT: {
                return String.format("%s[%s, %s, %s, %s, %s]", new Object[]{this.getClass().getSimpleName(), invocationType, this.object.getClass().getName(), this.object, this.methodName, argumentsString});
            }
        }
        throw new IllegalStateException("Unexpected InvocationType!");
    }
}

