/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.openpgp.wot.CanonicalString;
import org.bouncycastle.openpgp.wot.IoRandomAccessFile;
import org.bouncycastle.openpgp.wot.PgpFile;
import org.bouncycastle.openpgp.wot.PgpRandomAccessFile;
import org.bouncycastle.openpgp.wot.internal.Util;

public class IoFile
implements PgpFile {
    private final File file;
    private final String pgpId;

    public IoFile(File file) throws IOException {
        this.file = Util.assertNotNull(file, "file").getCanonicalFile();
        this.pgpId = CanonicalString.canonicalize(file.getParentFile().getPath());
    }

    @Override
    public String getId() {
        return this.file.getPath();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getPgpId() {
        return this.pgpId;
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public InputStream createInputStream() throws IOException {
        if (this.file.isFile()) {
            return new FileInputStream(this.file);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public OutputStream createOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public PgpRandomAccessFile createRandomAccessFile() throws IOException {
        return new IoRandomAccessFile(this);
    }
}

