/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.dto.RepositoryDto;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactory;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactoryRegistry;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import java.net.URL;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="_requestRepoConnection/{repositoryName}")
public class RequestRepoConnectionService {
    private static final Logger logger = LoggerFactory.getLogger(RequestRepoConnectionService.class);
    @PathParam(value="repositoryName")
    private String repositoryName;

    public RequestRepoConnectionService() {
        logger.debug("<init>: created new instance");
    }

    @POST
    @Consumes(value={"application/xml"})
    public void requestConnection(RepositoryDto clientRepositoryDto) {
        this.requestConnection("", clientRepositoryDto);
    }

    @POST
    @Path(value="{pathPrefix:.*}")
    @Consumes(value={"application/xml"})
    public void requestConnection(@PathParam(value="pathPrefix") String pathPrefix, RepositoryDto clientRepositoryDto) {
        AssertUtil.assertNotNull((Object)pathPrefix, (String)"pathPrefix");
        AssertUtil.assertNotNull((Object)clientRepositoryDto, (String)"repositoryDto");
        URL localRootURL = LocalRepoRegistryImpl.getInstance().getLocalRootURLForRepositoryNameOrFail(this.repositoryName);
        localRootURL = UrlUtil.appendNonEncodedPath((URL)localRootURL, (String)pathPrefix);
        RepoTransportFactory repoTransportFactory = RepoTransportFactoryRegistry.getInstance().getRepoTransportFactory(localRootURL);
        try (RepoTransport repoTransport = repoTransportFactory.createRepoTransport(localRootURL, clientRepositoryDto.getRepositoryId());){
            this.requestConnection(repoTransport, pathPrefix, clientRepositoryDto);
        }
    }

    protected void requestConnection(RepoTransport repoTransport, String pathPrefix, RepositoryDto clientRepositoryDto) {
        repoTransport.requestRepoConnection(clientRepositoryDto.getPublicKey());
    }
}

