/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Repository;
import java.net.URL;
import java.util.UUID;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.SUPERCLASS_TABLE)
@Discriminator(strategy=DiscriminatorStrategy.VALUE_MAP, value="RemoteRepository")
@Index(name="RemoteRepository_remoteRootSha1", members={"remoteRootSha1"})
@Queries(value={@Query(name="getRemoteRepository_repositoryId", value="SELECT UNIQUE WHERE this.repositoryId == :repositoryId"), @Query(name="getRemoteRepository_remoteRootSha1", value="SELECT UNIQUE WHERE this.remoteRootSha1 == :remoteRootSha1")})
public class RemoteRepository
extends Repository
implements AutoTrackLocalRevision,
Persistable {
    private static final Logger logger = LoggerFactory.getLogger(RemoteRepository.class);
    @Column(jdbcType="CLOB")
    private URL remoteRoot;
    private String remoteRootSha1;
    private long localRevision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private String localPathPrefix;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public RemoteRepository() {
    }

    public RemoteRepository(UUID repositoryId) {
        super(repositoryId);
    }

    public URL getRemoteRoot() {
        return RemoteRepository.dnGetremoteRoot(this);
    }

    public void setRemoteRoot(URL remoteRoot) {
        if (Util.equal((Object)this.getRemoteRoot(), (Object)remoteRoot)) {
            return;
        }
        remoteRoot = UrlUtil.canonicalizeURL((URL)remoteRoot);
        RemoteRepository.dnSetremoteRoot(this, remoteRoot);
        RemoteRepository.dnSetremoteRootSha1(this, remoteRoot == null ? null : HashUtil.sha1((String)remoteRoot.toExternalForm()));
    }

    public String getRemoteRootSha1() {
        return RemoteRepository.dnGetremoteRootSha1(this);
    }

    @Override
    public long getLocalRevision() {
        return RemoteRepository.dnGetlocalRevision(this);
    }

    @Override
    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)RemoteRepository.dnGetlocalRevision(this), (long)localRevision)) {
            if (logger.isDebugEnabled()) {
                logger.debug("setLocalRevision: repositoryId={} old={} new={}", new Object[]{this.getRepositoryId(), RemoteRepository.dnGetlocalRevision(this), localRevision});
            }
            RemoteRepository.dnSetlocalRevision(this, localRevision);
        }
    }

    public String getLocalPathPrefix() {
        return RemoteRepository.dnGetlocalPathPrefix(this);
    }

    public void setLocalPathPrefix(String localPathPrefix) {
        AssertUtil.assertNotNull((Object)localPathPrefix, (String)"localPathPrefix");
        if (!localPathPrefix.isEmpty() && !localPathPrefix.startsWith("/")) {
            throw new IllegalArgumentException("localPathPrefix must start with '/' but does not: " + localPathPrefix);
        }
        if (!Util.equal((Object)RemoteRepository.dnGetlocalPathPrefix(this), (Object)localPathPrefix)) {
            RemoteRepository.dnSetlocalPathPrefix(this, localPathPrefix);
        }
    }

    static {
        dnFieldNames = RemoteRepository.__dnFieldNamesInit();
        dnFieldTypes = RemoteRepository.__dnFieldTypesInit();
        dnFieldFlags = RemoteRepository.__dnFieldFlagsInit();
        dnInheritedFieldCount = RemoteRepository.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = RemoteRepository.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)RemoteRepository.___dn$loadClass("co.codewizards.cloudstore.local.persistence.RemoteRepository"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new RemoteRepository());
    }

    @Override
    public boolean dnIsDetached() {
        return false;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm) {
        RemoteRepository result = new RemoteRepository();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm, Object obj) {
        RemoteRepository result = new RemoteRepository();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    @Override
    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.localPathPrefix = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 2: {
                this.remoteRoot = (URL)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.remoteRootSha1 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    @Override
    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.localPathPrefix);
                break;
            }
            case 1: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.remoteRoot);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.remoteRootSha1);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(RemoteRepository obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.localPathPrefix = obj.localPathPrefix;
                break;
            }
            case 1: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 2: {
                this.remoteRoot = obj.remoteRoot;
                break;
            }
            case 3: {
                this.remoteRootSha1 = obj.remoteRootSha1;
                break;
            }
            default: {
                super.dnCopyField(obj, index);
            }
        }
    }

    @Override
    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof RemoteRepository)) {
            throw new IllegalArgumentException("object is not an object of type co.codewizards.cloudstore.local.persistence.RemoteRepository");
        }
        RemoteRepository other = (RemoteRepository)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"localPathPrefix", "localRevision", "remoteRoot", "remoteRootSha1"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{RemoteRepository.___dn$loadClass("java.lang.String"), Long.TYPE, RemoteRepository.___dn$loadClass("java.net.URL"), RemoteRepository.___dn$loadClass("java.lang.String")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Repository.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 4 + Repository.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return RemoteRepository.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Repository");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        RemoteRepository o = (RemoteRepository)super.clone();
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static String dnGetlocalPathPrefix(RemoteRepository objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.localPathPrefix);
        }
        return objPC.localPathPrefix;
    }

    private static void dnSetlocalPathPrefix(RemoteRepository objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.localPathPrefix, val);
        } else {
            objPC.localPathPrefix = val;
        }
    }

    private static long dnGetlocalRevision(RemoteRepository objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(RemoteRepository objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static URL dnGetremoteRoot(RemoteRepository objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (URL)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.remoteRoot);
        }
        return objPC.remoteRoot;
    }

    private static void dnSetremoteRoot(RemoteRepository objPC, URL val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.remoteRoot, (Object)val);
        } else {
            objPC.remoteRoot = val;
        }
    }

    private static String dnGetremoteRootSha1(RemoteRepository objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.remoteRootSha1);
        }
        return objPC.remoteRootSha1;
    }

    private static void dnSetremoteRootSha1(RemoteRepository objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.remoteRootSha1, val);
        } else {
            objPC.remoteRootSha1 = val;
        }
    }
}

