/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot;

import java.util.HashMap;
import java.util.Map;

public enum Validity {
    NONE(0),
    UNDEFINED(2),
    MARGINAL(4),
    FULL(5),
    ULTIMATE(6);

    private final int numericValue;
    private static volatile Map<Integer, Validity> numericValue2Validity;

    private Validity(int numericValue) {
        this.numericValue = numericValue;
    }

    public int getNumericValue() {
        return this.numericValue;
    }

    public static Validity fromNumericValue(int numericValue) {
        Validity validity = Validity.getNumericValue2Validity().get(numericValue);
        if (validity == null) {
            throw new IllegalArgumentException("numericValue unknown: " + numericValue);
        }
        return validity;
    }

    private static Map<Integer, Validity> getNumericValue2Validity() {
        if (numericValue2Validity == null) {
            HashMap<Integer, Validity> m = new HashMap<Integer, Validity>(Validity.values().length);
            for (Validity ownerTrust : Validity.values()) {
                m.put(ownerTrust.getNumericValue(), ownerTrust);
            }
            numericValue2Validity = m;
        }
        return numericValue2Validity;
    }
}

