/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.util;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import org.subshare.gui.util.ResourceBundleUtil;

public final class FxmlUtil {
    private FxmlUtil() {
    }

    private static FXMLLoader createFxmlLoader(Class<?> componentClass) {
        AssertUtil.assertNotNull(componentClass, (String)"componentClass");
        FXMLLoader fxmlLoader = new FXMLLoader(componentClass.getResource(componentClass.getSimpleName() + ".fxml"), ResourceBundleUtil.getMessages(componentClass));
        return fxmlLoader;
    }

    public static <T> void loadDynamicComponentFxml(Class<? super T> componentClass, T component) {
        AssertUtil.assertNotNull(componentClass, (String)"componentClass");
        AssertUtil.assertNotNull(component, (String)"component");
        FXMLLoader fxmlLoader = FxmlUtil.createFxmlLoader(componentClass);
        fxmlLoader.setRoot(component);
        fxmlLoader.setController(component);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

