/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpInputOverHTTP
extends HttpInput<ByteBuffer>
implements Callback {
    private static final Logger LOG = Log.getLogger(HttpInputOverHTTP.class);
    private final SharedBlockingCallback _readBlocker = new SharedBlockingCallback();
    private final HttpConnection _httpConnection;
    private ByteBuffer _content;

    public HttpInputOverHTTP(HttpConnection httpConnection) {
        this._httpConnection = httpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        Object object = this.lock();
        synchronized (object) {
            super.recycle();
            this._content = null;
        }
    }

    @Override
    protected void blockForContent() throws IOException {
        Object content;
        do {
            try (SharedBlockingCallback.Blocker blocker = this._readBlocker.acquire();){
                this._httpConnection.fillInterested((Callback)blocker);
                LOG.debug("{} block readable on {}", new Object[]{this, blocker});
                blocker.block();
            }
        } while ((content = this.getNextContent()) == null && !this.isFinished());
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    @Override
    protected ByteBuffer nextContent() throws IOException {
        if (BufferUtil.hasContent((ByteBuffer)this._content)) {
            return this._content;
        }
        this._content = null;
        ByteBuffer requestBuffer = this._httpConnection.getRequestBuffer();
        while (!this._httpConnection.getParser().isComplete()) {
            this._httpConnection.getParser().parseNext(requestBuffer == null ? BufferUtil.EMPTY_BUFFER : requestBuffer);
            if (BufferUtil.hasContent((ByteBuffer)this._content)) {
                return this._content;
            }
            if (BufferUtil.isEmpty((ByteBuffer)requestBuffer) && this._httpConnection.getEndPoint().isInputShutdown()) {
                this._httpConnection.getParser().atEOF();
                continue;
            }
            int filled = this._httpConnection.getEndPoint().fill(requestBuffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} filled {}", new Object[]{this, filled});
            }
            if (filled > 0) continue;
            if (filled < 0) {
                this._httpConnection.getParser().atEOF();
                continue;
            }
            return null;
        }
        return null;
    }

    @Override
    protected int remaining(ByteBuffer item) {
        return item.remaining();
    }

    @Override
    protected int get(ByteBuffer item, byte[] buffer, int offset, int length) {
        int l = Math.min(item.remaining(), length);
        item.get(buffer, offset, l);
        return l;
    }

    @Override
    protected void consume(ByteBuffer item, int length) {
        item.position(item.position() + length);
    }

    @Override
    public void content(ByteBuffer item) {
        if (BufferUtil.hasContent((ByteBuffer)this._content)) {
            throw new IllegalStateException();
        }
        this._content = item;
    }

    @Override
    protected void unready() {
        this._httpConnection.fillInterested(this);
    }

    public void succeeded() {
        this._httpConnection.getHttpChannel().getState().onReadPossible();
    }

    @Override
    public void failed(Throwable x) {
        super.failed(x);
        this._httpConnection.getHttpChannel().getState().onReadPossible();
    }
}

