/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.client.handler;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.client.handler.InverseServiceRequestHandler;
import co.codewizards.cloudstore.ls.core.dto.InverseServiceRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class InverseServiceRequestHandlerManager {
    private final Map<Class<?>, HandlerClass> requestType2HandlerClass = new HashMap();
    private final Map<Class<?>, Class<? extends InverseServiceRequestHandler>> resolvedRequestType2HandlerClassCache = new HashMap();

    public static InverseServiceRequestHandlerManager getInstance() {
        return Holder.instance;
    }

    protected InverseServiceRequestHandlerManager() {
    }

    public InverseServiceRequestHandler getInverseServiceRequestHandler(Class<?> requestClass) {
        AssertUtil.assertNotNull(requestClass, (String)"requestClass");
        Class<? extends InverseServiceRequestHandler> handlerClass = this.getInverseServiceRequestHandlerClass(requestClass);
        if (handlerClass == null) {
            return null;
        }
        return this.newInstance(handlerClass);
    }

    private synchronized Class<? extends InverseServiceRequestHandler> getInverseServiceRequestHandlerClass(Class<?> requestClass) {
        Class<? extends InverseServiceRequestHandler> result = this.resolvedRequestType2HandlerClassCache.get(requestClass);
        if (result == null) {
            SortedSet<HandlerClass> handlerClasses = this.getInverseServiceRequestHandlerClasses(requestClass);
            if (handlerClasses.isEmpty()) {
                return null;
            }
            result = ((HandlerClass)handlerClasses.iterator().next()).handlerClass;
        }
        return result;
    }

    private synchronized SortedSet<HandlerClass> getInverseServiceRequestHandlerClasses(Class<?> requestClass) {
        AssertUtil.assertNotNull(requestClass, (String)"requestClass");
        if (this.requestType2HandlerClass.isEmpty()) {
            for (InverseServiceRequestHandler handler : ServiceLoader.load(InverseServiceRequestHandler.class)) {
                this.requestType2HandlerClass.put(handler.getInverseServiceRequestType(), new HandlerClass(handler.getClass(), handler.getPriority()));
            }
        }
        TreeSet<HandlerClass> handlerClasses = new TreeSet<HandlerClass>();
        for (Class<?> c = requestClass; c != null && c != Object.class; c = c.getSuperclass()) {
            this.populateHandlerClasses(handlerClasses, c);
        }
        return handlerClasses;
    }

    private void populateHandlerClasses(Set<HandlerClass> handlerClasses, Class<?> requestClass) {
        HandlerClass handlerClass = this.requestType2HandlerClass.get(requestClass);
        if (handlerClass != null) {
            handlerClasses.add(handlerClass);
        }
        for (Class<?> iface : requestClass.getInterfaces()) {
            this.populateHandlerClasses(handlerClasses, iface);
        }
    }

    public InverseServiceRequestHandler getInverseServiceRequestHandlerOrFail(Class<?> requestClass) {
        InverseServiceRequestHandler handler = this.getInverseServiceRequestHandler(requestClass);
        if (handler == null) {
            throw new IllegalArgumentException("Could not find a handler for this requestClass: " + requestClass.getName());
        }
        return handler;
    }

    public InverseServiceRequestHandler getInverseServiceRequestHandlerOrFail(InverseServiceRequest request) {
        AssertUtil.assertNotNull((Object)request, (String)"request");
        return this.getInverseServiceRequestHandlerOrFail(request.getClass());
    }

    private InverseServiceRequestHandler newInstance(Class<? extends InverseServiceRequestHandler> handlerClass) {
        AssertUtil.assertNotNull(handlerClass, (String)"handlerClass");
        try {
            return handlerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class Holder {
        public static final InverseServiceRequestHandlerManager instance = new InverseServiceRequestHandlerManager();

        private Holder() {
        }
    }

    private static final class HandlerClass
    implements Comparable<HandlerClass> {
        public final Class<? extends InverseServiceRequestHandler> handlerClass;
        public final int priority;

        public HandlerClass(Class<? extends InverseServiceRequestHandler> handlerClass, int priority) {
            this.handlerClass = (Class)AssertUtil.assertNotNull(handlerClass, (String)"handlerClass");
            this.priority = priority;
        }

        @Override
        public int compareTo(HandlerClass o) {
            int result = -1 * Integer.compare(this.priority, o.priority);
            if (result != 0) {
                return result;
            }
            return this.handlerClass.getName().compareTo(o.handlerClass.getName());
        }
    }
}

