/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Indices;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Uniques(value={@Unique(name="CryptoRepoFile_cryptoRepoFileId", members={"cryptoRepoFileId"})})
@Indices(value={@Index(name="CryptoRepoFile_repoFile", members={"repoFile"}), @Index(name="CryptoRepoFile_parent", members={"parent"}), @Index(name="CryptoRepoFile_deleted", members={"deleted"}), @Index(name="CryptoRepoFile_localRevision", members={"localRevision"})})
@Queries(value={@Query(name="getChildCryptoRepoFiles_parent", value="SELECT WHERE this.parent == :parent"), @Query(name="getChildCryptoRepoFiles_parent_localName", value="SELECT WHERE this.parent == :parent && this.localName == :localName"), @Query(name="getCryptoRepoFile_repoFile", value="SELECT UNIQUE WHERE this.repoFile == :repoFile"), @Query(name="getCryptoRepoFilesWithoutRepoFileAndNotDeleted", value="SELECT WHERE this.repoFile == null && this.deleted == null"), @Query(name="getCryptoRepoFile_cryptoRepoFileId", value="SELECT UNIQUE WHERE this.cryptoRepoFileId == :cryptoRepoFileId"), @Query(name="getCryptoRepoFilesChangedAfter_localRevision_exclLastSyncFromRepositoryId", value="SELECT WHERE this.localRevision > :localRevision && (this.lastSyncFromRepositoryId == null || this.lastSyncFromRepositoryId != :lastSyncFromRepositoryId)")})
public class CryptoRepoFile
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String cryptoRepoFileId;
    private CryptoRepoFile parent;
    private RepoFile repoFile;
    private long localRevision;
    private String lastSyncFromRepositoryId;
    private CryptoKey cryptoKey;
    @Column(jdbcType="BLOB")
    private byte[] repoFileDtoData;
    private String localName;
    private boolean directory;
    private Date cryptoRepoFileCreated = new Date();
    private Date deleted;
    @Column(defaultValue="N")
    private boolean deletedByIgnoreRule;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public CryptoRepoFile() {
    }

    public CryptoRepoFile(Uid cryptoRepoFileId) {
        this.cryptoRepoFileId = cryptoRepoFileId == null ? null : cryptoRepoFileId.toString();
    }

    public Uid getCryptoRepoFileId() {
        if (CryptoRepoFile.dnGetcryptoRepoFileId(this) == null) {
            CryptoRepoFile.dnSetcryptoRepoFileId(this, new Uid().toString());
        }
        return new Uid(CryptoRepoFile.dnGetcryptoRepoFileId(this));
    }

    public CryptoRepoFile getParent() {
        return CryptoRepoFile.dnGetparent(this);
    }

    public void setParent(CryptoRepoFile parent) {
        if (!Util.equal((Object)((Object)CryptoRepoFile.dnGetparent(this)), (Object)((Object)parent))) {
            CryptoRepoFile.dnSetparent(this, parent);
        }
    }

    public String getLocalName() {
        return CryptoRepoFile.dnGetlocalName(this);
    }

    public void setLocalName(String localName) {
        if (!Util.equal((Object)CryptoRepoFile.dnGetlocalName(this), (Object)localName)) {
            CryptoRepoFile.dnSetlocalName(this, localName);
        }
    }

    public RepoFile getRepoFile() {
        return CryptoRepoFile.dnGetrepoFile(this);
    }

    public void setRepoFile(RepoFile repoFile) {
        if (!Util.equal((Object)CryptoRepoFile.dnGetrepoFile(this), (Object)repoFile)) {
            CryptoRepoFile.dnSetrepoFile(this, repoFile);
        }
    }

    public Date getCryptoRepoFileCreated() {
        return CryptoRepoFile.dnGetcryptoRepoFileCreated(this);
    }

    public void setCryptoRepoFileCreated(Date cryptoRepoFileCreated) {
        if (!Util.equal((Object)CryptoRepoFile.dnGetcryptoRepoFileCreated(this), (Object)cryptoRepoFileCreated)) {
            CryptoRepoFile.dnSetcryptoRepoFileCreated(this, cryptoRepoFileCreated);
        }
    }

    public CryptoKey getCryptoKey() {
        return CryptoRepoFile.dnGetcryptoKey(this);
    }

    public void setCryptoKey(CryptoKey cryptoKey) {
        if (!Util.equal((Object)((Object)CryptoRepoFile.dnGetcryptoKey(this)), (Object)((Object)cryptoKey))) {
            CryptoKeyRole cryptoKeyRole;
            if (cryptoKey != null && CryptoKeyRole.dataKey != (cryptoKeyRole = (CryptoKeyRole)AssertUtil.assertNotNull((Object)cryptoKey.getCryptoKeyRole(), (String)"cryptoKey.cryptoKeyRole"))) {
                throw new IllegalArgumentException("cryptoKey.cryptoKeyRole != dataKey");
            }
            CryptoRepoFile.dnSetcryptoKey(this, cryptoKey);
        }
    }

    public byte[] getRepoFileDtoData() {
        return CryptoRepoFile.dnGetrepoFileDtoData(this);
    }

    public void setRepoFileDtoData(byte[] repoFileDtoData) {
        if (!Util.equal((byte[])CryptoRepoFile.dnGetrepoFileDtoData(this), (byte[])repoFileDtoData)) {
            CryptoRepoFile.dnSetrepoFileDtoData(this, repoFileDtoData);
        }
    }

    public long getLocalRevision() {
        return CryptoRepoFile.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)CryptoRepoFile.dnGetlocalRevision(this), (long)localRevision)) {
            CryptoRepoFile.dnSetlocalRevision(this, localRevision);
        }
    }

    public UUID getLastSyncFromRepositoryId() {
        return CryptoRepoFile.dnGetlastSyncFromRepositoryId(this) == null ? null : UUID.fromString(CryptoRepoFile.dnGetlastSyncFromRepositoryId(this));
    }

    public void setLastSyncFromRepositoryId(UUID repositoryId) {
        if (!Util.equal((Object)this.getLastSyncFromRepositoryId(), (Object)repositoryId)) {
            CryptoRepoFile.dnSetlastSyncFromRepositoryId(this, repositoryId == null ? null : repositoryId.toString());
        }
    }

    public void jdoPreStore() {
        this.getCryptoRepoFileId();
        this.assertUniqueRepoFile();
    }

    private void assertUniqueRepoFile() {
        if (CryptoRepoFile.dnGetrepoFile(this) == null) {
            return;
        }
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)((Object)this));
        AssertUtil.assertNotNull((Object)pm, (String)"JDOHelper.getPersistenceManager(this)");
        javax.jdo.Query q = pm.newNamedQuery(CryptoRepoFile.class, "getCryptoRepoFile_repoFile");
        CryptoRepoFile other = (CryptoRepoFile)((Object)q.execute((Object)CryptoRepoFile.dnGetrepoFile(this)));
        if (other != null && !this.equals((Object)other)) {
            throw new IllegalStateException(String.format("Constraint violation: There is already another CryptoRepoFile (id=%s) referencing the same RepoFile (id=%s)!", other.getId(), CryptoRepoFile.dnGetrepoFile(this).getId()));
        }
    }

    public List<CryptoRepoFile> getPathList() {
        LinkedList<CryptoRepoFile> path = new LinkedList<CryptoRepoFile>();
        for (CryptoRepoFile crf = this; crf != null; crf = crf.getParent()) {
            path.addFirst(crf);
        }
        return Collections.unmodifiableList(path);
    }

    public String getServerPath() {
        StringBuilder sb = new StringBuilder();
        for (CryptoRepoFile crf : this.getPathList()) {
            if (crf.getParent() == null) continue;
            if (sb.length() == 0 || sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            sb.append(crf.getCryptoRepoFileId().toString());
        }
        return sb.toString();
    }

    public String getLocalPathOrFail() {
        StringBuilder sb = new StringBuilder();
        for (CryptoRepoFile crf : this.getPathList()) {
            if (crf.getParent() == null) continue;
            if (sb.length() == 0 || sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            sb.append((String)AssertUtil.assertNotNull((Object)crf.getLocalName(), (String)"cryptoRepoFile.localName"));
        }
        return sb.toString();
    }

    public boolean isDirectory() {
        return CryptoRepoFile.dnGetdirectory(this);
    }

    public void setDirectory(boolean directory) {
        if (!Util.equal((boolean)CryptoRepoFile.dnGetdirectory(this), (boolean)directory)) {
            CryptoRepoFile.dnSetdirectory(this, directory);
        }
    }

    public String getSignedDataType() {
        return "CryptoRepoFile";
    }

    public Date getDeleted() {
        return CryptoRepoFile.dnGetdeleted(this);
    }

    public void setDeleted(Date deleted) {
        if (!Util.equal((Object)CryptoRepoFile.dnGetdeleted(this), (Object)deleted)) {
            CryptoRepoFile.dnSetdeleted(this, deleted);
        }
    }

    public boolean isDeletedByIgnoreRule() {
        return CryptoRepoFile.dnGetdeletedByIgnoreRule(this);
    }

    public void setDeletedByIgnoreRule(boolean deletedByIgnoreRule) {
        if (!Util.equal((boolean)CryptoRepoFile.dnGetdeletedByIgnoreRule(this), (boolean)deletedByIgnoreRule)) {
            CryptoRepoFile.dnSetdeletedByIgnoreRule(this, deletedByIgnoreRule);
        }
    }

    public int getSignedDataVersion() {
        return 2;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[11];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource(CryptoRepoFile.dnGetparent(this) == null ? null : CryptoRepoFile.dnGetparent(this).getCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource(CryptoRepoFile.dnGetcryptoKey(this) == null ? null : CryptoRepoFile.dnGetcryptoKey(this).getCryptoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource((byte[])this.getRepoFileDtoData());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[7] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[8] = InputStreamSource.Helper.createInputStreamSource((boolean)CryptoRepoFile.dnGetdirectory(this));
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[9] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[10] = InputStreamSource.Helper.createInputStreamSource((Date)CryptoRepoFile.dnGetdeleted(this));
            LinkedList<InputStreamSource> inputStreamSources = new LinkedList<InputStreamSource>(Arrays.asList(inputStreamSourceArray));
            if (signedDataVersion >= 1) {
                separatorIndex = (byte)(separatorIndex + 1);
                inputStreamSources.add(InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex));
                inputStreamSources.add(InputStreamSource.Helper.createInputStreamSource((boolean)CryptoRepoFile.dnGetdeletedByIgnoreRule(this)));
            }
            if (signedDataVersion >= 2) {
                separatorIndex = (byte)(separatorIndex + 1);
                inputStreamSources.add(InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex));
                inputStreamSources.add(InputStreamSource.Helper.createInputStreamSource((Date)CryptoRepoFile.dnGetcryptoRepoFileCreated(this)));
            }
            if (signedDataVersion < 0 || signedDataVersion > 2) {
                throw new IllegalStateException("signedDataVersion=" + signedDataVersion);
            }
            return new MultiInputStream(inputStreamSources);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return CryptoRepoFile.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)CryptoRepoFile.dnGetsignature(this), (Object)signature)) {
            CryptoRepoFile.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        return (Uid)AssertUtil.assertNotNull((Object)this.getCryptoRepoFileId(), (String)"cryptoRepoFileId");
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.write;
    }

    public String toString() {
        return String.format("%s{cryptoRepoFileId=%s, localName=%s, deleted=%s}", super.toString(), CryptoRepoFile.dnGetcryptoRepoFileId(this), CryptoRepoFile.dnGetlocalName(this), CryptoRepoFile.dnGetdeleted(this));
    }

    static {
        dnFieldNames = CryptoRepoFile.__dnFieldNamesInit();
        dnFieldTypes = CryptoRepoFile.__dnFieldTypesInit();
        dnFieldFlags = CryptoRepoFile.__dnFieldFlagsInit();
        dnInheritedFieldCount = CryptoRepoFile.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = CryptoRepoFile.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)CryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.CryptoRepoFile"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new CryptoRepoFile());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        CryptoRepoFile result = new CryptoRepoFile();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        CryptoRepoFile result = new CryptoRepoFile();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoKey = (CryptoKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 1: {
                this.cryptoRepoFileCreated = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.cryptoRepoFileId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.deleted = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.deletedByIgnoreRule = this.dnStateManager.replacingBooleanField((Persistable)this, index);
                break;
            }
            case 5: {
                this.directory = this.dnStateManager.replacingBooleanField((Persistable)this, index);
                break;
            }
            case 6: {
                this.lastSyncFromRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.localName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 8: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 9: {
                this.parent = (CryptoRepoFile)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 10: {
                this.repoFile = (RepoFile)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 11: {
                this.repoFileDtoData = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 12: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoKey);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoRepoFileCreated);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.cryptoRepoFileId);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.deleted);
                break;
            }
            case 4: {
                this.dnStateManager.providedBooleanField((Persistable)this, index, this.deletedByIgnoreRule);
                break;
            }
            case 5: {
                this.dnStateManager.providedBooleanField((Persistable)this, index, this.directory);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.lastSyncFromRepositoryId);
                break;
            }
            case 7: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.localName);
                break;
            }
            case 8: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.parent);
                break;
            }
            case 10: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.repoFile);
                break;
            }
            case 11: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.repoFileDtoData);
                break;
            }
            case 12: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(CryptoRepoFile obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoKey = obj.cryptoKey;
                break;
            }
            case 1: {
                this.cryptoRepoFileCreated = obj.cryptoRepoFileCreated;
                break;
            }
            case 2: {
                this.cryptoRepoFileId = obj.cryptoRepoFileId;
                break;
            }
            case 3: {
                this.deleted = obj.deleted;
                break;
            }
            case 4: {
                this.deletedByIgnoreRule = obj.deletedByIgnoreRule;
                break;
            }
            case 5: {
                this.directory = obj.directory;
                break;
            }
            case 6: {
                this.lastSyncFromRepositoryId = obj.lastSyncFromRepositoryId;
                break;
            }
            case 7: {
                this.localName = obj.localName;
                break;
            }
            case 8: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 9: {
                this.parent = obj.parent;
                break;
            }
            case 10: {
                this.repoFile = obj.repoFile;
                break;
            }
            case 11: {
                this.repoFileDtoData = obj.repoFileDtoData;
                break;
            }
            case 12: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof CryptoRepoFile)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.CryptoRepoFile");
        }
        CryptoRepoFile other = (CryptoRepoFile)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"cryptoKey", "cryptoRepoFileCreated", "cryptoRepoFileId", "deleted", "deletedByIgnoreRule", "directory", "lastSyncFromRepositoryId", "localName", "localRevision", "parent", "repoFile", "repoFileDtoData", "signature"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{CryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.CryptoKey"), CryptoRepoFile.___dn$loadClass("java.util.Date"), CryptoRepoFile.___dn$loadClass("java.lang.String"), CryptoRepoFile.___dn$loadClass("java.util.Date"), Boolean.TYPE, Boolean.TYPE, CryptoRepoFile.___dn$loadClass("java.lang.String"), CryptoRepoFile.___dn$loadClass("java.lang.String"), Long.TYPE, CryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.CryptoRepoFile"), CryptoRepoFile.___dn$loadClass("co.codewizards.cloudstore.local.persistence.RepoFile"), CryptoRepoFile.___dn$loadClass("[B"), CryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.SignatureImpl")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{10, 21, 21, 21, 21, 21, 21, 21, 21, 10, 10, 26, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 13 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return CryptoRepoFile.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        CryptoRepoFile o = (CryptoRepoFile)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static CryptoKey dnGetcryptoKey(CryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (CryptoKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoKey));
        }
        return objPC.cryptoKey;
    }

    private static void dnSetcryptoKey(CryptoRepoFile objPC, CryptoKey val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoKey, (Object)val);
        }
    }

    private static Date dnGetcryptoRepoFileCreated(CryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFileCreated);
        }
        return objPC.cryptoRepoFileCreated;
    }

    private static void dnSetcryptoRepoFileCreated(CryptoRepoFile objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFileCreated, (Object)val);
        } else {
            objPC.cryptoRepoFileCreated = val;
        }
    }

    private static String dnGetcryptoRepoFileId(CryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.cryptoRepoFileId);
        }
        return objPC.cryptoRepoFileId;
    }

    private static void dnSetcryptoRepoFileId(CryptoRepoFile objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.cryptoRepoFileId, val);
        } else {
            objPC.cryptoRepoFileId = val;
        }
    }

    private static Date dnGetdeleted(CryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.deleted);
        }
        return objPC.deleted;
    }

    private static void dnSetdeleted(CryptoRepoFile objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.deleted, (Object)val);
        } else {
            objPC.deleted = val;
        }
    }

    private static boolean dnGetdeletedByIgnoreRule(CryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getBooleanField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.deletedByIgnoreRule);
        }
        return objPC.deletedByIgnoreRule;
    }

    private static void dnSetdeletedByIgnoreRule(CryptoRepoFile objPC, boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setBooleanField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.deletedByIgnoreRule, val);
        } else {
            objPC.deletedByIgnoreRule = val;
        }
    }

    private static boolean dnGetdirectory(CryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getBooleanField((Persistable)objPC, 5 + dnInheritedFieldCount, objPC.directory);
        }
        return objPC.directory;
    }

    private static void dnSetdirectory(CryptoRepoFile objPC, boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setBooleanField((Persistable)objPC, 5 + dnInheritedFieldCount, objPC.directory, val);
        } else {
            objPC.directory = val;
        }
    }

    private static String dnGetlastSyncFromRepositoryId(CryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId);
        }
        return objPC.lastSyncFromRepositoryId;
    }

    private static void dnSetlastSyncFromRepositoryId(CryptoRepoFile objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId, val);
        } else {
            objPC.lastSyncFromRepositoryId = val;
        }
    }

    private static String dnGetlocalName(CryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 7 + dnInheritedFieldCount, objPC.localName);
        }
        return objPC.localName;
    }

    private static void dnSetlocalName(CryptoRepoFile objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 7 + dnInheritedFieldCount, objPC.localName, val);
        } else {
            objPC.localName = val;
        }
    }

    private static long dnGetlocalRevision(CryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 8 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(CryptoRepoFile objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 8 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static CryptoRepoFile dnGetparent(CryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9 + dnInheritedFieldCount)) {
            return (CryptoRepoFile)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 9 + dnInheritedFieldCount, (Object)objPC.parent));
        }
        return objPC.parent;
    }

    private static void dnSetparent(CryptoRepoFile objPC, CryptoRepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.parent = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9 + dnInheritedFieldCount, (Object)objPC.parent, (Object)val);
        }
    }

    private static RepoFile dnGetrepoFile(CryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 10 + dnInheritedFieldCount)) {
            return (RepoFile)objPC.dnStateManager.getObjectField((Persistable)objPC, 10 + dnInheritedFieldCount, (Object)objPC.repoFile);
        }
        return objPC.repoFile;
    }

    private static void dnSetrepoFile(CryptoRepoFile objPC, RepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.repoFile = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 10 + dnInheritedFieldCount, (Object)objPC.repoFile, (Object)val);
        }
    }

    private static byte[] dnGetrepoFileDtoData(CryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 11 + dnInheritedFieldCount)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 11 + dnInheritedFieldCount, (Object)objPC.repoFileDtoData);
        }
        return objPC.repoFileDtoData;
    }

    private static void dnSetrepoFileDtoData(CryptoRepoFile objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.repoFileDtoData = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 11 + dnInheritedFieldCount, (Object)objPC.repoFileDtoData, (Object)val);
        }
    }

    private static SignatureImpl dnGetsignature(CryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 12 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 12 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(CryptoRepoFile objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 12 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

