/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.bean;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

public class WeakPropertyChangeListener
implements PropertyChangeListener {
    private static ReferenceQueue<PropertyChangeListener> listenerRefQueue = new ReferenceQueue();
    private static Map<Reference<PropertyChangeListener>, WeakPropertyChangeListener> listenerRef2WeakPropertyChangeListener = Collections.synchronizedMap(new IdentityHashMap());
    private final Object bean;
    private final Object property;
    private final WeakReference<PropertyChangeListener> listenerRef;
    private boolean registered;

    public WeakPropertyChangeListener(Object bean, PropertyChangeListener listener) {
        this(bean, null, listener);
    }

    public WeakPropertyChangeListener(Object bean, Object property, PropertyChangeListener listener) {
        WeakPropertyChangeListener.expunge();
        this.bean = AssertUtil.assertNotNull(bean, "bean");
        this.property = property;
        this.listenerRef = new WeakReference<PropertyChangeListener>(listener, listenerRefQueue);
        listenerRef2WeakPropertyChangeListener.put(this.listenerRef, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        WeakPropertyChangeListener.expunge();
        PropertyChangeListener listener = (PropertyChangeListener)this.listenerRef.get();
        if (listener != null) {
            listener.propertyChange(event);
        }
    }

    private static void expunge() {
        Reference<PropertyChangeListener> ref;
        while ((ref = listenerRefQueue.poll()) != null) {
            WeakPropertyChangeListener weakPropertyChangeListener = listenerRef2WeakPropertyChangeListener.remove(ref);
            if (weakPropertyChangeListener == null) continue;
            weakPropertyChangeListener.removePropertyChangeListener();
        }
    }

    public synchronized void addPropertyChangeListener() {
        if (this.registered) {
            return;
        }
        if (this.property != null) {
            ReflectionUtil.invoke(this.bean, "addPropertyChangeListener", this.property, this);
        } else {
            ReflectionUtil.invoke(this.bean, "addPropertyChangeListener", this);
        }
        this.registered = true;
    }

    public synchronized void removePropertyChangeListener() {
        if (!this.registered) {
            return;
        }
        if (this.property != null) {
            ReflectionUtil.invoke(this.bean, "removePropertyChangeListener", this.property, this);
        } else {
            ReflectionUtil.invoke(this.bean, "removePropertyChangeListener", this);
        }
        this.registered = false;
    }
}

