/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp;

import co.codewizards.cloudstore.core.collection.ReverseListView;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.subshare.core.pgp.PgpKeyAlgorithm;
import org.subshare.core.pgp.PgpKeyFingerprint;
import org.subshare.core.pgp.PgpKeyFlag;
import org.subshare.core.pgp.PgpKeyId;

public class PgpKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final PgpKeyId TEST_DUMMY_PGP_KEY_ID = new PgpKeyId(0L);
    public static final PgpKey TEST_DUMMY_PGP_KEY = new PgpKey(TEST_DUMMY_PGP_KEY_ID, new PgpKeyFingerprint(new byte[0]), null, new Date(), null, PgpKeyAlgorithm.RSA, 4096, true, Collections.emptyList(), EnumSet.of(PgpKeyFlag.CAN_AUTHENTICATE, PgpKeyFlag.CAN_CERTIFY, PgpKeyFlag.CAN_SIGN, PgpKeyFlag.CAN_ENCRYPT_COMMS, PgpKeyFlag.CAN_ENCRYPT_STORAGE), false, false);
    private final PgpKeyId pgpKeyId;
    private final PgpKeyFingerprint fingerprint;
    private final Date created;
    private final Date validTo;
    private final PgpKeyAlgorithm algorithm;
    private final int strength;
    private final boolean secretKeyAvailable;
    private final List<String> userIds;
    private final Set<PgpKeyFlag> pgpKeyFlags;
    private final boolean revoked;
    private final boolean disabled;
    private final PgpKey masterKey;
    private List<PgpKey> subKeys;
    private static final List<PgpKey> NULL_SUB_KEYS;

    public PgpKey(PgpKeyId pgpKeyId, PgpKeyFingerprint fingerprint, PgpKey masterKey, Date created, Date validTo, PgpKeyAlgorithm algorithm, int strength, boolean secretKeyAvailable, List<String> userIds, Set<PgpKeyFlag> pgpKeyFlags, boolean revoked, boolean disabled) {
        this.pgpKeyId = (PgpKeyId)AssertUtil.assertNotNull((Object)pgpKeyId, (String)"pgpKeyId");
        this.fingerprint = (PgpKeyFingerprint)AssertUtil.assertNotNull((Object)fingerprint, (String)"fingerprint");
        this.masterKey = masterKey == null ? this : masterKey;
        this.created = (Date)AssertUtil.assertNotNull((Object)created, (String)"created");
        this.validTo = validTo;
        this.algorithm = (PgpKeyAlgorithm)((Object)AssertUtil.assertNotNull((Object)((Object)algorithm), (String)"algorithm"));
        this.strength = strength;
        this.secretKeyAvailable = secretKeyAvailable;
        this.userIds = Collections.unmodifiableList(new ArrayList((Collection)AssertUtil.assertNotNull(userIds, (String)"userIds")));
        EnumSet<PgpKeyFlag> tmpPgpKeyFlags = EnumSet.noneOf(PgpKeyFlag.class);
        tmpPgpKeyFlags.addAll((Collection)AssertUtil.assertNotNull(pgpKeyFlags, (String)"pgpKeyFlags"));
        this.pgpKeyFlags = Collections.unmodifiableSet(tmpPgpKeyFlags);
        this.revoked = revoked;
        this.disabled = disabled;
    }

    public PgpKeyId getPgpKeyId() {
        return this.pgpKeyId;
    }

    public PgpKeyFingerprint getFingerprint() {
        return this.fingerprint;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public boolean isValid(Date date) {
        if (this.isDisabled()) {
            return false;
        }
        if (this.isRevoked()) {
            return false;
        }
        if (date == null) {
            date = new Date();
        }
        if (date.before(this.created)) {
            return false;
        }
        return this.validTo == null || date.before(this.validTo);
    }

    public PgpKeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isSecretKeyAvailable() {
        return this.secretKeyAvailable;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public Set<PgpKeyFlag> getPgpKeyFlags() {
        return this.pgpKeyFlags;
    }

    public PgpKey getMasterKey() {
        return (PgpKey)AssertUtil.assertNotNull((Object)this.masterKey, (String)"masterKey");
    }

    public void setSubKeys(List<PgpKey> subKeys) {
        if (this.subKeys != null) {
            throw new IllegalStateException("this.subKeys already assigned!");
        }
        this.subKeys = subKeys == null ? NULL_SUB_KEYS : Collections.unmodifiableList(new ArrayList((Collection)AssertUtil.assertNotNull(subKeys, (String)"subKeys")));
    }

    public List<PgpKey> getMasterKeyAndSubKeys() {
        PgpKey mk = this.getMasterKey();
        List<PgpKey> subKeys = mk.getSubKeys();
        ArrayList<PgpKey> result = new ArrayList<PgpKey>(subKeys.size() + 1);
        result.add(mk);
        result.addAll(subKeys);
        return Collections.unmodifiableList(result);
    }

    public PgpKey getPgpKeyForEncryptionOrFail() {
        Date now = new Date();
        ReverseListView allKeys = new ReverseListView(this.getMasterKeyAndSubKeys());
        int keysSupportingEncryptStorage = 0;
        int keysSupportingEncryptComms = 0;
        PgpKey result = null;
        for (PgpKey key : allKeys) {
            if (!key.getPgpKeyFlags().contains((Object)PgpKeyFlag.CAN_ENCRYPT_STORAGE)) continue;
            ++keysSupportingEncryptStorage;
            if (key.isRevoked() || !key.isValid(now)) continue;
            result = key;
        }
        if (result == null) {
            for (PgpKey key : allKeys) {
                if (!key.getPgpKeyFlags().contains((Object)PgpKeyFlag.CAN_ENCRYPT_COMMS)) continue;
                ++keysSupportingEncryptComms;
                if (key.isRevoked() || !key.isValid(now)) continue;
                result = key;
            }
        }
        if (result == null) {
            PgpKey mk = this.getMasterKey();
            throw new IllegalStateException(String.format("Neither any sub-key nor the master-key %s are suitable for encryption! There are %s keys with flag 'CAN_ENCRYPT_STORAGE' and %s keys with flag 'CAN_ENCRYPT_COMMS' (all of them revoked or expired).", mk.getPgpKeyId(), keysSupportingEncryptStorage, keysSupportingEncryptComms));
        }
        return result;
    }

    public PgpKey getPgpKeyForSignatureOrFail() {
        Date now = new Date();
        ReverseListView allKeys = new ReverseListView(this.getMasterKeyAndSubKeys());
        int keysSupportingSign = 0;
        int keysSupportingCertify = 0;
        PgpKey result = null;
        for (PgpKey key : allKeys) {
            if (!key.getPgpKeyFlags().contains((Object)PgpKeyFlag.CAN_SIGN)) continue;
            ++keysSupportingSign;
            if (key.isRevoked() || !key.isValid(now)) continue;
            result = key;
        }
        if (result == null) {
            for (PgpKey key : allKeys) {
                if (!key.getPgpKeyFlags().contains((Object)PgpKeyFlag.CAN_CERTIFY)) continue;
                ++keysSupportingCertify;
                if (key.isRevoked() || !key.isValid(now)) continue;
                result = key;
            }
        }
        if (result == null) {
            PgpKey mk = this.getMasterKey();
            throw new IllegalStateException(String.format("Neither any sub-key nor the master-key %s are suitable for signing! There are %s keys with flag 'CAN_SIGN' and %s keys with flag 'CAN_CERTIFY' (all of them revoked or expired).", mk.getPgpKeyId(), keysSupportingSign, keysSupportingCertify));
        }
        return result;
    }

    public List<PgpKey> getSubKeys() {
        return this.subKeys == NULL_SUB_KEYS ? null : this.subKeys;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pgpKeyId == null ? 0 : this.pgpKeyId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PgpKey other = (PgpKey)obj;
        return Util.equal((Object)this.pgpKeyId, (Object)other.pgpKeyId);
    }

    public String toString() {
        return String.format("%s[%s, %s]", this.getClass().getSimpleName(), this.pgpKeyId, this.userIds);
    }

    static {
        TEST_DUMMY_PGP_KEY.setSubKeys(Collections.emptyList());
        NULL_SUB_KEYS = Collections.unmodifiableList(new ArrayList(0));
    }
}

