/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.maintree;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javafx.collections.SetChangeListener;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.subshare.core.user.User;
import org.subshare.gui.maintree.MainTreeItem;
import org.subshare.gui.maintree.UserMainTreeItem;
import org.subshare.gui.user.EditUserManager;
import org.subshare.gui.userlist.UserListPane;

public class UserListMainTreeItem
extends MainTreeItem<String> {
    private static final Image icon = new Image(UserListMainTreeItem.class.getResource("user-list_16x16.png").toExternalForm());
    private final EditUserManager editUserManager = new EditUserManager();
    private final SetChangeListener<User> editedUsersListener = new SetChangeListener<User>(){

        public void onChanged(SetChangeListener.Change<? extends User> c) {
            User userRemoved;
            User userAdded = (User)c.getElementAdded();
            if (userAdded != null) {
                UserListMainTreeItem.this.addTreeItemsViewCallback(Collections.singleton(userAdded));
                UserListMainTreeItem.this.selectUser(userAdded);
            }
            if ((userRemoved = (User)c.getElementRemoved()) != null) {
                UserListMainTreeItem.this.removeTreeItemsViewCallback(Collections.singleton(userRemoved));
            }
        }
    };

    public UserListMainTreeItem() {
        super("Users");
        this.setGraphic((Node)new ImageView(icon));
        this.editUserManager.getEditedUsers().addListener(this.editedUsersListener);
        this.editUserManager.addEditUserListener(event -> {
            User user = this.getLast(event.getUsers());
            if (user != null) {
                this.selectUser(user);
            }
        });
        this.addTreeItemsViewCallback((Collection<User>)this.editUserManager.getEditedUsers());
    }

    private User getLast(Collection<? extends User> users) {
        User result = null;
        Iterator<? extends User> iterator = users.iterator();
        while (iterator.hasNext()) {
            User user;
            result = user = iterator.next();
        }
        return result;
    }

    private void addTreeItemsViewCallback(Collection<User> users) {
        AssertUtil.assertNotNull(users, (String)"users");
        for (User user : users) {
            this.getChildren().add((Object)new UserMainTreeItem(this.editUserManager, user));
        }
    }

    private void selectUser(User user) {
        UserMainTreeItem userMainTreeItem;
        AssertUtil.assertNotNull((Object)user, (String)"user");
        if (!this.isExpanded()) {
            this.setExpanded(true);
        }
        if ((userMainTreeItem = this.getUserMainTreeItem(user)) != null) {
            this.getTreeView().getSelectionModel().select((Object)userMainTreeItem);
        }
    }

    private UserMainTreeItem getUserMainTreeItem(User user) {
        for (TreeItem child : this.getChildren()) {
            UserMainTreeItem umti = (UserMainTreeItem)child;
            if (!user.equals(umti.getValueObject())) continue;
            return umti;
        }
        return null;
    }

    private void removeTreeItemsViewCallback(Collection<User> users) {
        AssertUtil.assertNotNull(users, (String)"users");
        Set<Object> userSet = users instanceof Set ? (Set)Util.cast(users) : new HashSet<User>(users);
        ArrayList<UserMainTreeItem> itemsToRemove = new ArrayList<UserMainTreeItem>(users.size());
        for (TreeItem child : this.getChildren()) {
            UserMainTreeItem umti = (UserMainTreeItem)child;
            User user = (User)umti.getValueObject();
            if (!userSet.contains(user)) continue;
            itemsToRemove.add(umti);
        }
        this.getChildren().removeAll(itemsToRemove);
    }

    @Override
    protected Parent createMainDetailContent() {
        return new UserListPane(this.editUserManager);
    }
}

