/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.server;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.subshare.core.dto.ServerDto;
import org.subshare.core.server.Server;
import org.subshare.core.server.ServerImpl;

public class ServerDtoConverter {
    public ServerDto toServerDto(Server server) {
        AssertUtil.assertNotNull((Object)server, (String)"server");
        ServerDto serverDto = new ServerDto();
        serverDto.setServerId(server.getServerId());
        serverDto.setName(server.getName());
        serverDto.setUrl(server.getUrl() == null ? null : server.getUrl().toExternalForm());
        serverDto.setChanged(server.getChanged());
        return serverDto;
    }

    public Server fromServerDto(ServerDto serverDto) {
        AssertUtil.assertNotNull((Object)serverDto, (String)"serverDto");
        ServerImpl server = new ServerImpl(serverDto.getServerId());
        server.setName(serverDto.getName());
        try {
            server.setUrl(serverDto.getUrl() == null ? null : new URL(serverDto.getUrl()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        server.setChanged(serverDto.getChanged());
        return server;
    }
}

