/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.inmemory;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.ArrayExpression;
import org.datanucleus.query.expression.CaseExpression;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.inmemory.InMemoryFailure;
import org.datanucleus.query.inmemory.InvocationEvaluator;
import org.datanucleus.query.inmemory.SetExpression;
import org.datanucleus.query.inmemory.VariableNotSetException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Imports;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class InMemoryExpressionEvaluator
extends AbstractExpressionEvaluator {
    String queryLanguage = null;
    Deque stack = new LinkedList();
    Map parameterValues;
    Map<String, Object> variableValues;
    Map<String, Object> state;
    Imports imports;
    ExecutionContext ec;
    ClassLoaderResolver clr;
    QueryManager queryMgr;
    final String candidateAlias;

    public InMemoryExpressionEvaluator(ExecutionContext ec, Map params, Map<String, Object> state, Imports imports, ClassLoaderResolver clr, String candidateAlias, String queryLang) {
        this.ec = ec;
        this.queryMgr = ec.getStoreManager().getQueryManager();
        this.parameterValues = params != null ? params : new HashMap();
        this.state = state;
        this.imports = imports;
        this.clr = clr;
        this.candidateAlias = candidateAlias;
        this.queryLanguage = queryLang;
    }

    public Map getParameterValues() {
        return this.parameterValues;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    @Override
    protected Object processAndExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure || right instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        this.stack.push(left == Boolean.TRUE && right == Boolean.TRUE ? Boolean.TRUE : Boolean.FALSE);
        return this.stack.peek();
    }

    @Override
    protected Object processEqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure || right instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        Boolean result = QueryUtils.compareExpressionValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    @Override
    protected Object processLikeExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure || right instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        if (!(left instanceof String)) {
            throw new NucleusUserException("LIKE expression can only be used on a String expression, but found on " + left.getClass().getName());
        }
        if (right instanceof String) {
            Boolean result = ((String)left).matches((String)right) ? Boolean.TRUE : Boolean.FALSE;
            this.stack.push(result);
            return result;
        }
        throw new NucleusUserException("Dont currently support expression on right of LIKE to be other than String but was " + right.getClass().getName());
    }

    @Override
    protected Object processNoteqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure || right instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        Boolean result = QueryUtils.compareExpressionValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    @Override
    protected Object processOrExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        this.stack.push(left == Boolean.TRUE || right == Boolean.TRUE ? Boolean.TRUE : Boolean.FALSE);
        return this.stack.peek();
    }

    @Override
    protected Object processGteqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure || right instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        Boolean result = QueryUtils.compareExpressionValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    @Override
    protected Object processGtExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure || right instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        Boolean result = QueryUtils.compareExpressionValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    @Override
    protected Object processIsExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure || right instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        if (!(right instanceof Class)) {
            throw new NucleusException("Attempt to invoke instanceof with argument of type " + right.getClass().getName() + " has to be Class");
        }
        try {
            Boolean result = ((Class)right).isAssignableFrom(left.getClass()) ? Boolean.TRUE : Boolean.FALSE;
            this.stack.push(result);
            return result;
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException("Attempt to invoke instanceof with " + right + " yet class was not found!");
        }
    }

    @Override
    protected Object processIsnotExpression(Expression expr) {
        this.processIsExpression(expr);
        Boolean val = (Boolean)this.stack.pop();
        val = val == false;
        this.stack.push(val);
        return val;
    }

    @Override
    protected Object processCastExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure || right instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        throw new NucleusException("CAST not yet supported in in-memory evaluator");
    }

    @Override
    protected Object processLteqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure || right instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        Boolean result = QueryUtils.compareExpressionValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    @Override
    protected Object processLtExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure || right instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        Boolean result = QueryUtils.compareExpressionValues(left, right, expr.getOperator()) ? Boolean.TRUE : Boolean.FALSE;
        this.stack.push(result);
        return this.stack.peek();
    }

    @Override
    protected Object processAddExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Object value = null;
        if (right instanceof String && left instanceof String) {
            value = "" + left + right;
        } else if (right instanceof Number && left instanceof Number) {
            value = new BigDecimal(left.toString()).add(new BigDecimal(right.toString()));
        } else if (left instanceof String) {
            value = "" + left + right;
        } else {
            throw new NucleusException("Performing ADD operation on " + left + " and " + right + " is not supported");
        }
        this.stack.push(value);
        return this.stack.peek();
    }

    @Override
    protected Object processSubExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        BigDecimal value = new BigDecimal(left.toString()).subtract(new BigDecimal(right.toString()));
        this.stack.push(value);
        return this.stack.peek();
    }

    @Override
    protected Object processDivExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        double firstValue = new BigDecimal(left.toString()).doubleValue();
        double secondValue = new BigDecimal(right.toString()).doubleValue();
        BigDecimal value = new BigDecimal(firstValue / secondValue);
        this.stack.push(value);
        return this.stack.peek();
    }

    @Override
    protected Object processModExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        BigDecimal firstValue = new BigDecimal(left.toString());
        BigDecimal divisor = new BigDecimal(right.toString());
        BigDecimal value = firstValue.subtract(firstValue.divideToIntegralValue(divisor).multiply(divisor));
        this.stack.push(value);
        return this.stack.peek();
    }

    @Override
    protected Object processMulExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        BigDecimal value = new BigDecimal(left.toString()).multiply(new BigDecimal(right.toString()));
        this.stack.push(value);
        return this.stack.peek();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object processNegExpression(Expression expr) {
        Number val = null;
        if (expr instanceof DyadicExpression) {
            DyadicExpression dyExpr = (DyadicExpression)expr;
            if (dyExpr.getLeft() instanceof PrimaryExpression) {
                val = (Number)this.getValueForPrimaryExpression((PrimaryExpression)expr.getLeft());
            } else {
                if (!(dyExpr.getLeft() instanceof ParameterExpression)) throw new NucleusException("No current support for negation of dyadic expression on type " + dyExpr.getLeft().getClass().getName());
                val = (Number)QueryUtils.getValueForParameterExpression(this.parameterValues, (ParameterExpression)expr.getLeft());
            }
        } else {
            if (!(expr instanceof Literal)) throw new NucleusException("No current support for negation of expression of type " + expr.getClass().getName());
            throw new NucleusException("No current support for negation of expression of type Literal");
        }
        if (val instanceof Integer) {
            this.stack.push(-val.intValue());
            return this.stack.peek();
        }
        if (val instanceof Long) {
            this.stack.push(-val.longValue());
            return this.stack.peek();
        }
        if (val instanceof Short) {
            this.stack.push(-val.shortValue());
            return this.stack.peek();
        }
        if (val instanceof BigInteger) {
            this.stack.push(BigInteger.valueOf(-val.longValue()));
            return this.stack.peek();
        }
        if (val instanceof Double) {
            this.stack.push(-val.doubleValue());
            return this.stack.peek();
        }
        if (val instanceof Float) {
            this.stack.push(Float.valueOf(-val.floatValue()));
            return this.stack.peek();
        }
        if (!(val instanceof BigDecimal)) throw new NucleusException("Attempt to negate value of type " + val + " not supported");
        this.stack.push(new BigDecimal(-val.doubleValue()));
        return this.stack.peek();
    }

    @Override
    protected Object processComExpression(Expression expr) {
        PrimaryExpression primExpr = (PrimaryExpression)expr.getLeft();
        Object primVal = this.getValueForPrimaryExpression(primExpr);
        int val = -1;
        if (primVal instanceof Number) {
            val = ((Number)primVal).intValue();
        }
        Integer result = ~val;
        this.stack.push(result);
        return this.stack.peek();
    }

    @Override
    protected Object processNotExpression(Expression expr) {
        Object left = this.stack.pop();
        if (left instanceof InMemoryFailure) {
            this.stack.push(Boolean.FALSE);
            return this.stack.peek();
        }
        Boolean leftExpr = (Boolean)left;
        Boolean result = leftExpr != false ? Boolean.FALSE : Boolean.TRUE;
        this.stack.push(result);
        return this.stack.peek();
    }

    @Override
    protected Object processCreatorExpression(CreatorExpression expr) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < expr.getArguments().size(); ++i) {
            params.add(expr.getArguments().get(i).evaluate(this));
        }
        Class cls = this.imports.resolveClassDeclaration(expr.getId(), this.clr, null);
        Object value = QueryUtils.createResultObjectUsingArgumentedConstructor(cls, params.toArray(), null);
        this.stack.push(value);
        return value;
    }

    @Override
    protected Object processInvokeExpression(InvokeExpression expr) {
        Object result = this.getValueForInvokeExpression(expr);
        this.stack.push(result);
        return result;
    }

    @Override
    protected Object processLiteral(Literal expr) {
        Object value = expr.getLiteral();
        this.stack.push(value);
        return value;
    }

    @Override
    protected Object processVariableExpression(VariableExpression expr) {
        if (expr.getLeft() == null && this.state.containsKey(expr.getId())) {
            Object value = this.state.get(expr.getId());
            if (value == null) {
                NucleusLogger.QUERY.warn("Variable expression " + expr.getId() + " doesnt have its value set yet. Unsupported query structure");
                value = new InMemoryFailure();
            }
            this.stack.push(value);
            return value;
        }
        return super.processVariableExpression(expr);
    }

    @Override
    protected Object processParameterExpression(ParameterExpression expr) {
        Object value = QueryUtils.getValueForParameterExpression(this.parameterValues, expr);
        this.stack.push(value);
        return value;
    }

    @Override
    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Object paramValue;
        Object e = paramValue = this.parameterValues != null ? (Object)this.parameterValues.get(expr.getId()) : null;
        if (expr.getLeft() == null && paramValue != null) {
            this.stack.push(paramValue);
            return paramValue;
        }
        Object value = this.getValueForPrimaryExpression(expr);
        this.stack.push(value);
        return value;
    }

    @Override
    protected Object processCaseExpression(CaseExpression expr) {
        Map<Expression, Expression> exprs = expr.getConditions();
        for (Map.Entry<Expression, Expression> entry : exprs.entrySet()) {
            Expression keyExpr = entry.getKey();
            Expression valExpr = entry.getValue();
            Object keyResult = keyExpr.evaluate(this);
            if (keyResult instanceof Boolean) {
                if (!((Boolean)keyResult).booleanValue()) continue;
                Object value = valExpr.evaluate(this);
                this.stack.push(value);
                return value;
            }
            NucleusLogger.QUERY.error("Case expression " + expr + " clause " + keyExpr + " did not return boolean");
            InMemoryFailure value = new InMemoryFailure();
            this.stack.push(value);
            return value;
        }
        Object value = expr.getElseExpression().evaluate(this);
        this.stack.push(value);
        return value;
    }

    public Object getValueForInvokeExpression(InvokeExpression invokeExpr) {
        String method = invokeExpr.getOperation();
        if (invokeExpr.getLeft() == null) {
            if (method.toLowerCase().equals("count")) {
                HashSet coll = (HashSet)this.state.get("DATANUCLEUS_RESULTS_SET");
                SetExpression setexpr = new SetExpression(coll, this.candidateAlias);
                Expression paramExpr = invokeExpr.getArguments().get(0);
                if (paramExpr.getOperator() == Expression.OP_DISTINCT) {
                    HashSet processable;
                    coll = processable = new HashSet(coll);
                }
                int stackSizeOrig = this.stack.size();
                Object returnVal = setexpr.count(paramExpr, this);
                while (this.stack.size() > stackSizeOrig) {
                    this.stack.pop();
                }
                return returnVal;
            }
            if (method.toLowerCase().equals("sum")) {
                HashSet coll = (HashSet)this.state.get("DATANUCLEUS_RESULTS_SET");
                SetExpression setexpr = new SetExpression(coll, this.candidateAlias);
                Expression paramExpr = invokeExpr.getArguments().get(0);
                if (paramExpr.getOperator() == Expression.OP_DISTINCT) {
                    HashSet processable;
                    coll = processable = new HashSet(coll);
                }
                int stackSizeOrig = this.stack.size();
                Object returnVal = setexpr.sum(paramExpr, this, this.state);
                while (this.stack.size() > stackSizeOrig) {
                    this.stack.pop();
                }
                return returnVal;
            }
            if (method.toLowerCase().equals("avg")) {
                HashSet coll = (HashSet)this.state.get("DATANUCLEUS_RESULTS_SET");
                SetExpression setexpr = new SetExpression(coll, this.candidateAlias);
                Expression paramExpr = invokeExpr.getArguments().get(0);
                if (paramExpr.getOperator() == Expression.OP_DISTINCT) {
                    HashSet processable;
                    coll = processable = new HashSet(coll);
                }
                int stackSizeOrig = this.stack.size();
                Object returnVal = setexpr.avg(paramExpr, this, this.state);
                while (this.stack.size() > stackSizeOrig) {
                    this.stack.pop();
                }
                return returnVal;
            }
            if (method.toLowerCase().equals("min")) {
                HashSet coll = (HashSet)this.state.get("DATANUCLEUS_RESULTS_SET");
                SetExpression setexpr = new SetExpression(coll, this.candidateAlias);
                Expression paramExpr = invokeExpr.getArguments().get(0);
                if (paramExpr.getOperator() == Expression.OP_DISTINCT) {
                    HashSet processable;
                    coll = processable = new HashSet(coll);
                }
                int stackSizeOrig = this.stack.size();
                Object returnVal = setexpr.min(paramExpr, this, this.state);
                while (this.stack.size() > stackSizeOrig) {
                    this.stack.pop();
                }
                return returnVal;
            }
            if (method.toLowerCase().equals("max")) {
                HashSet coll = (HashSet)this.state.get("DATANUCLEUS_RESULTS_SET");
                SetExpression setexpr = new SetExpression(coll, this.candidateAlias);
                Expression paramExpr = invokeExpr.getArguments().get(0);
                if (paramExpr.getOperator() == Expression.OP_DISTINCT) {
                    HashSet processable;
                    coll = processable = new HashSet(coll);
                }
                int stackSizeOrig = this.stack.size();
                Object returnVal = setexpr.max(paramExpr, this, this.state);
                while (this.stack.size() > stackSizeOrig) {
                    this.stack.pop();
                }
                return returnVal;
            }
            InvocationEvaluator methodEval = this.queryMgr.getInMemoryEvaluatorForMethod(null, method);
            if (methodEval != null) {
                return methodEval.evaluate(invokeExpr, null, this);
            }
            NucleusLogger.QUERY.warn("Query contains call to static method " + method + " yet no support is available for in-memory evaluation of this");
            return new InMemoryFailure();
        }
        if (invokeExpr.getLeft() instanceof ParameterExpression) {
            Object invokedValue = QueryUtils.getValueForParameterExpression(this.parameterValues, (ParameterExpression)invokeExpr.getLeft());
            Class invokedType = invokedValue != null ? invokedValue.getClass() : invokeExpr.getLeft().getSymbol().getValueType();
            InvocationEvaluator methodEval = this.queryMgr.getInMemoryEvaluatorForMethod(invokedType, method);
            if (methodEval != null) {
                return methodEval.evaluate(invokeExpr, invokedValue, this);
            }
            NucleusLogger.QUERY.warn("Query contains call to method " + invokedValue.getClass().getName() + "." + method + " yet no support is available for this");
            return new InMemoryFailure();
        }
        if (invokeExpr.getLeft() instanceof PrimaryExpression) {
            Object invokedValue = this.getValueForPrimaryExpression((PrimaryExpression)invokeExpr.getLeft());
            if (invokedValue instanceof InMemoryFailure) {
                return invokedValue;
            }
            Class invokedType = invokedValue != null ? invokedValue.getClass() : invokeExpr.getLeft().getSymbol().getValueType();
            InvocationEvaluator methodEval = this.queryMgr.getInMemoryEvaluatorForMethod(invokedType, method);
            if (methodEval != null) {
                return methodEval.evaluate(invokeExpr, invokedValue, this);
            }
            NucleusLogger.QUERY.warn("Query contains call to method " + invokedType.getName() + "." + method + " yet no support is available for this");
            return new InMemoryFailure();
        }
        if (invokeExpr.getLeft() instanceof InvokeExpression) {
            Class invokedType;
            Object invokedValue = this.getValueForInvokeExpression((InvokeExpression)invokeExpr.getLeft());
            Class clazz = invokedValue != null ? invokedValue.getClass() : (invokedType = invokeExpr.getLeft().getSymbol() != null ? invokeExpr.getLeft().getSymbol().getValueType() : null);
            if (invokedType == null) {
                return new InMemoryFailure();
            }
            InvocationEvaluator methodEval = this.queryMgr.getInMemoryEvaluatorForMethod(invokedType, method);
            if (methodEval != null) {
                return methodEval.evaluate(invokeExpr, invokedValue, this);
            }
            NucleusLogger.QUERY.warn("Query contains call to method " + invokedType.getName() + "." + method + " yet no support is available for this");
            return new InMemoryFailure();
        }
        if (invokeExpr.getLeft() instanceof VariableExpression) {
            Object invokedValue = this.getValueForVariableExpression((VariableExpression)invokeExpr.getLeft());
            Class invokedType = invokedValue != null ? invokedValue.getClass() : invokeExpr.getLeft().getSymbol().getValueType();
            InvocationEvaluator methodEval = this.queryMgr.getInMemoryEvaluatorForMethod(invokedType, method);
            if (methodEval != null) {
                return methodEval.evaluate(invokeExpr, invokedValue, this);
            }
            NucleusLogger.QUERY.warn("Query contains call to method " + invokedType.getName() + "." + method + " yet no support is available for this");
            return new InMemoryFailure();
        }
        if (invokeExpr.getLeft() instanceof Literal) {
            Object invokedValue = ((Literal)invokeExpr.getLeft()).getLiteral();
            Class invokedType = invokedValue != null ? invokedValue.getClass() : invokeExpr.getLeft().getSymbol().getValueType();
            InvocationEvaluator methodEval = this.queryMgr.getInMemoryEvaluatorForMethod(invokedType, method);
            if (methodEval != null) {
                return methodEval.evaluate(invokeExpr, invokedValue, this);
            }
            NucleusLogger.QUERY.warn("Query contains call to method " + invokedType.getName() + "." + method + " yet no support is available for this");
            return new InMemoryFailure();
        }
        if (invokeExpr.getLeft() instanceof ArrayExpression) {
            Object invokedValue = this.getValueForArrayExpression((ArrayExpression)invokeExpr.getLeft());
            Class<?> invokedType = invokedValue.getClass();
            InvocationEvaluator methodEval = this.queryMgr.getInMemoryEvaluatorForMethod(invokedType, method);
            if (methodEval != null) {
                return methodEval.evaluate(invokeExpr, invokedValue, this);
            }
            NucleusLogger.QUERY.warn("Query contains call to method " + invokedType.getName() + "." + method + " yet no support is available for this");
            return new InMemoryFailure();
        }
        NucleusLogger.QUERY.warn("No support is available for in-memory evaluation of methods invoked on expressions of type " + invokeExpr.getLeft().getClass().getName());
        return new InMemoryFailure();
    }

    private Object getValueForArrayExpression(ArrayExpression arrayExpr) {
        Object[] value = new Object[arrayExpr.getArraySize()];
        for (int i = 0; i < Array.getLength(value); ++i) {
            Expression elem = arrayExpr.getElement(i);
            if (elem instanceof Literal) {
                Array.set(value, i, ((Literal)elem).getLiteral());
                continue;
            }
            if (elem instanceof PrimaryExpression) {
                Array.set(value, i, this.getValueForPrimaryExpression((PrimaryExpression)elem));
                continue;
            }
            if (elem instanceof ParameterExpression) {
                Array.set(value, i, QueryUtils.getValueForParameterExpression(this.parameterValues, (ParameterExpression)elem));
                continue;
            }
            NucleusLogger.QUERY.warn("No support is available for array expression with element of type " + elem.getClass().getName());
            return new InMemoryFailure();
        }
        return value;
    }

    public int getIntegerForLiteral(Literal lit) {
        Object val = lit.getLiteral();
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).intValue();
        }
        if (val instanceof BigInteger) {
            return ((BigInteger)val).intValue();
        }
        if (val instanceof Long) {
            return ((Long)val).intValue();
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Short) {
            return ((Short)val).intValue();
        }
        throw new NucleusException("Attempt to convert literal with value " + val + " (" + val.getClass().getName() + ") into an int failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValueForPrimaryExpression(PrimaryExpression primExpr) {
        Object value = null;
        if (primExpr.getLeft() != null) {
            if (primExpr.getLeft() instanceof DyadicExpression) {
                Class castClass;
                String castClassName;
                DyadicExpression dyExpr = (DyadicExpression)primExpr.getLeft();
                if (dyExpr.getOperator() != Expression.OP_CAST) {
                    NucleusLogger.QUERY.error("Dont currently support PrimaryExpression starting with DyadicExpression of " + dyExpr);
                    return new InMemoryFailure();
                }
                Expression castLeftExpr = dyExpr.getLeft();
                if (castLeftExpr instanceof PrimaryExpression) {
                    value = this.getValueForPrimaryExpression((PrimaryExpression)castLeftExpr);
                    castClassName = (String)((Literal)dyExpr.getRight()).getLiteral();
                    if (value != null && !(castClass = this.imports.resolveClassDeclaration(castClassName, this.clr, null)).isAssignableFrom(value.getClass())) {
                        NucleusLogger.QUERY.warn("Candidate for query results in attempt to cast " + StringUtils.toJVMIDString(value) + " to " + castClass.getName() + " which is impossible!");
                        return new InMemoryFailure();
                    }
                } else {
                    if (!(castLeftExpr instanceof VariableExpression)) {
                        NucleusLogger.QUERY.warn("Dont currently support CastExpression of " + castLeftExpr);
                        return new InMemoryFailure();
                    }
                    value = this.getValueForVariableExpression((VariableExpression)castLeftExpr);
                    castClassName = (String)((Literal)dyExpr.getRight()).getLiteral();
                    if (value != null && !(castClass = this.imports.resolveClassDeclaration(castClassName, this.clr, null)).isAssignableFrom(value.getClass())) {
                        NucleusLogger.QUERY.warn("Candidate for query results in attempt to cast " + StringUtils.toJVMIDString(value) + " to " + castClass.getName() + " which is impossible!");
                        return new InMemoryFailure();
                    }
                }
            } else if (primExpr.getLeft() instanceof ParameterExpression) {
                value = QueryUtils.getValueForParameterExpression(this.parameterValues, (ParameterExpression)primExpr.getLeft());
            } else {
                if (!(primExpr.getLeft() instanceof VariableExpression)) {
                    NucleusLogger.QUERY.warn("Dont currently support PrimaryExpression with left-side of " + primExpr.getLeft());
                    return new InMemoryFailure();
                }
                VariableExpression varExpr = (VariableExpression)primExpr.getLeft();
                try {
                    value = this.getValueForVariableExpression(varExpr);
                }
                catch (VariableNotSetException vnse) {
                    NucleusLogger.QUERY.error("Attempt to access variable " + varExpr.getId() + " as part of primaryExpression " + primExpr);
                    return new InMemoryFailure();
                }
            }
        }
        int firstTupleToProcess = 0;
        if (value == null) {
            if (this.state.containsKey(primExpr.getTuples().get(0))) {
                value = this.state.get(primExpr.getTuples().get(0));
                firstTupleToProcess = 1;
            } else if (this.state.containsKey(this.candidateAlias)) {
                value = this.state.get(this.candidateAlias);
            }
        }
        int i = firstTupleToProcess;
        while (i < primExpr.getTuples().size()) {
            String fieldName = primExpr.getTuples().get(i);
            if (!fieldName.equals(this.candidateAlias)) {
                ObjectProvider valueOP;
                boolean getValueByReflection = true;
                if (this.ec.getApiAdapter().isPersistent(value) && (valueOP = this.ec.findObjectProvider(value)) != null) {
                    AbstractMemberMetaData mmd = valueOP.getClassMetaData().getMetaDataForMember(fieldName);
                    if (mmd == null) {
                        NucleusLogger.QUERY.error("Cannot find " + fieldName + " member of " + valueOP.getClassMetaData().getFullClassName());
                        return new InMemoryFailure();
                    }
                    if (mmd.getAbsoluteFieldNumber() >= 0) {
                        valueOP.isLoaded(mmd.getAbsoluteFieldNumber());
                        value = valueOP.provideField(mmd.getAbsoluteFieldNumber());
                        getValueByReflection = false;
                    }
                }
                if (getValueByReflection) {
                    value = ClassUtils.getValueOfFieldByReflection(value, fieldName);
                }
            }
            ++i;
        }
        return value;
    }

    public void setVariableValue(String id, Object value) {
        if (this.variableValues == null) {
            this.variableValues = new HashMap<String, Object>();
        }
        this.variableValues.put(id, value);
    }

    public void removeVariableValue(String id) {
        this.variableValues.remove(id);
    }

    public Object getValueForVariableExpression(VariableExpression varExpr) {
        if (this.variableValues == null || !this.variableValues.containsKey(varExpr.getId())) {
            throw new VariableNotSetException(varExpr);
        }
        return this.variableValues.get(varExpr.getId());
    }
}

