/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Indices;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.CryptoKeyType;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CryptoKeyDeactivation;
import org.subshare.local.persistence.CryptoLink;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Unique(name="CryptoKey_cryptoKeyId", members={"cryptoKeyId"})
@Indices(value={@Index(name="CryptoKey_localRevision", members={"localRevision"}), @Index(name="CryptoKey_cryptoKeyRole", members={"cryptoKeyRole"})})
@Queries(value={@Query(name="getCryptoKey_cryptoKeyId", value="SELECT UNIQUE WHERE this.cryptoKeyId == :cryptoKeyId"), @Query(name="getActiveCryptoKeys_cryptoRepoFile_cryptoKeyRole", value="SELECT WHERE this.cryptoRepoFile == :cryptoRepoFile && this.cryptoKeyRole == :cryptoKeyRole && this.cryptoKeyDeactivation == null"), @Query(name="getCryptoKeys_cryptoRepoFile", value="SELECT WHERE this.cryptoRepoFile == :cryptoRepoFile"), @Query(name="getCryptoKeysChangedAfter_localRevision_exclLastSyncFromRepositoryId", value="SELECT WHERE this.localRevision > :localRevision && (this.lastSyncFromRepositoryId == null || this.lastSyncFromRepositoryId != :lastSyncFromRepositoryId)")})
public class CryptoKey
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String cryptoKeyId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private CryptoRepoFile cryptoRepoFile;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(jdbcType="INTEGER")
    private CryptoKeyRole cryptoKeyRole;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(jdbcType="INTEGER")
    private CryptoKeyType cryptoKeyType;
    private long localRevision;
    private String lastSyncFromRepositoryId;
    @Persistent(mappedBy="toCryptoKey", dependentElement="true")
    private Set<CryptoLink> inCryptoLinks;
    @Persistent(mappedBy="fromCryptoKey")
    private Set<CryptoLink> outCryptoLinks;
    @Persistent(dependent="true")
    private CryptoKeyDeactivation cryptoKeyDeactivation;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public CryptoKey() {
    }

    public CryptoKey(Uid cryptoKeyId) {
        this.cryptoKeyId = cryptoKeyId == null ? null : cryptoKeyId.toString();
    }

    public Uid getCryptoKeyId() {
        if (CryptoKey.dnGetcryptoKeyId(this) == null) {
            CryptoKey.dnSetcryptoKeyId(this, new Uid().toString());
        }
        return new Uid(CryptoKey.dnGetcryptoKeyId(this));
    }

    public CryptoKeyDeactivation getCryptoKeyDeactivation() {
        return CryptoKey.dnGetcryptoKeyDeactivation(this);
    }

    public void setCryptoKeyDeactivation(CryptoKeyDeactivation cryptoKeyDeactivation) {
        if (Util.equal((Object)((Object)CryptoKey.dnGetcryptoKeyDeactivation(this)), (Object)((Object)cryptoKeyDeactivation))) {
            return;
        }
        if (cryptoKeyDeactivation != null) {
            if (cryptoKeyDeactivation.getCryptoKey() != null && !this.equals((Object)cryptoKeyDeactivation.getCryptoKey())) {
                throw new IllegalArgumentException("cryptoKeyDeactivation is already assigned to a different CryptoKey!");
            }
            cryptoKeyDeactivation.setCryptoKey(this);
        }
        CryptoKey.dnSetcryptoKeyDeactivation(this, cryptoKeyDeactivation);
    }

    public CryptoRepoFile getCryptoRepoFile() {
        return CryptoKey.dnGetcryptoRepoFile(this);
    }

    public void setCryptoRepoFile(CryptoRepoFile cryptoRepoFile) {
        if (!Util.equal((Object)((Object)CryptoKey.dnGetcryptoRepoFile(this)), (Object)((Object)cryptoRepoFile))) {
            CryptoKey.dnSetcryptoRepoFile(this, cryptoRepoFile);
        }
    }

    public CryptoKeyRole getCryptoKeyRole() {
        return CryptoKey.dnGetcryptoKeyRole(this);
    }

    public void setCryptoKeyRole(CryptoKeyRole cryptoKeyRole) {
        if (!Util.equal((Object)CryptoKey.dnGetcryptoKeyRole(this), (Object)cryptoKeyRole)) {
            CryptoKey.dnSetcryptoKeyRole(this, cryptoKeyRole);
        }
    }

    public CryptoKeyType getCryptoKeyType() {
        return CryptoKey.dnGetcryptoKeyType(this);
    }

    public void setCryptoKeyType(CryptoKeyType cryptoKeyType) {
        if (!Util.equal((Object)CryptoKey.dnGetcryptoKeyType(this), (Object)cryptoKeyType)) {
            CryptoKey.dnSetcryptoKeyType(this, cryptoKeyType);
        }
    }

    public Set<CryptoLink> getInCryptoLinks() {
        if (CryptoKey.dnGetinCryptoLinks(this) == null) {
            CryptoKey.dnSetinCryptoLinks(this, new HashSet());
        }
        return CryptoKey.dnGetinCryptoLinks(this);
    }

    public Set<CryptoLink> getOutCryptoLinks() {
        if (CryptoKey.dnGetoutCryptoLinks(this) == null) {
            CryptoKey.dnSetoutCryptoLinks(this, new HashSet());
        }
        return CryptoKey.dnGetoutCryptoLinks(this);
    }

    public long getLocalRevision() {
        return CryptoKey.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)CryptoKey.dnGetlocalRevision(this), (long)localRevision)) {
            CryptoKey.dnSetlocalRevision(this, localRevision);
        }
    }

    public void jdoPreStore() {
        this.getCryptoKeyId();
    }

    public String getSignedDataType() {
        return "CryptoKey";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[7];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getCryptoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((Uid)CryptoKey.dnGetcryptoRepoFile(this).getCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((int)CryptoKey.dnGetcryptoKeyRole(this).ordinal());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource((int)CryptoKey.dnGetcryptoKeyType(this).ordinal());
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return CryptoKey.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)CryptoKey.dnGetsignature(this), (Object)signature)) {
            CryptoKey.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        return (Uid)AssertUtil.assertNotNull((Object)((CryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)CryptoKey.dnGetcryptoRepoFile(this)), (String)"cryptoRepoFile"))).getCryptoRepoFileId(), (String)"cryptoRepoFile.cryptoRepoFileId");
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        if (CryptoKey.dnGetcryptoKeyRole(this) == null) {
            throw new IllegalStateException("cryptoKeyRole == null");
        }
        return CryptoKey.dnGetcryptoKeyRole(this) == CryptoKeyRole.clearanceKey ? PermissionType.grant : PermissionType.write;
    }

    public String toString() {
        return String.format("%s{cryptoKeyId=%s, cryptoRepoFile=%s, cryptoKeyType=%s, cryptoKeyRole=%s}", new Object[]{super.toString(), CryptoKey.dnGetcryptoKeyId(this), CryptoKey.dnGetcryptoRepoFile(this), CryptoKey.dnGetcryptoKeyType(this), CryptoKey.dnGetcryptoKeyRole(this)});
    }

    public UUID getLastSyncFromRepositoryId() {
        return CryptoKey.dnGetlastSyncFromRepositoryId(this) == null ? null : UUID.fromString(CryptoKey.dnGetlastSyncFromRepositoryId(this));
    }

    public void setLastSyncFromRepositoryId(UUID repositoryId) {
        if (!Util.equal((Object)this.getLastSyncFromRepositoryId(), (Object)repositoryId)) {
            CryptoKey.dnSetlastSyncFromRepositoryId(this, repositoryId == null ? null : repositoryId.toString());
        }
    }

    static {
        dnFieldNames = CryptoKey.__dnFieldNamesInit();
        dnFieldTypes = CryptoKey.__dnFieldTypesInit();
        dnFieldFlags = CryptoKey.__dnFieldFlagsInit();
        dnInheritedFieldCount = CryptoKey.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = CryptoKey.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)CryptoKey.___dn$loadClass("org.subshare.local.persistence.CryptoKey"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new CryptoKey());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        CryptoKey result = new CryptoKey();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        CryptoKey result = new CryptoKey();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoKeyDeactivation = (CryptoKeyDeactivation)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 1: {
                this.cryptoKeyId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.cryptoKeyRole = (CryptoKeyRole)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.cryptoKeyType = (CryptoKeyType)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.cryptoRepoFile = (CryptoRepoFile)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 5: {
                this.inCryptoLinks = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.lastSyncFromRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 8: {
                this.outCryptoLinks = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 9: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoKeyDeactivation);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.cryptoKeyId);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoKeyRole);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoKeyType);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoRepoFile);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.inCryptoLinks);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.lastSyncFromRepositoryId);
                break;
            }
            case 7: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 8: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.outCryptoLinks);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(CryptoKey obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoKeyDeactivation = obj.cryptoKeyDeactivation;
                break;
            }
            case 1: {
                this.cryptoKeyId = obj.cryptoKeyId;
                break;
            }
            case 2: {
                this.cryptoKeyRole = obj.cryptoKeyRole;
                break;
            }
            case 3: {
                this.cryptoKeyType = obj.cryptoKeyType;
                break;
            }
            case 4: {
                this.cryptoRepoFile = obj.cryptoRepoFile;
                break;
            }
            case 5: {
                this.inCryptoLinks = obj.inCryptoLinks;
                break;
            }
            case 6: {
                this.lastSyncFromRepositoryId = obj.lastSyncFromRepositoryId;
                break;
            }
            case 7: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 8: {
                this.outCryptoLinks = obj.outCryptoLinks;
                break;
            }
            case 9: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof CryptoKey)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.CryptoKey");
        }
        CryptoKey other = (CryptoKey)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"cryptoKeyDeactivation", "cryptoKeyId", "cryptoKeyRole", "cryptoKeyType", "cryptoRepoFile", "inCryptoLinks", "lastSyncFromRepositoryId", "localRevision", "outCryptoLinks", "signature"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{CryptoKey.___dn$loadClass("org.subshare.local.persistence.CryptoKeyDeactivation"), CryptoKey.___dn$loadClass("java.lang.String"), CryptoKey.___dn$loadClass("org.subshare.core.dto.CryptoKeyRole"), CryptoKey.___dn$loadClass("org.subshare.core.dto.CryptoKeyType"), CryptoKey.___dn$loadClass("org.subshare.local.persistence.CryptoRepoFile"), CryptoKey.___dn$loadClass("java.util.Set"), CryptoKey.___dn$loadClass("java.lang.String"), Long.TYPE, CryptoKey.___dn$loadClass("java.util.Set"), CryptoKey.___dn$loadClass("org.subshare.local.persistence.SignatureImpl")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{10, 21, 21, 21, 10, 10, 21, 21, 10, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 10 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return CryptoKey.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        CryptoKey o = (CryptoKey)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static CryptoKeyDeactivation dnGetcryptoKeyDeactivation(CryptoKey objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (CryptoKeyDeactivation)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoKeyDeactivation));
        }
        return objPC.cryptoKeyDeactivation;
    }

    private static void dnSetcryptoKeyDeactivation(CryptoKey objPC, CryptoKeyDeactivation val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoKeyDeactivation = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoKeyDeactivation, (Object)val);
        }
    }

    private static String dnGetcryptoKeyId(CryptoKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.cryptoKeyId);
        }
        return objPC.cryptoKeyId;
    }

    private static void dnSetcryptoKeyId(CryptoKey objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.cryptoKeyId, val);
        } else {
            objPC.cryptoKeyId = val;
        }
    }

    private static CryptoKeyRole dnGetcryptoKeyRole(CryptoKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (CryptoKeyRole)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.cryptoKeyRole);
        }
        return objPC.cryptoKeyRole;
    }

    private static void dnSetcryptoKeyRole(CryptoKey objPC, CryptoKeyRole val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.cryptoKeyRole, (Object)val);
        } else {
            objPC.cryptoKeyRole = val;
        }
    }

    private static CryptoKeyType dnGetcryptoKeyType(CryptoKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return (CryptoKeyType)objPC.dnStateManager.getObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.cryptoKeyType);
        }
        return objPC.cryptoKeyType;
    }

    private static void dnSetcryptoKeyType(CryptoKey objPC, CryptoKeyType val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.cryptoKeyType, (Object)val);
        } else {
            objPC.cryptoKeyType = val;
        }
    }

    private static CryptoRepoFile dnGetcryptoRepoFile(CryptoKey objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return (CryptoRepoFile)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFile));
        }
        return objPC.cryptoRepoFile;
    }

    private static void dnSetcryptoRepoFile(CryptoKey objPC, CryptoRepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoRepoFile = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFile, (Object)val);
        }
    }

    private static Set dnGetinCryptoLinks(CryptoKey objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5 + dnInheritedFieldCount)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, objPC.inCryptoLinks);
        }
        return objPC.inCryptoLinks;
    }

    private static void dnSetinCryptoLinks(CryptoKey objPC, Set val) {
        if (objPC.dnStateManager == null) {
            objPC.inCryptoLinks = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, objPC.inCryptoLinks, (Object)val);
        }
    }

    private static String dnGetlastSyncFromRepositoryId(CryptoKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId);
        }
        return objPC.lastSyncFromRepositoryId;
    }

    private static void dnSetlastSyncFromRepositoryId(CryptoKey objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId, val);
        } else {
            objPC.lastSyncFromRepositoryId = val;
        }
    }

    private static long dnGetlocalRevision(CryptoKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 7 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(CryptoKey objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 7 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static Set dnGetoutCryptoLinks(CryptoKey objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8 + dnInheritedFieldCount)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 8 + dnInheritedFieldCount, objPC.outCryptoLinks);
        }
        return objPC.outCryptoLinks;
    }

    private static void dnSetoutCryptoLinks(CryptoKey objPC, Set val) {
        if (objPC.dnStateManager == null) {
            objPC.outCryptoLinks = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 8 + dnInheritedFieldCount, objPC.outCryptoLinks, (Object)val);
        }
    }

    private static SignatureImpl dnGetsignature(CryptoKey objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 9 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(CryptoKey objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

