/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Uniques(value={@Unique(name="DeletedCollision_collisionId", members={"collisionId"})})
@Queries(value={@Query(name="getDeletedCollision_collisionId", value="SELECT UNIQUE WHERE this.collisionId == :collisionId"), @Query(name="getDeletedCollisionsChangedAfter_localRevision", value="SELECT WHERE this.localRevision > :localRevision")})
public class DeletedCollision
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String collisionId;
    private long localRevision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    protected DeletedCollision() {
    }

    public DeletedCollision(Uid collisionId) {
        this.collisionId = ((Uid)AssertUtil.assertNotNull((Object)collisionId, (String)"collisionId")).toString();
    }

    public Uid getCollisionId() {
        return new Uid(DeletedCollision.dnGetcollisionId(this));
    }

    public String getSignedDataType() {
        return "Collision";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            return new MultiInputStream(new InputStreamSource[]{InputStreamSource.Helper.createInputStreamSource((Uid)this.getCollisionId())});
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return DeletedCollision.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)DeletedCollision.dnGetsignature(this), (Object)signature)) {
            DeletedCollision.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public long getLocalRevision() {
        return DeletedCollision.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)DeletedCollision.dnGetlocalRevision(this), (long)localRevision)) {
            DeletedCollision.dnSetlocalRevision(this, localRevision);
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        return null;
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.write;
    }

    static {
        dnFieldNames = DeletedCollision.__dnFieldNamesInit();
        dnFieldTypes = DeletedCollision.__dnFieldTypesInit();
        dnFieldFlags = DeletedCollision.__dnFieldFlagsInit();
        dnInheritedFieldCount = DeletedCollision.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = DeletedCollision.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)DeletedCollision.___dn$loadClass("org.subshare.local.persistence.DeletedCollision"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new DeletedCollision());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        DeletedCollision result = new DeletedCollision();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        DeletedCollision result = new DeletedCollision();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.collisionId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 2: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.collisionId);
                break;
            }
            case 1: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(DeletedCollision obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.collisionId = obj.collisionId;
                break;
            }
            case 1: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 2: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof DeletedCollision)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.DeletedCollision");
        }
        DeletedCollision other = (DeletedCollision)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"collisionId", "localRevision", "signature"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{DeletedCollision.___dn$loadClass("java.lang.String"), Long.TYPE, DeletedCollision.___dn$loadClass("org.subshare.local.persistence.SignatureImpl")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 21, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 3 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return DeletedCollision.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        DeletedCollision o = (DeletedCollision)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static String dnGetcollisionId(DeletedCollision objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.collisionId);
        }
        return objPC.collisionId;
    }

    private static void dnSetcollisionId(DeletedCollision objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.collisionId, val);
        } else {
            objPC.collisionId = val;
        }
    }

    private static long dnGetlocalRevision(DeletedCollision objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(DeletedCollision objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static SignatureImpl dnGetsignature(DeletedCollision objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(DeletedCollision objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

