/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.client.request;

import co.codewizards.cloudstore.core.dto.ChangeSetDto;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.client.request.AbstractRequest;
import javax.ws.rs.client.WebTarget;

public class GetChangeSetDto
extends AbstractRequest<ChangeSetDto> {
    private final String repositoryName;
    private final boolean localSync;
    private final Long lastSyncToRemoteRepoLocalRepositoryRevisionSynced;

    public GetChangeSetDto(String repositoryName, boolean localSync, Long lastSyncToRemoteRepoLocalRepositoryRevisionSynced) {
        this.repositoryName = (String)AssertUtil.assertNotNull((Object)repositoryName, (String)"repositoryName");
        this.localSync = localSync;
        this.lastSyncToRemoteRepoLocalRepositoryRevisionSynced = lastSyncToRemoteRepoLocalRepositoryRevisionSynced;
    }

    @Override
    public ChangeSetDto execute() {
        WebTarget webTarget = this.createWebTarget(this.getPath(ChangeSetDto.class), GetChangeSetDto.urlEncode(this.repositoryName));
        if (this.localSync) {
            webTarget = webTarget.queryParam("localSync", new Object[]{this.localSync});
        }
        if (this.lastSyncToRemoteRepoLocalRepositoryRevisionSynced != null) {
            webTarget = webTarget.queryParam("lastSyncToRemoteRepoLocalRepositoryRevisionSynced", new Object[]{this.lastSyncToRemoteRepoLocalRepositoryRevisionSynced});
        }
        ChangeSetDto changeSetDto = (ChangeSetDto)this.assignCredentials(webTarget.request(new String[]{"application/xml"})).get(ChangeSetDto.class);
        return changeSetDto;
    }

    @Override
    public boolean isResultNullable() {
        return false;
    }
}

