/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.certify;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpSignatureType;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.pgp.certify.CertifyPgpKeyData;
import org.subshare.gui.pgp.certify.Messages;
import org.subshare.gui.pgp.createkey.FxPgpUserId;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class CertifyPgpKeyPane
extends WizardPageContentGridPane {
    protected final CertifyPgpKeyData certifyPgpKeyData;
    protected final PgpKey pgpKey;
    @FXML
    private Text headerText;
    @FXML
    protected ToggleGroup toggleGroup;
    @FXML
    private TextField keyIdTextField;
    @FXML
    private TableView<FxPgpUserId> userIdsTableView;
    @FXML
    private TextField fingerprintTextField;
    @FXML
    private VBox radioButtonBox;
    @FXML
    private ComboBox<PgpKey> signKeyComboBox;
    private Map<PgpSignatureType, RadioButton> certificationLevel2RadioButton = new HashMap<PgpSignatureType, RadioButton>();

    public CertifyPgpKeyPane(CertifyPgpKeyData certifyPgpKeyData) {
        this.certifyPgpKeyData = (CertifyPgpKeyData)AssertUtil.assertNotNull((Object)certifyPgpKeyData, (String)"certifyPgpKeyData");
        this.pgpKey = (PgpKey)AssertUtil.assertNotNull((Object)certifyPgpKeyData.getPgpKey(), (String)"certifyPgpKeyData.pgpKey");
        FxmlUtil.loadDynamicComponentFxml(CertifyPgpKeyPane.class, this);
        if (CertifyPgpKeyPane.class == this.getClass()) {
            this.init();
        }
    }

    protected void init() {
        this.headerText.setText(String.format(Messages.getString("CertifyPgpKeyPane.headerText.text"), this.pgpKey.getPgpKeyId().toHumanString()));
        this.certifyPgpKeyData.signPgpKeyProperty().bind((ObservableValue)this.signKeyComboBox.getSelectionModel().selectedItemProperty());
        this.certifyPgpKeyData.signPgpKeyProperty().addListener(observable -> this.updateComplete());
        this.keyIdTextField.setText(this.pgpKey.getPgpKeyId().toHumanString());
        this.populateUserIdsTableView();
        this.fingerprintTextField.setText(this.pgpKey.getFingerprint().toHumanString());
        this.populateSignKeyComboBox();
        this.populateRadioButtonBox();
        this.certifyPgpKeyData.certificationLevelProperty().addListener(observable -> this.updateToggleGroup());
        this.updateToggleGroup();
    }

    protected RadioButton getRadioButtonForCertificationLevel() {
        PgpSignatureType certificationLevel = (PgpSignatureType)this.certifyPgpKeyData.certificationLevelProperty().get();
        RadioButton radioButton = this.certificationLevel2RadioButton.get(certificationLevel);
        return radioButton;
    }

    protected PgpSignatureType getCertificationLevelForRadioButton(RadioButton radioButton) {
        AssertUtil.assertNotNull((Object)radioButton, (String)"radioButton");
        return (PgpSignatureType)radioButton.getUserData();
    }

    protected void updateToggleGroup() {
        this.toggleGroup.selectToggle((Toggle)this.getRadioButtonForCertificationLevel());
        this.updateComplete();
    }

    private void populateRadioButtonBox() {
        this.radioButtonBox.getChildren().clear();
        for (PgpSignatureType certificationLevel : PgpSignatureType.CERTIFICATIONS) {
            RadioButton radioButton = new RadioButton(certificationLevel.getAnswer());
            radioButton.setUserData((Object)certificationLevel);
            radioButton.setToggleGroup(this.toggleGroup);
            this.radioButtonBox.getChildren().add((Object)radioButton);
            this.certificationLevel2RadioButton.put(certificationLevel, radioButton);
        }
        this.toggleGroup.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            PgpSignatureType certificationLevel = newValue == null ? null : this.getCertificationLevelForRadioButton((RadioButton)newValue);
            AssertUtil.assertNotNull((Object)certificationLevel, (String)"certificationLevel");
            this.certifyPgpKeyData.setCertificationLevel(certificationLevel);
        });
    }

    private void populateUserIdsTableView() {
        for (String userIdString : this.pgpKey.getUserIds()) {
            FxPgpUserId pgpUserId = new FxPgpUserId(userIdString);
            this.userIdsTableView.getItems().add((Object)pgpUserId);
        }
    }

    private void populateSignKeyComboBox() {
        this.signKeyComboBox.setConverter((StringConverter)new StringConverter<PgpKey>(){

            public String toString(PgpKey pgpKey) {
                StringBuilder sb = new StringBuilder();
                if (!pgpKey.getUserIds().isEmpty()) {
                    sb.append((String)pgpKey.getUserIds().get(0));
                }
                sb.append(" - ");
                sb.append(pgpKey.getPgpKeyId().toHumanString());
                return sb.toString();
            }

            public PgpKey fromString(String string) {
                throw new UnsupportedOperationException();
            }
        });
        for (PgpKey pgpKey : this.getPgp().getMasterKeysWithSecretKey()) {
            this.signKeyComboBox.getItems().add((Object)pgpKey);
        }
        if (!this.signKeyComboBox.getItems().isEmpty()) {
            this.signKeyComboBox.getSelectionModel().clearAndSelect(0);
        }
    }

    @Override
    protected boolean isComplete() {
        return this.certifyPgpKeyData.getSignPgpKey() != null;
    }

    protected Pgp getPgp() {
        Pgp pgp = this.certifyPgpKeyData.getPgp();
        if (pgp != null) {
            return pgp;
        }
        return PgpLs.getPgpOrFail();
    }
}

