/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo.histo;

import co.codewizards.cloudstore.core.dto.DirectoryDto;
import co.codewizards.cloudstore.core.dto.FileChunkDto;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.dto.SymlinkDto;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.transport.LocalRepoTransport;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactory;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactoryRegistry;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.dto.PlainHistoCryptoRepoFileDto;
import org.subshare.core.repo.histo.ExportFileParam;
import org.subshare.core.repo.histo.HistoExporter;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.core.repo.sync.PaddingUtil;
import org.subshare.core.repo.transport.CryptreeRestRepoTransport;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.core.user.UserRepoKeyRingLookup;
import org.subshare.core.user.UserRepoKeyRingLookupContext;

public class HistoExporterImpl
implements HistoExporter {
    protected final File localRoot;
    protected final URL remoteRoot;
    protected final LocalRepoManager localRepoManager;
    protected final LocalRepoTransport localRepoTransport;
    protected final CryptreeRestRepoTransport remoteRepoTransport;
    protected final UUID localRepositoryId;
    protected final UUID remoteRepositoryId;

    public static HistoExporter createHistoExporter(File localRoot) {
        AssertUtil.assertNotNull((Object)localRoot, (String)"localRoot");
        return new HistoExporterImpl(localRoot);
    }

    protected HistoExporterImpl(File localRoot) {
        this.localRoot = (File)AssertUtil.assertNotNull((Object)localRoot, (String)"localRoot");
        this.localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);
        this.localRepositoryId = this.localRepoManager.getRepositoryId();
        if (this.localRepositoryId == null) {
            throw new IllegalStateException("localRepoManager.getRepositoryId() returned null!");
        }
        SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)this.localRepoManager.getLocalRepoMetaData();
        this.remoteRoot = localRepoMetaData.getRemoteRoot();
        this.remoteRepositoryId = this.localRepoManager.getRemoteRepositoryIdOrFail(this.remoteRoot);
        this.remoteRepoTransport = (CryptreeRestRepoTransport)this.createRepoTransport(this.remoteRoot, this.localRepositoryId);
        this.localRepoTransport = (LocalRepoTransport)this.createRepoTransport(localRoot, this.remoteRepositoryId);
    }

    private RepoTransport createRepoTransport(File rootFile, UUID clientRepositoryId) {
        URL rootURL;
        try {
            rootURL = rootFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return this.createRepoTransport(rootURL, clientRepositoryId);
    }

    private RepoTransport createRepoTransport(URL remoteRoot, UUID clientRepositoryId) {
        RepoTransportFactory repoTransportFactory = RepoTransportFactoryRegistry.getInstance().getRepoTransportFactoryOrFail(remoteRoot);
        return repoTransportFactory.createRepoTransport(remoteRoot, clientRepositoryId);
    }

    @Override
    public void close() {
        this.localRepoManager.close();
        this.localRepoTransport.close();
        this.remoteRepoTransport.close();
    }

    protected Cryptree getCryptree(LocalRepoTransaction tx) {
        String remotePathPrefix = "";
        UserRepoKeyRing userRepoKeyRing = UserRepoKeyRingLookup.Helper.getUserRepoKeyRingLookup().getUserRepoKeyRing(new UserRepoKeyRingLookupContext(this.localRepositoryId, this.remoteRepositoryId));
        Cryptree cryptree = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail().getCryptreeOrCreate(tx, this.remoteRepositoryId, "", userRepoKeyRing);
        return cryptree;
    }

    @Override
    public void exportFile(ExportFileParam exportFileParam) throws IOException {
        AssertUtil.assertNotNull((Object)exportFileParam, (String)"exportFileParam");
        AssertUtil.assertNotNull((Object)exportFileParam.getHistoCryptoRepoFileId(), (String)"exportFileParam.histoCryptoRepoFileId");
        AssertUtil.assertNotNull((Object)exportFileParam.getExportDirectory(), (String)"exportFileParam.exportDirectory");
        try (LocalRepoTransaction tx = this.localRepoManager.beginReadTransaction();){
            PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto = this.getCryptree(tx).getPlainHistoCryptoRepoFileDto(exportFileParam.getHistoCryptoRepoFileId());
            RepoFileDto repoFileDto = plainHistoCryptoRepoFileDto.getRepoFileDto();
            AssertUtil.assertNotNull((Object)repoFileDto, (String)"plainHistoCryptoRepoFileDto.repoFileDto");
            File exportFile = OioFileFactory.createFile((File)exportFileParam.getExportDirectory(), (String[])new String[]{repoFileDto.getName()});
            if (repoFileDto instanceof DirectoryDto) {
                if (exportFileParam.isRecursive()) {
                    throw new UnsupportedOperationException("NYI");
                }
                exportFile.mkdir();
            } else if (repoFileDto instanceof SymlinkDto) {
                SymlinkDto symlinkDto = (SymlinkDto)repoFileDto;
                exportFile.createSymbolicLink(symlinkDto.getTarget());
            } else if (repoFileDto instanceof NormalFileDto) {
                NormalFileDto normalFileDto = (NormalFileDto)repoFileDto;
                try (RandomAccessFile raf = exportFile.createRandomAccessFile("rw");){
                    for (FileChunkDto fileChunkDto : normalFileDto.getFileChunkDtos()) {
                        byte[] histoFileData = this.remoteRepoTransport.getHistoFileData(exportFileParam.getHistoCryptoRepoFileId(), fileChunkDto.getOffset());
                        histoFileData = PaddingUtil.removePadding(histoFileData);
                        raf.seek(fileChunkDto.getOffset());
                        raf.write(histoFileData);
                    }
                    raf.setLength(normalFileDto.getLength());
                }
            }
            exportFile.setLastModifiedNoFollow(repoFileDto.getLastModified().getTime());
        }
    }
}

